/*
 * @(#)ZScript.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 *
 * JavaScript invoker
 */
package jp.co.iti.fagot.util;

import java.util.Vector;
import java.util.Enumeration;

import java.io.File;
import java.io.Reader;
import java.io.FileReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import org.mozilla.classfile.*;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeJavaObject;
//import org.mozilla.javascript.NativeScript;

import jp.co.iti.fagot.ZApp;

import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;
/**
 * JavaScript Function Ăяo
 *
 * @author  N
 * @version 1.01 2002/10/23
 */
public class ZScript {

	/**
	 * RXgN^
	 */
	public ZScript() {
	}

	/**
	 * XNvg̓ǂݍ
	 * @param szURL t@C
	 */
	public boolean loadScript(String szURL) {
    try {
		// 
		mContext = Context.enter();
		mScope   = new ImporterTopLevel(mContext);
		mURL     = szURL;
//		mScope   = mContext.initStandardObjects(null);

		// t@Cǂݍ
		Reader in = new FileReader(szURL);
		mContext.evaluateReader(mScope, in, "<cmd>", 1, null);
		in.close();
	} catch ( Throwable t ) {
		ZDebug.err("Error: " + t);
		t.printStackTrace();
		return false;
	}
	return true;
	}

	/**
	 * XNvg̎s
	 * @param szURL t@C
	 */
	public Object invoke(String szFunc, Object[] args) {
	if ( mContext == null || mScope == null ) {
		ZDebug.err("not yet load");
		return null;
	}
    try {
		Object fnc = mScope.get(szFunc, mScope); 
		if (fnc instanceof Function) {
//			ZDebug.trace("### invoke method :("+mURL+"):"+szFunc ); 
			Object result = ((Function) fnc).call(mContext, mScope, mScope, args); 
//			ZDebug.trace("### invoke method(end)");
			if ( result != null && result instanceof NativeJavaObject ) {
				return ((NativeJavaObject)result).unwrap(); 
			} else {
				return null;
			}
		}
	} catch ( Throwable t ) {
		ZDebug.err("Error: " + t);
		t.printStackTrace();
	}
	ZDebug.err(szFunc+" is undefined or not a function.");
	return null;
	}

	//## Agr[g ###############################################
	/**
	 * ReLXg
	 */
	protected Context mContext = null;

	/**
	 * XR[v
	 */
	protected Scriptable mScope = null;

	/**
	 * t@CURL
	 */
	protected String mURL = null;
}
