/*
 * @(#)ZResource.java
 *
 * Copyright 2000 by Intelligent Technology Inc. All rights reserved.
 */
package jp.co.iti.fagot.util;

import java.awt.Color;
import java.awt.Window;
import java.awt.Dimension;
import java.awt.Point;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.IOException;

import java.net.URL;

import java.util.Vector;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Properties;
import java.util.Locale;
import java.util.MissingResourceException;

import jp.co.iti.fagot.util.ZGraphicUtil;
/**
 * ZResourceNX̓\[XǗ邽߂̃NXłB<br>
 * <code>ResourceBundle</code>ێNXŁAexceptionȂ悤
 * JvZĂ܂B
 *
 * ̃NXœǂݍރ\[XD揇ʂ̍ɋLq܂B
 * <ul>
 * <li>[UfBNgɑ݂铮Iȃ[UݒvpeBt@C
 * <li>CAvP[ṼpbP[WŎw肳ꂽAcodebaseɑ
 * ftHg̃\[Xt@CB
 * </ul>
 *
 * @author  N
 * @version 1.01 2000/12/01
 */
public class ZResource {
	/**
	 * RXgN^
	 * @param appClass CvO
	 */
	public ZResource(Class appClass) {
	this( appClass, null );
	}

	/**
	 * RXgN^
	 * @param appClass CvO
	 */
	public ZResource(Class appClass, Locale locale) {
	// appNXۑ
	mAppClass  = appClass;

	// ResourceBundle̎擾
	String szTmp = "";
	String szAppClass = mAppClass.getName();
	String szStr[] = ZString.tokenize(szAppClass,"." );
	for ( int nIndex = 0 ; nIndex < szStr.length-1 ; nIndex ++ ) {
		szTmp += szStr[nIndex] + "." ;
	}
	String szRes = szTmp + "resources." + szStr[szStr.length-1] ;

	// ftHg
	try {
//		ZDebug.trace();
		mRes = ResourceBundle.getBundle(szRes);
	} catch (MissingResourceException mre) {
		ZDebug.err(szRes + ".properties not found:"+mre.toString());
		mRes = null;
	}

	// D挾p\[Xoh̎擾
	try {
//		ZDebug.trace();
		mPriRes = ResourceBundle.getBundle(szRes,Locale.getDefault());
	} catch (MissingResourceException mre) {
		ZDebug.err(szRes + ".properties not found:"+mre.toString());
		mPriRes = null;
	}

	// vpeB̃[h
	mProp = new Properties();
	loadProperty(getPropertyFile());

	mResource = this;
	
	}

	/**
	 * RXgN^
	 * @param prop vpeB
	 */
	public ZResource(Properties prop) {
	// vpeB̃[h
	mProp = prop;
	}

	/**
	 * [U`\[X[h܂B
	 */
	public void loadProperty(String szUsrProps) {
//	ZDebug.trace("load:"+szUsrProps);
	try {
		FileInputStream inStream = new FileInputStream(szUsrProps);
		mProp.load(inStream);
		inStream.close();
    } catch (IOException io) {
		System.out.println("User Properties load failed: " + io);
    }
	}

	/**
	 * [U`\[XZ[u܂B
	 */
	public void saveProperty() {
	String szUsrProps = getPropertyFile();
	try	{
		OutputStream outStream = new FileOutputStream(szUsrProps);
		mProp.store(outStream,mAppClass.getName() + " Properties.");
		outStream.close();
	}
	catch(IOException io)
	{
		ZDebug.err("User Properties save failed: " + io);
	}
	}

	//## static:\[X̎擾 ########################################
	/**
	 * vpeB
	 */
	static public ZResource res() {
	return mResource;
	}

	//## vpeB̎擾 #############################################
	/**
	 * EBhEʒu擾܂B
	 * @param win EBhE
	 * @param szName EBhE
	 */
	public void loadGeometry(Window win, String szName ) {
	int x, y, width, height;
	try
	{
		width  = Integer.parseInt(getString("win." + szName + ".width"));
		height = Integer.parseInt(getString("win." + szName + ".height"));
	}
	catch(NumberFormatException nf)
	{  // \TCY0x0ɂȂ̂h~
		width  = 400;
		height = 300;
	}
	try
	{
		x = Integer.parseInt(getString("win." + szName + ".x"));
		y = Integer.parseInt(getString("win." + szName + ".y"));
	}
	catch(NumberFormatException nf)
	{	// ȂƂ́Aʒ
		Dimension screen = win.getToolkit().getScreenSize();
		x = (screen.width - width) / 2;
		y = (screen.height - height) / 2;
	}
	win.setLocation(x,y);
	win.setSize(width,height);
	}

	/**
	 * EBhEʒuۑ܂B
	 * @param win EBhE
	 * @param szName EBhE
	 */
	public void saveGeometry(Window win, String szName ) {
	Point location = win.getLocation();
	Dimension size = win.getSize();
	mProp.put("win." + szName + ".x",String.valueOf(location.x));
	mProp.put("win." + szName + ".y",String.valueOf(location.y));
	mProp.put("win." + szName + ".width",String.valueOf(size.width));
	mProp.put("win." + szName + ".height",String.valueOf(size.height));
	}

	/**
	 * L[ɑΉ郊\[X擾܂B
	 * @param szKey \[XL[[h
	 */
	public String getString(String szKey) {
	String szStr = mProp.getProperty(szKey);
//	ZDebug.trace("getString:"+szKey+"="+szStr);
	if ( szStr == null && mPriRes != null ) {
		try {
		    szStr = mPriRes.getString(szKey);
//		    ZDebug.trace("getString:"+szKey+"="+szStr);
		} catch (MissingResourceException mre) {
		    szStr = null;
//		    ZDebug.trace("Missing:"+szKey);
		}
	}

	if ( szStr == null && mRes != null ) {
		try {
		    szStr = mRes.getString(szKey);
//		    ZDebug.trace("getString:"+szKey+"="+szStr);
		} catch (MissingResourceException mre) {
		    szStr = null;
//		    ZDebug.trace("Missing:"+szKey);
		}
	}

	// RID3 Macpꏈ
	if ( szStr != null && szKey.startsWith("rid.") && szKey.endsWith(".dir") ) {
		szStr = ZString.replace(szStr,"/",File.separator);
	}

	return( szStr );
	}

	/**
	 * L[ɑΉ郊\[XQ擾܂B
	 * \[XQ́AL[ɑăV[PVȐl܂
	 * @param szKey \[XL[[h
	 */
	public Vector getStrings(String szKey) {
	Vector vec = new Vector();
	for( int nIndex=1 ; nIndex<100 ; nIndex++ ) {
		String szChildKey = szKey + nIndex ;
		String szValue = getString( szChildKey );
		if ( szValue != null ) {
			vec.add( szValue );
		} else {
			break;
		}
	}
	return vec;
	}

	/**
	 * L[ɑΉ郊\[Xl擾܂B
	 * @param szKey \[XL[[h
	 * @param nDefault ݒ̏ꍇ̃ftHgl
	 */
	public int getInt(String szKey,int nDefault) {
	String szStr;
	int    nValue;
	szStr = getString(szKey);
	if ( szStr != null ) {
		try {
			nValue = Integer.parseInt(szStr);
		}
		catch(NumberFormatException nf)
		{
			nValue = nDefault ;
		}
	} else {
		nValue = nDefault ;
	}
	return nValue;
	}

	/**
	 * L[ɑΉF擾܂B
	 * @param szKey \[XL[[h
	 */
	public Color getColor(String szKey) {
	String szStr = getString(szKey);
	return ZGraphicUtil.stringToColor(szStr);
	}

	/**
	 * L[ɑΉF擾܂B
	 *
	 * Color.decode(),Color.getColor()͂ĂɂȂȂ̂ŏC
	 *
	 * @param szStr Fw蕶
	 */
/*
	static public Color getAwtColor(String szStr) {
	Color  cCol  = null;
	if ( szStr != null && szStr.startsWith("#") ) {
		int nRed   = 0;
		int nGreen = 0;
		int nBlue  = 0;
		try {
			szStr = szStr.substring(1);
			int nSize = szStr.length() / 3;
			nRed  = Integer.parseInt(szStr.substring(0,nSize),16);
			szStr = szStr.substring(nSize);
			nGreen= Integer.parseInt(szStr.substring(0,nSize),16);
			szStr = szStr.substring(nSize);
			nBlue = Integer.parseInt(szStr.substring(0,nSize),16);
		} catch ( NumberFormatException nf ) {
			System.out.println("getAwtColor:parse error");
		}
//		System.out.println("getAwtColor:szStr="+szStr+" R="+nRed+" G="+nGreen+" B="+nBlue);
		cCol = new Color(nRed,nGreen,nBlue);
	}
	if ( cCol == null ) {
//		System.out.println("Color=null" );
		cCol = Color.white;
	}
	return cCol;
	}
*/
	/**
	 * L[ɑΉURL擾܂B
	 * @param szKey \[XL[[h
	 */
	public URL getURL(String szKey) {
	String szName = getString(szKey);
	if (szName != null) {
	    URL url = mAppClass.getResource(szName);
	    return url;
	}
	return null;
	}

	/**
	 * L[ɑΉ^l擾܂B
	 * ݒ肳ĂȂꍇfalseԂ܂
	 * @param szKey \[XL[[h
	 * @param bDefault ftHgl
	 */
	public boolean getBoolean(String szKey,boolean bDefault) {
	boolean bRet = bDefault;
	String szStr = getString(szKey);
	if ( szStr != null ) {
		if ( szStr.toLowerCase().equals("true") ) {
			bRet = true;
		} else if ( szStr.toLowerCase().equals("false") ) {
			bRet = false;
		}
	}
	return bRet;
	}

	/**
	 * L[ɑΉ^l擾܂B
	 * ݒ肳ĂȂꍇfalseԂ܂
	 * @param szKey \[XL[[h
	 */
	public boolean getBoolean(String szKey) {
	return getBoolean(szKey,false);
	}


	//## vpeB̐ݒ #############################################
	/**
	 * L[ɑΉ郊\[Xݒ肵܂B
	 * @param szKey \[XL[[h
	 * @param szValue ݒl
	 */
	public void putString(String szKey,String szValue) {
	if ( szValue == null ) {
		mProp.remove(szKey);
	} else {
		mProp.put(szKey,szValue);
	}
	}

	/**
	 * L[ɑΉ郊\[XQ擾܂B
	 * \[XQ́AL[ɑăV[PVȐl܂
	 * @param szKey \[XL[[h
	 * @param vec ݒ肷镶Q
	 */
	public void putStrings(String szKey,Vector vec) {
	Enumeration elm = vec.elements();
	int nIndex = 1;
	while ( elm.hasMoreElements() ) {
		String szChildKey = szKey + nIndex ;
		String szValue = (String)elm.nextElement();
		putString( szChildKey, szValue );
		nIndex++;
	}
	String szEndKey = szKey + nIndex ;
	putString( szEndKey, null );
	}

	/**
	 * L[ɑΉ郊\[Xݒ肵܂B
	 * @param szKey \[XL[[h
	 * @param nValue ݒl
	 */
	public void putInt(String szKey,int nValue) {
	mProp.put(szKey,String.valueOf(nValue));
	}

	/**
	 * [U`\[Xt@C擾܂B
	 */
	private String getPropertyFile() {
	String szUsrHome = System.getProperty("user.home");
	String[] szClass = ZString.tokenize(mAppClass.getName(),".");
	String szUsrProps = szUsrHome + File.separator + szClass[szClass.length-1] + ".properties";
	return (szUsrProps);
	}

	/**
	 * J[𕶎ɕϊ܂
	 *
	 * Color.decode(),Color.getColor()͂ĂɂȂȂ̂ŏC
	 *
	 * @param szStr Fw蕶
	 */
/*
	static public String getAwtColorString(Color c) {
	String szColor = null;
	if ( c != null ) {
		szColor = "#";

		String szRed   = Integer.toHexString(c.getRed());
		if ( szRed.length() == 1 ) {
			szColor += "0" + szRed.toUpperCase();
		} else {
			szColor += szRed.toUpperCase();
		}

		String szGreen = Integer.toHexString(c.getGreen());
		if ( szGreen.length() == 1 ) {
			szColor += "0" + szGreen.toUpperCase();
		} else {
			szColor += szGreen.toUpperCase();
		}

		String szBlue = Integer.toHexString(c.getBlue());
		if ( szBlue.length() == 1 ) {
			szColor += "0" + szBlue.toUpperCase();
		} else {
			szColor += szBlue.toUpperCase();
		}
	}
	return szColor;
	}
*/
	/**
	 * L[ɑΉ^lݒ肵܂B
	 * ݒ肳ĂȂꍇfalseԂ܂
	 * @param szKey \[XL[[h
	 * @param bValue ݒl
	 */
	public void putBoolean(String szKey,boolean bValue) {
	mProp.put(szKey,(bValue?"True":"False"));
	}

	//## Agr[g ###############################################
	/**
	 * \[XNX
	 */
	private Class			mAppClass;

    /**
	 * VXe\[X
	 */
	private ResourceBundle	mRes;

    /**
	 * VXe\[X
	 */
	private ResourceBundle	mPriRes;

    /**
	 * [U\[X
	 */
	private Properties		mProp;

	/**
	 * AvP[V\[X
	 */
	static protected ZResource	mResource = null;
}
