/*
 * @(#)UDialog.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */
package jp.co.iti.fagot.ui;

import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JButton;
import javax.swing.Action;
import javax.swing.JScrollPane;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

import jp.co.iti.fagot.IZApp;

import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.util.ZDebug;
/**
 * Dialognʕi
 * @author  N
 * @version 1.01 2001/01/07
 */
public class UDialog extends JDialog {
	/**
	 * RXgN^
	 * @param app     AvP[V
	 * @param szName  _CAO
	 */
	public UDialog(IZApp app,String szName) {
	super( app.getFrame(),false );

	// AvP[V̐ݒ
	mApp = app ;
	mDialogName = szName;

	setTitle()			;	// ^Cg̕\
	getApp().getResource().loadGeometry(this,mDialogName);	// ʒu擾
	}

	/**
	 * [_s
	 */
	public boolean doModal() {
	setModal(true);
	pack();
	show();
	
	// OK{^ꂽH
	return isOK() ;
	}

	/**
	 * OK{^ꂽH
	 */
	public boolean isOK() {
	return mIsOK;
	}

	//## R|[lg ###############################################
	/**
     * R|[lg̐ݒ
     * @param cmp CR|[lg
     * @param isScroll XN[̗L
	 */
	public void setComponent( JComponent cmp, boolean isScroll ) {
	if ( isScroll ) {
		mScroll = new JScrollPane();
		mScroll.setViewportView( cmp );
		mComponent = cmp;
		getContentPane().add("Center",mScroll);
	} else {
		mComponent = cmp;
		getContentPane().add("Center",mComponent);
	}
	}

	/**
     * R|[lg̎擾
	 */
	public JComponent getComponent() {
	return mComponent;
	}

	/**
     * XN[R|[lg̎擾
	 */
	public JScrollPane getScrollComponent() {
	return mScroll;
	}

	//## ANV ###################################################
	/**
	 * uOKv{^
	 */
	public void onOK() {
	mIsOK = true;
	setVisible(false);
	}

	/**
	 * uCancelv{^
	 */
	public void onCancel() {
	mIsOK = false;
	setVisible(false);
	}

	/**
	 * uXVv{^
	 */
	public void onUpdate() {
	}

	//## EBhEݒ ###############################################
	/**
     * ^Cg̕\,ACR̕\
	 */
	protected void setTitle() {
	// ^Cg̕\
	String szTitle = getApp().getResource().getString(
						"app."+mDialogName+".title" );
	if ( szTitle == null ) {
		szTitle = mDialogName;
	}
	setTitle( szTitle );
	}

	/**
	 * _CAȌI
	 * ~{^ꂽƂɌĂяoB
	 */
	public void hide() {
	// t[̈ʒuۑ
	getApp().getResource().saveGeometry(this,mDialogName);
	super.hide();
	}

	/**
	 * ʐݒ
	 * @param szItem {^
	 */
	public void setControlPanel(String szItem) {
	JPanel control = createControlPanel(szItem);
	getContentPane().add( "South", control );
	}

	/**
	 * ʐݒ
	 * @param szItem {^
	 */
	public JPanel createControlPanel(String szItem) {
	String[] items = ZString.tokenize(szItem) ;
	JPanel panel = new JPanel();
	for( int nIndex=0 ; nIndex<items.length ; nIndex++ ) {
		Action act  = null ;
		JButton btn = null ;
		if ( items[nIndex].equals(OK) ) {
			act = new AbstractAction(OK) {
				    public void actionPerformed(ActionEvent e) { onOK(); }
				};
			mOK     = new JButton( act ) ;
			mOK.setText("OK");
			panel.add( mOK ) ;
		} else if ( items[nIndex].equals(CANCEL) ) {
			act = new AbstractAction(CANCEL) {
				    public void actionPerformed(ActionEvent e) { onCancel(); }
				};
			mCancel     = new JButton( act ) ;
			mCancel.setText("Cancel");
			panel.add( mCancel ) ;
		} else if ( items[nIndex].equals(UPDATE) ) {
			act = new AbstractAction(CANCEL) {
				    public void actionPerformed(ActionEvent e) { onUpdate(); }
				};
			mUpdate    = new JButton( act ) ;
			mUpdate.setText("XV");
			panel.add( mUpdate ) ;
		}
	}
	return panel;
	}

	//## vpeB擾 ###############################################
	/**
	 * AvP[V̎擾
	 */
	public IZApp getApp() {
	return mApp;
	}

	/**
     * _CAO̎擾
	 */
	public String getDialogName() {
	return mDialogName;
	}

	/**
	 * OK{^̎擾
	 */
	public JButton getOKButton() {
	return mOK;
	}

	/**
	 * Cancel{^̎擾
	 */
	public JButton getCancelButton() {
	return mCancel;
	}

	/**
	 * XV{^̎擾
	 */
	public JButton getUpdateButton() {
	return mUpdate;
	}

	//## Agr[g ###############################################
    /**
     * \[X
     */
    public IZApp  mApp ;

    /**
     * _CAO
     */
    public String mDialogName ;

    /**
     * 
     */
    public boolean mIsOK = false ;

    /**
     * CR|[lg
     */
	protected JComponent mComponent	= null ;

    /**
     * XN[R|[lg
     */
	protected JScrollPane mScroll	= null ;

    /**
     * {^FOK
     */
    protected JButton    mOK     = null ;

    /**
     * {^FCANCEL
     */
    protected JButton    mCancel = null ;

    /**
     * {^FUPDATE
     */
	protected JButton	 mUpdate = null ;

    /**
     * xFOK
     */
    static public final String OK     = "ok" ;

    /**
     * xFCANCEL
     */
    static public final String CANCEL = "cancel" ;

    /**
     * xFUPDATE
     */
    static public final String UPDATE = "update" ;
}
