/*
 * @(#)PTransform.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */

package jp.co.iti.fagot.gob;

import java.awt.Shape;

import java.awt.geom.Point2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;

import jp.co.iti.fagot.geom.ZPoint;

import jp.co.iti.fagot.util.ZDebug;
/**
 * PnNX͕`敔i̕`摮(vpeB)i[
 *
 * http://www.w3.org/TR/2000/CR-SVG-20001102/DTD/svg-20001102.dtdɂ
 * TransformList ɑΉ
 *
 * Transform
 *
 * P}`F
 *	ړEg͍Wɔf
 *	]E䂪݂ȂǓό`WϊIuWFNgɊi[
 *
 * O[v}`F
 *	̍W͎ɁAׂĂ̑WϊIuWFNgɊi[
 *
 * @author  N
 * @version 1.01 2001/01/07
 */
public class PTransform {

	/**
	 * RXgN^
	 */
	public PTransform() {
	m00=1;
	m11=1;
	}

	/**
	 * RXgN^
	 */
	public PTransform( AffineTransform at ) {
	this();
	setTransform(at);
	}

	/**
	 * RXgN^
	 */
	public PTransform( PTransform trans ) {
	this();
	set(trans);
	}

	/**
	 * RXgN^
	 */
	public PTransform( double d00, double d10,
					   double d01, double d11,
					   double d02, double d12 ) {
	this();
	setTransform(d00,d10,d01,d11,d02,d12);
	}

	/**
	 * RXgN^({̂ݎw)
	 */
	public PTransform( double scale ) {
	this();
	setTransform(scale,0,0,scale,0,0);
	}

	//## l ###########################################################
	/**
	 * ϊ̎擾
	 */
	public AffineTransform getTransform() {
	return new AffineTransform(m00,m10,
								m01,m11,
								m02,m12) ;
	}

	/**
	 * {̂ݕϊ̎擾
	 * @ret AffineTransform
	 */
	public AffineTransform getScaleTransform(){
	return new AffineTransform(m00,0,0,m11,0,0);
	}

	/**
	 * ϊ̐ݒ
	 */
	public void set( PTransform trans ) {
	setTransform( trans.getTransform() );
	}

	/**
	 * ϊ̐ݒ
	 */
	public void setTransform( AffineTransform at ) {
	setTransform( at.getScaleX(), at.getShearY(),
				  at.getShearX(), at.getScaleY(),
				  at.getTranslateX(), at.getTranslateY() );
	}

	/**
	 * ϊ̐ݒ
	 */
	public void setTransform( double d00, double d10,
							  double d01, double d11,
							  double d02, double d12 ) {
		m00 = d00;
		m10 = d10;
		m01 = d01;
		m11 = d11;
		m02 = d02;
		m12 = d12;
	}

	/**
	 * ϊ̒ǉ
	 */
	public void add( PTransform trans ) {
	AffineTransform srctrans = getTransform();
	AffineTransform dsttrans = trans.getTransform();
//	srctrans.concatenate(dsttrans);
//	setTransform( srctrans );
	dsttrans.concatenate(srctrans);
	setTransform( dsttrans );
	}

	//## ϊ #########################################################
	/**
	 * ϊW̎擾
	 * @param pt ϊΏۂƂȂW
	 */
	public ZPoint transform( ZPoint pt ) {
	ZPoint pttrans = new ZPoint(pt);
	AffineTransform at = getTransform();
	Point2D pt2D = at.transform(pttrans,null);
	pttrans.setLocation(pt2D.getX(),pt2D.getY()) ;
	return pttrans;
	}

	/**
	 * ϊ`̎擾
	 * @param sh ϊΏۂƂȂ`
	 */
	public Shape transform( Shape sh ) {
	AffineTransform at = getTransform();
	return at.createTransformedShape(sh);
	}

	/**
	 * tϊW̎擾
	 * @param pt ϊΏۂƂȂW
	 */
	public ZPoint inverseTransform( ZPoint pt ) {
	ZPoint pttrans = new ZPoint(pt);
	AffineTransform at = getTransform();
	try {
		AffineTransform atr = at.createInverse();
		Point2D pt2D = atr.transform(pttrans,null);
		pttrans.setLocation(pt2D.getX(),pt2D.getY()) ;
	} catch ( NoninvertibleTransformException nt ) {
		ZDebug.err("at.createInverse failed:"+at.toString());
		nt.printStackTrace();
	}
	return pttrans;
	}

	/**
	 * tϊ`̎擾
	 * @param sh ϊΏۂƂȂ`
	 */
	public Shape inverseTransform( Shape sh ) {
	AffineTransform at = getTransform();
	try {
		AffineTransform atr = at.createInverse();
		return atr.createTransformedShape(sh);
	} catch ( NoninvertibleTransformException nt ) {
		ZDebug.err("at.createInverse failed:"+at.toString());
	}
	return null;
	}

	//## CLONE ########################################################
	/**
	 * ̍쐬
	 */
	public Object clone() {
	PTransform obj = new PTransform();
	obj.set(this);
	return obj;
	}

	public String toString() {
	return "PTransform:"+
		m00+" "+m10+" "+
		m01+" "+m11+" "+
		m02+" "+m12 ;
	}

	//## Agr[g ###############################################
	/**
	 * ϊW
	 */
	protected double m00;
	protected double m10;
	protected double m01;
	protected double m11;
	protected double m02;
	protected double m12;
}
