/*
 * @(#)PStroke.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */
package jp.co.iti.fagot.gob;

import java.awt.Stroke;
import java.awt.BasicStroke;

import jp.co.iti.fagot.fob.FobManager;
import jp.co.iti.fagot.fob.FColor;
import jp.co.iti.fagot.fob.FFloat;
import jp.co.iti.fagot.fob.FFloatArray;
import jp.co.iti.fagot.fob.FString;

/**
 * PnNX͕`敔i̕`摮(vpeB)i[
 *
 * http://www.w3.org/TR/2000/CR-SVG-20001102/DTD/svg-20001102.dtdɂ
 * PresentationAttributes-FillStroke ɑΉ
 *
 * Stroke
 *
 * @author  N
 * @version 1.01 2001/01/07
 */
public class PStroke {
	/**
	 * RXgN^
	 */
	public PStroke() {
		//{{FAGOT_ATTR
		mColor      = new FColor();
		mDashArray  = new FFloatArray();
		mDashOffset = new FFloat();
		mLineCap    = new FString();
		mLineJoin   = new FString();
		mMiterLimit = new FFloat();
		mOpacity    = new FFloat();
		mWidth      = new FFloat();
		//}}FAGOT_ATTR
	}

	//## l ###########################################################
	/**
	 * ̐ݒ
	 */
	public void set(PStroke src) {
		mColor.set( src.getColor() );
		mDashArray.set( src.getDashArray() );
		mDashOffset.set( src.getDashOffset() );
		mLineCap.set( src.getLineCap() );
		mLineJoin.set( src.getLineJoin() );
		mMiterLimit.set( src.getMiterLimit() );
		mOpacity.set( src.getOpacity() );
		mWidth.set( src.getWidth() );
	}

	/**
	 * ̒ǉ
	 */
	public void add(PStroke src) {
		if ( !src.getColor().isNull() ) {
			mColor.set( src.getColor() );
		}
		if ( !src.getDashArray().isNull() ) {
			mDashArray.set( src.getDashArray() );
		}
		if ( !src.getDashOffset().isNull() ) {
			mDashOffset.set( src.getDashOffset() );
		}
		if ( !src.getLineCap().isNull() ) {
			mLineCap.set( src.getLineCap() );
		}
		if ( !src.getLineJoin().isNull() ) {
			mLineJoin.set( src.getLineJoin() );
		}
		if ( !src.getMiterLimit().isNull() ) {
			mMiterLimit.set( src.getMiterLimit() );
		}
		if ( !src.getOpacity().isNull() ) {
			mOpacity.set( src.getOpacity() );
		}
		if ( !src.getWidth().isNull() ) {
			mWidth.set( src.getWidth() );
		}
	}

	/**
	 * Stroke̎擾
	 */
	public Stroke createStroke() {
	// jp^[̎擾
	float[] dash = null ;
	if ( !getDashArray().isNull() ) {
		dash = getDashArray().get();
	}
	
	// jItZbg̎擾
	float   dash_phase = 0.0f;
	if ( !getDashOffset().isNull() ) {
		dash_phase = getDashOffset().get();
	}
	
	// [̑̎擾
	int   cap   = BasicStroke.CAP_SQUARE;
	if ( !getLineCap().isNull() ) {
		if ( getLineCap().get().equals("butt") ) {
			cap = BasicStroke.CAP_BUTT;
		} else if ( getLineCap().get().equals("round") ) {
			cap = BasicStroke.CAP_ROUND;
		}
	}

	// ڍ̑̎擾
	int   join  = BasicStroke.JOIN_MITER;
	if ( !getLineJoin().isNull() ) {
		if ( getLineJoin().get().equals("round") ) {
			join = BasicStroke.JOIN_ROUND;
		} else if ( getLineJoin().get().equals("bevel") ) {
			join = BasicStroke.JOIN_BEVEL;
		}
	}

	// ڍ̑miter̎A؂郊~bg̎擾
	float miterlimit = 10.0f;
	if ( !getMiterLimit().isNull() ) {
		miterlimit = getMiterLimit().get();
	}

	// ̎擾
	float width = 1.0f;
	if ( !getWidth().isNull() ) {
		width = getWidth().get();
	}

	return new BasicStroke(width,cap,join,miterlimit,dash,dash_phase);
	}

	/**
	 * F̎擾
	 */
	public FColor getColor() {
		return mColor;
	}
	/**
	 * jp^[̎擾
	 */
	public FFloatArray getDashArray( ) {
		return mDashArray;
	}
	/**
	 * jItZbg̎擾
	 */
	public FFloat getDashOffset( ) {
		return mDashOffset;
	}
	/**
	 * [̑̎擾
	 */
	public FString getLineCap( ) {
		return mLineCap;
	}
	/**
	 * ڍ̑̎擾
	 */
	public FString getLineJoin( ) {
		return mLineJoin;
	}
	/**
	 * ڍ̑miter̎A؂郊~bg̎擾
	 */
	public FFloat getMiterLimit( ) {
		return mMiterLimit;
	}
	/**
	 * ߓx̎擾
	 */
	public FFloat getOpacity( ) {
		return mOpacity;
	}
	/**
	 * ̎擾
	 */
	public FFloat getWidth( ) {
		return mWidth;
	}

	//## FAGOT ########################################################
	/**
	 * Fob}l[W̓o^([Uf[^̓pXX[)
	 * @param mgr }l[W
	 * @param usrData [Uf[^
	 */
	public void setFobManager(FobManager mgr, Object usrData) {
		//{{FAGOT_ATTR
		mColor.setFobManager(mgr,usrData);
		mDashArray.setFobManager(mgr,usrData);
		mDashOffset.setFobManager(mgr,usrData);
		mLineCap.setFobManager(mgr,usrData);
		mLineJoin.setFobManager(mgr,usrData);
		mMiterLimit.setFobManager(mgr,usrData);
		mOpacity.setFobManager(mgr,usrData);
		mWidth.setFobManager(mgr,usrData);
		//}}FAGOT_ATTR
	}

	//## CLONE ########################################################
	/**
	 * ̍쐬
	 */
	public Object clone() {
	PStroke obj = new PStroke();
	obj.set(this);
	return obj;
	}

	//## Agr[g ###############################################
	/**
	 * F
	 */
	protected FColor mColor;
	/**
	 * jp^[
	 */
	protected FFloatArray mDashArray;
	/**
	 * jItZbg
	 */
	protected FFloat mDashOffset;
	/**
	 * [̑
	 */
	protected FString mLineCap;
	/**
	 * ڍ̑
	 */
	protected FString mLineJoin;
	/**
	 * ڍ̑miter̎A؂郊~bg
	 */
	protected FFloat mMiterLimit;
	/**
	 * ߓx
	 */
	protected FFloat mOpacity;
	/**
	 * 
	 */
	protected FFloat mWidth;

}
