/*
 * @(#)PFill.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */
package jp.co.iti.fagot.gob;

import jp.co.iti.fagot.fob.FobManager;
import jp.co.iti.fagot.fob.FColor;
import jp.co.iti.fagot.fob.FFloat;
import jp.co.iti.fagot.fob.FString;

/**
 * PnNX͕`敔i̕`摮(vpeB)i[
 *
 * http://www.w3.org/TR/2000/CR-SVG-20001102/DTD/svg-20001102.dtdɂ
 * PresentationAttributes-FillStroke ɑΉ
 *
 * Fill
 *
 * @author  N
 * @version 1.01 2001/01/07
 */
public class PFill {
	/**
	 * RXgN^
	 */
	public PFill() {
		//{{FAGOT_ATTR
		mColor   = new FColor();
		mOpacity = new FFloat();
		mRule    = new FString();
		//}}FAGOT_ATTR
	}

	//## l ###########################################################
	/**
	 * ̐ݒ
	 */
	public void set(PFill src) {
		mColor.set( src.getColor() );
		mOpacity.set( src.getOpacity() );
		mRule.set( src.getRule() );
	}

	/**
	 * ̒ǉ
	 */
	public void add(PFill src) {
		if ( !src.getColor().isNull() ) {
			mColor.set( src.getColor() );
		}
		if ( !src.getOpacity().isNull() ) {
			mOpacity.set( src.getOpacity() );
		}
		if ( !src.getRule().isNull() ) {
			mRule.set( src.getRule() );
		}
	}

	/**
	 * F̎擾
	 */
	public FColor getColor() {
		return mColor;
	}
	/**
	 * ߓx̎擾
	 */
	public FFloat getOpacity( ) {
		return mOpacity;
	}
	/**
	 * [̎擾
	 */
	public FString getRule( ) {
		return mRule;
	}

	//## FAGOT ########################################################
	/**
	 * Fob}l[W̓o^([Uf[^̓pXX[)
	 * @param mgr }l[W
	 * @param usrData [Uf[^
	 */
	public void setFobManager(FobManager mgr,Object usrData) {
		//{{FAGOT_ATTR(GFFill)
		mColor.setFobManager(mgr,usrData);
		mOpacity.setFobManager(mgr,usrData);
		mRule.setFobManager(mgr,usrData);
		//}}FAGOT_ATTR
	}

	//## CLONE ########################################################
	/**
	 * ̍쐬
	 */
	public Object clone() {
	PFill obj = new PFill();
	obj.set(this);
	return obj;
	}

	//## Agr[g ###############################################
	/**
	 * F
	 */
	protected FColor mColor;
	/**
	 * ߓx
	 */
	protected FFloat mOpacity;
	/**
	 * [
	 */
	protected FString mRule;

}
