/**
 * @(#)IGobContainer.java
 *
 * Copyright 2000 by Intelligent Technology Inc. All rights reserved.
 *
 * Gob Container
 */
package jp.co.iti.fagot.gob;

import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZPath;

import jp.co.iti.fagot.doc.DocGridControler;

/**
 * GobRei
 *
 * @author  N
 * @version 1.01 2000/12/01
 */
public interface IGobContainer {

	//## qbg #######################################################
	/**
	 * vfɃqbg邩H
	 * @param gob NGXgGob
	 * @param pt _W
	 */
	public byte getHitMode(GElement gob,ZPoint pt) ;

	/**
	 * vf̈ړ[h͂ȂɂH
	 * @param gob NGXgGob
	 * @param pt   _W
	 */
	public byte getPreMoveMode(GElement gob,ZPoint pt) ;

	/**
	 * vfɐڑ邩H
	 * @param gob NGXgGob
	 * @param pt _W
	 * @param obj  ڑΏ
	 */
	public byte getConnectMode(GElement gob,ZPoint pt,Object obj) ;

	/**
	 * _uNbN̓
	 * @param gob NGXgGob
	 * @param mode NbNʒu
	 */
	public void verbDblClick(GElement gob,ZPoint pt);

	/**
	 * Rei̍폜
	 * @param gob NGXgGob
	 */
	public void removeGob(GElement gob) ;

	//## ړ #########################################################
	/**
	 * ړ̊Jn
	 * @param gob NGXgGob
	 * @param grid ObhRg[
	 */
	public void moveStart(GElement gob,DocGridControler grid) ;

	/**
	 * ړPath̎擾
	 * @param gob NGXgGob
	 * @param grid ObhRg[
	 */
	public ZPath getMovingPath(GElement gob,DocGridControler grid) ;

	/**
	 * ړ̊
	 * @param gob NGXgGob
	 * @param grid ObhRg[
	 */
	public void moveEnd(GElement gob,DocGridControler grid) ;

	//## I #########################################################
	/**
	 * I̎擾
	 */
	public boolean isSelect() ;

	/**
	 * I̐ݒ
	 * @param gob NGXgGob
	 * @param bSel I
	 */
	public boolean setSelect(GElement gob,boolean bSel) ;
}
