/*
 * @(#)GString.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */

package jp.co.iti.fagot.gob;

import java.awt.Graphics2D;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Font;
import java.awt.Rectangle;

import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.font.TextAttribute;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import java.text.AttributedString;
import java.text.AttributedCharacterIterator;

import jp.co.iti.fagot.ZApp;

import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZDimension;
import jp.co.iti.fagot.geom.ZRectangle;

import jp.co.iti.fagot.fob.FobManager;
import jp.co.iti.fagot.fob.FInteger;
import jp.co.iti.fagot.fob.FString;

import jp.co.iti.fagot.doc.DocGraphics;
import jp.co.iti.fagot.doc.DocGridControler;

import jp.co.iti.fagot.util.ZGraphicUtil;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.util.ZDebug;
/**
 * String
 * `̈ʓIȌ``܂
 *
 * @author  N
 * @version 1.01 2001/01/07
 */
public class GString extends GRectangle {

	/**
	 * RXgN^
	 */
	public GString() {
		super();
		//{{FAGOT_ATTR
		mText       = new FString();
		mFormat     = new FInteger();
		mFontName   = new FString();
		mFontSize   = new FString();
		//}}FAGOT_ATTR
	}

	//## ʒu##########################################################
	/**
	 * `JnXW̎擾
	 */
	public double getX() {
	return mX;
	}

	/**
	 * `JnYW̎擾
	 */
	public double getY() {
	return mY;
	}

	//## `##########################################################
	/**
	 * `
	 * @param g OtBbNX
	 */
	public void paintContents(DocGraphics graphics) {
	if ( mTl == null ) {
		createTextLayout(graphics);
	}
	if ( mTl != null ) {
		mTl.draw(graphics.getGraphics(), (float)mX, (float)(mY + mTl.getAscent()));
 	}
	}

	/**
	 * \̂ߕ`Ԉۂ𔻒肷B
	 * main gobł̂ݔ肵Aqgobmain gobɏ]
	 * @param graphics OtBbNX
	 */
	protected boolean paintCheck(DocGraphics graphics) {
	boolean bPaint = true;
	createTextLayout(graphics);

	if ( mTl != null ) {
		// Nbv̈ɍW܂܂Ȃꍇ́A`悵Ȃ
		DocGridControler grid  = graphics.getGridControler();
		Rectangle clipRect = graphics.getGraphics().getClipBounds();
		if ( grid.getScaleTransform().getScaleY()<0.1 ) {
			bPaint = false;
		} else if (  clipRect != null &&
			( clipRect.x > (mPaintRect.getX()+mPaintRect.getWidth())  || (clipRect.x+clipRect.width)  < mPaintRect.getX() ) &&
			( clipRect.y > (mPaintRect.getY()+mPaintRect.getHeight()) || (clipRect.y+clipRect.height) < mPaintRect.getY() ) ) {
			bPaint = false;
		}
	} else {
		bPaint = false;
	}

	return bPaint;
	}
	
	
	
	/**
	 * eLXgCAEg̍쐬
	 * @param graphics OtBbNX
	 */
	protected void createTextLayout(DocGraphics graphics) {
	String szText = getText();
	if ( szText == null ) {
		return ;
	}
	int nLen = szText.length() ;
	if ( nLen<0 ) {
		return ;
	}

	// `ʒũ`FbN
	DocGridControler grid  = graphics.getGridControler();
	mPaintRect = grid.transform(getRect()).getBounds2D();

	// eLXgCAEg̍쐬
	ZResource res = ZApp.getTheApp().getResource();
	String szFont = getFontName();
	if ( szFont == null ) {
		szFont = res.getString("app.font.name");
	}
	int nSize = ZString.parseInt( getFontSize(),0 );
	if ( nSize == 0 ) {
		nSize = res.getInt("app.font.size",10);
	}
	
//	ZDebug.trace(getText()+" name:"+szFont+" size="+nSize);
//	Font font = new Font(szFont,0,nSize);
	
	AffineTransform  at    = grid.getScaleTransform();
	// ZDebug.trace(getText()+" "+at.getType()+" "+at.getScaleX()+","+at.getScaleY());
	
	PStyle           style = getStyle();
//	mlbm = ZApp.createLineBreakMeasurer(szText,font,null,style.getFillColor().get(),at);
	mlbm = ZGraphicUtil.createLineBreakMeasurer(szText, szFont, new Float(nSize * at.getScaleX()), null, style.getFillColor().get(), graphics.getGraphics().getFontRenderContext());
	
	// `Jnʒuݒ肷
	// \P̂߁Adim͕KvȂƂɌvZ
	ZDimension dim = null;
	float fx = (float)mPaintRect.getX();
	float fy = (float)mPaintRect.getY();
//	ZDebug.trace("GString:trans:"+getText()+" "+fx+","+fy);
	// XW
	if ( (getFormat() & CENTER)!=0 ) {
		dim = ZGraphicUtil.getTextPreferredSize(mlbm,at,nLen,0);
		fx += (( mPaintRect.getWidth()-dim.getWidth() ) / 2 );
	} else if ( (getFormat() & RIGHT)!=0 ) {
		dim = ZGraphicUtil.getTextPreferredSize(mlbm,at,nLen,0);
		fx += (( mPaintRect.getWidth()-dim.getWidth() ) );
	}

	// YW
	if ( (getFormat() & MIDDLE)!=0 ) {
//		if ( dim==null ){dim = ZGraphicUtil.getTextPreferredSize(mlbm,at,nLen,0);}
//		fy += (( mPaintRect.getHeight()-dim.getHeight() ) / 2 );
	} else if ( (getFormat() & BOTTOM)!=0 ) {
		if ( dim==null ){dim = ZGraphicUtil.getTextPreferredSize(mlbm,at,nLen,0);}
		fy += (( mPaintRect.getHeight()-dim.getHeight() ) );
	}

	mTl = mlbm.nextLayout((float)mPaintRect.getWidth());
	
    // eLXg̊_̓x[XCɂ̂ŁAɂ
//	fy += grid.transformY(mTl.getAscent());

	// `Jnʒuۑ
	mX = (double)fx;
	mY = (double)fy;



	}

	//## FAGOT ########################################################
	/**
	 * ̐ݒ
	 * @param szText 
	 */
	public void setText(String szText) {
		mText.set( szText );
		mlbm = null;
		mTl  = null;
	}

	/**
	 * ̎擾
	 */
	public String getText() {
	return mText.getString();
	}

	/**
	 * \`̐ݒ
	 * @param int nFormat \`
	 */
	public void setFormat(int nFormat) {
		mFormat.set( nFormat );
	}

	/**
	 * \`̎擾
	 */
	public int getFormat() {
	return mFormat.get();
	}

	/**
	 * tHg̐ݒ
	 * @param szFontName tHg
	 */
	public void setFontName(String szFontName) {
		mFontName.set( szFontName );
		mlbm = null;
		mTl  = null;
	}

	/**
	 * tHg̎擾
	 */
	public String getFontName() {
	return mFontName.getString();
	}

	/**
	 * tHgTCY̐ݒ
	 * @param szFontName tHgTCY
	 */
	public void setFontSize(String szFontSize) {
		mFontSize.set( szFontSize );
		mlbm = null;
		mTl  = null;
	}

	/**
	 * tHgTCY̎擾
	 */
	public String getFontSize() {
	return mFontSize.getString();
	}

	/**
	 * Fob}l[W̓o^
	 * @param mgr }l[W
	 */
	public void setFobManager(FobManager mgr) {
		super.setFobManager(mgr);
		//{{FAGOT_ATTR
		mText.setFobManager(mgr,this);
		mFormat.setFobManager(mgr,this);
		mFontName.setFobManager(mgr,this);
		mFontSize.setFobManager(mgr,this);
		//}}FAGOT_ATTR
	}

	//## CLONE ########################################################
	/**
	 * CX^X̍쐬
	 * eNXɂăCX^X𐶐
	 * zNXiуCX^XȂNXjłnullԂ
	 */
	public Object createClone() {
	return new GString();
	}

	/**
	 * Agr[g̕
	 * @param obj ̃IuWFNg
	 */
	public void copyAttribute( Object obj ) {
	super.copyAttribute( obj );
	((GString)obj).setText( getText() );
	((GString)obj).setFormat( getFormat() );
	((GString)obj).setFontName( getFontName() );
	((GString)obj).setFontSize( getFontSize() );
	}

	//##{FAGOT_ATTRIBUTE###############################################
	/**
	 * 
	 */
	protected FString	mText = null;

	/**
	 * \`
	 */
	protected FInteger	mFormat = null;

	/**
	 * \`F
	 */
	public final static int LEFT   = 0x0000;

	/**
	 * \`F
	 */
	public final static int CENTER = 0x0001;

	/**
	 * \`FE
	 */
	public final static int RIGHT  = 0x0002 ;

	/**
	 * \`F
	 */
	public final static int TOP    = 0x0000;

	/**
	 * \`F
	 */
	public final static int MIDDLE = 0x0004;

	/**
	 * \`F
	 */
	public final static int BOTTOM = 0x0008;

	/**
	 * \`FPŝ
	 */
	public final static int SINGLE = 0x0010;

	/**
	 * \`FNbv̈̂
	 */
	public final static int CLIP   = 0x0020;

	/**
	 * tHg
	 */
	protected FString	mFontName = null;

	/**
	 * tHgTCY
	 */
	protected FString	mFontSize = null;

	/**
	 * `JnXW
	 */
	protected double	mX = 0;

	/**
	 * `JnYW
	 */
	protected double	mY = 0;

	/**
	 * nbVp`敶
	 */
	protected LineBreakMeasurer mlbm = null;

	/**
	 * nbVp`敶
	 */
	protected TextLayout mTl = null;

	/**
	 * ``
	 */
	protected Rectangle2D mPaintRect = null;
}
