/*
 * @(#)GSelector.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */

package jp.co.iti.fagot.gob;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

import jp.co.iti.fagot.fob.FColor;

import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;

import jp.co.iti.fagot.doc.DocGraphics;

import jp.co.iti.fagot.util.ZDebug;
/**
 * GSelector
 *
 * I_ǗBVGraphicsɂA[̕`vfɂW͏
 * O[vvf̊gkɂATCYsƂȂB
 * I_́AɈ̃TCY𖖒[NX܂ŒʒmA
 * <ul>
 * <li>TCY̑I_`
 * <li>IꂽƂAƃNbNʒű𑪒肷Ƃ
 *     I̖ڈƂȂƂ
 * </ul>
 * 񋟂
 *
 * @author  N
 * @version 1.01 2001/01/07
 */
public class GSelector extends GRectangle{

	/**
	 * RXgN^
	 */
	public GSelector() {
		this( new ZRectangle(0,0,5,5) );
	}

	/**
	 * RXgN^
	 */
	public GSelector(ZRectangle data) {
		setRect( data );
		getStyle().setFillColor( new FColor( Color.white ));
		getStyle().setStrokeColor( new FColor( Color.black ));
	}

	/**
	 * `̎擾
	 */
//	public ZRectangle getRect() {
//	return mRect;
//	}

	/**
	 * ZN^[Ƀqbg邩H
	 */
	public boolean isHit(ZPoint center, ZPoint pt) {
	ZRectangle rect = new ZRectangle( getRect() );
	rect.setCenter(center);
	return ( rect.contains(pt) );
	}

	/**
	 * Ƃ̎擾
	 */
	public double getMargin(double x,double y) {
	// KW̌vZ
	double zz = Math.sqrt(x*x+y*y);

	// sxNg(zz*y,zz*x)
	double zx = zz*y*getRect().getWidth();
	double zy = zz*x*getRect().getHeight();

	double margin = Math.sqrt(zx*zx+zy*zy);
	return ( margin );
	}

	/**
	 * g嗦ύXCX^XԂ
	 */
	public GSelector createScaledSelector(double x,double y) {
	return ( new GSelector( new ZRectangle(0,0,getRect().getWidth()*x,
											   getRect().getHeight()*y ) ) );
	
	}

	//## ` #########################################################
	/**
	 * `
	 * gEkɒڕ`(ʒu͊g_Ɉړ)
	 */
	public void paint(DocGraphics graphics) {
	Graphics2D g2 = graphics.getGraphics();
	PStyle style = getStyle();
	ZRectangle rect = getRect();
	ZPoint pt = rect.getCenter();
	ZPoint ptTrans = graphics.getGridControler().transform( pt );
	rect.setCenter( ptTrans );


	// hԂ
	if ( !style.getFill().getColor().isNull() ) {
		// F̐ݒ
		Color oldColor = g2.getColor();
		g2.setColor( style.getFill().getColor().get() );

		// hԂ
		g2.fill( rect );

		// ɖ߂
		g2.setColor( oldColor ) ;
	}

	// ֊s
	if ( !style.getStroke().getColor().isNull() ) {
		// F̐ݒ
		Color oldColor = g2.getColor();
		g2.setColor( style.getStroke().getColor().get() );

		// Stroke ̍쐬
		Stroke oldStroke = g2.getStroke();
		g2.setStroke( style.getStroke().createStroke() );

		// ֊s
		g2.draw( rect );

		// ɖ߂
		g2.setColor( oldColor ) ;
		g2.setStroke( oldStroke ) ;
	}
	}

	//## `(GobĂ΂ĕ`悷ꍇ) #############################
	/**
	 * I_̕`
	 * @param g OtBbNX
	 * @param pt SƂȂ|Cg
	 */
	public void paint(Graphics2D g, ZPoint pt) {
	ZRectangle rect = new ZRectangle( getRect() );
	rect.setCenter( pt );
	g.setColor(Color.white);
	g.fill(rect);
	g.setColor(Color.black);
	g.draw(rect);
	}

	/**
	 * I~̕`
	 * @param g OtBbNX
	 * @param pt SƂȂ|Cg
	 */
	public void paintCircle(Graphics2D g, ZPoint pt) {
	ZRectangle rect = new ZRectangle( getRect() );
	rect.setCenter( pt );
	g.setColor(Color.blue);
	g.fillOval((int)rect.getX(),(int)rect.getY(),
	           (int)rect.getWidth(),(int)rect.getHeight());
	g.drawOval((int)rect.getX(),(int)rect.getY(),
	           (int)rect.getWidth(),(int)rect.getHeight());
	}

	//## Agr[g################################################
    /**
     * `
     */
//    protected ZRectangle mRect;
}
