/*
 * @(#)GPath.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */

package jp.co.iti.fagot.gob;

import java.awt.Graphics2D;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Composite;
import java.awt.AlphaComposite;
import java.awt.Rectangle;

import java.awt.geom.Rectangle2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;

import jp.co.iti.fagot.fob.FobManager;
import jp.co.iti.fagot.fob.FColor;
import jp.co.iti.fagot.fob.FFloat;
import jp.co.iti.fagot.fob.FString;

import jp.co.iti.fagot.geom.ZGeneralPath;
import jp.co.iti.fagot.geom.ZPath;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;

import jp.co.iti.fagot.doc.DocGraphics;
import jp.co.iti.fagot.doc.DocGridControler;

import jp.co.iti.fagot.util.ZDebug;
/**
 * Path
 *
 * ʕ`pe|NXƂĎgp
 * ̂߁AmPath undoable ł͂Ȃ
 *
 * @author  N
 * @version 1.01 2001/01/07
 */

public class GPath extends GElement {

	/**
	 * RXgN^
	 */
	public GPath() {
	super();
	//{{FAGOT_ATTR
	mPath = new ZPath();
	//}}FAGOT_ATTR
	}

	//## ʒu##########################################################
	/**
	 * ʒu̎擾
	 */
	public ZRectangle getMyBounds() {
	return new ZRectangle(mPath.getBounds2D());
	}

	/**
	 * vfɃqbg邩H
	 * @param pt   _W
	 */
	public byte getHitModeGob(ZPoint pt) {
	ZPath path = getPath();
	if ( path.contains(pt) ) {
		return GOperation.MOVE;
	}
	return GOperation.NONE ;
	}

	/**
	 * vf̐ڑʒu擾
	 * @param mode ڑʒu
	 */
	public ZPoint getConnectPointGob(byte mode) {
//	ZRectangle rect = getTransformedBounds();
	ZRectangle rect = new ZRectangle(getPath().getBounds2D());
	return rect.getCenter();
/*
	GRectangle gRect = new GRectangle();
	gRect.setRect(rect);
	return gRect.getConnectPointGob(mode);
*/
	}

	//## ړ##########################################################
	/**
	 * ړPath̎擾
	 * @param grid ObhRg[[
	 */
	public ZPath getMovingPathGob(DocGridControler grid) {
	ZPath path = getPath();
	switch ( grid.getMoveMode() ) {
	  case GOperation.MOVE:		// ړ
		ZPoint pt = grid.getOffsetGrid();
		AffineTransform at = new AffineTransform(1,0,0,1,pt.getX(),pt.getY());
		path.transform(at);
	}
	
	return path;
	}

	//## `##########################################################
	/**
	 * `
	 * @param g OtBbNX
	 */
	public void paintContents(DocGraphics g) {
	Graphics2D g2 = g.getGraphics();
	PStyle style = getStyle();

/*	*** 20020410 *** `}`́ApaintCheck()ɂāAmPaintShapeɐݒ肷
	ZPath   path = getPath();

	// hԂ[̐ݒ
	// defaultĺAWIND_NON_ZERÔ߁AWIND_EVEN_ODD̏ꍇ̂ݐݒ肷
	if ( !style.getFill().getRule().isNull() &&
	      style.getFill().getRule().get().equals("evenodd") ) {
		path.setWindingRule(ZGeneralPath.WIND_EVEN_ODD);
	}

	Shape sh = g.getGridControler().transform( path );
	// Nbv̈ɍW܂܂Ȃꍇ́A`悵Ȃ
	if ( !checkClipRect(g2,sh.getBounds2D()) ) {
		return;
	}
*/
	if ( mPaintShape == null ) {
		createPaintShape(g);
	}

	// hԂ
	if ( !style.getFill().getColor().isNull() ) {
		// F̐ݒ
		Color oldColor = g2.getColor();
		g2.setColor( style.getFill().getColor().get() );

		// ߓx̐ݒ
		Composite oldComposite = null ;
		if ( !style.getFill().getOpacity().isNull() ) {
			oldComposite = g2.getComposite();
			g2.setComposite (
				AlphaComposite.getInstance(
					AlphaComposite.SRC_OVER,
					style.getFill().getOpacity().get()
				)
			);
		}

		// hԂ
		g2.fill( mPaintShape );

		// ɖ߂
		g2.setColor( oldColor ) ;
		if ( oldComposite != null ) {
			g2.setComposite( oldComposite );
		}
	}

	// ֊s
	if ( !style.getStroke().getColor().isNull() ) {
		// F̐ݒ
		Color oldColor = g2.getColor();
		g2.setColor( style.getStroke().getColor().get() );

		// ߓx̐ݒ
		Composite oldComposite = null ;
		if ( !style.getStroke().getOpacity().isNull() ) {
			oldComposite = g2.getComposite();
			g2.setComposite (
				AlphaComposite.getInstance(
					AlphaComposite.SRC_OVER,
					style.getStroke().getOpacity().get()
				)
			);
		}

		// Stroke ̍쐬
		Stroke oldStroke = g2.getStroke();
		g2.setStroke( style.getStroke().createStroke() );

		// ֊s
		g2.draw( mPaintShape );

		// ɖ߂
		g2.setColor( oldColor ) ;
		g2.setStroke( oldStroke ) ;
		if ( oldComposite != null ) {
			g2.setComposite( oldComposite );
		}
	}
	}

	/**
	 * I_̕`
	 */
	public void paintSelector(DocGraphics graphics) {
	// Wϊ̓Kp
	graphics.getGridControler().pushTransform(getTransform());

	GSelector sel = new GSelector();
	PathIterator pi = getPath().getPathIterator(null);
	ZPoint pt = null;
	ZPoint ptTrans = null;
	while ( !pi.isDone() ) {
		double[] segs = new double[6];
		int nType = pi.currentSegment( segs );
		switch ( nType ) {
		  case PathIterator.SEG_MOVETO:
		  case PathIterator.SEG_LINETO:
			pt = new ZPoint( segs[0], segs[1] );
			ptTrans = graphics.getGridControler().transform( pt );
			sel.paint(graphics.getGraphics(),ptTrans);
			break;
		  case PathIterator.SEG_QUADTO:
			pt = new ZPoint( segs[2], segs[3] );
			ptTrans = graphics.getGridControler().transform( pt );
			sel.paint(graphics.getGraphics(),ptTrans);
			break;
		  case PathIterator.SEG_CUBICTO:
			pt = new ZPoint( segs[4], segs[5] );
			ptTrans = graphics.getGridControler().transform( pt );
			sel.paint(graphics.getGraphics(),ptTrans);
			break;

		  case PathIterator.SEG_CLOSE:
			break;
		}
		pi.next();
	}

	// Wϊɖ߂
	graphics.getGridControler().popTransform();
	}

	/**
	 * ړe̕`
	 */
	public void paintDragContents(DocGraphics g) {
	Graphics2D g2 = g.getGraphics();
	ZPath path = getMovingPath(g.getGridControler());
	Shape sh   = g.getGridControler().transform( path );
//	ZDebug.trace("paintDrag:"+sh.toString());
	g2.draw( sh );
	}

	/**
	 * \̂ߕ`Ԉۂ𔻒肷B
	 * main gobł̂ݔ肵Aqgobmain gobɏ]
	 * @param graphics OtBbNX
	 */
	protected boolean paintCheck(DocGraphics graphics) {
	boolean bPaint = true;
	createPaintShape(graphics);

	// Nbv̈ɍW܂܂Ȃꍇ́A`悵Ȃ
	Rectangle2D rt     = mPaintShape.getBounds2D();
	Rectangle clipRect = graphics.getGraphics().getClipBounds();
	if ( !(mIsPaintIfSmall) && ( rt.getWidth() < 2 || rt.getHeight() < 2 ) ) {
		bPaint = false;
	} else if (  clipRect != null &&
		( clipRect.x > (rt.getX()+rt.getWidth())  || (clipRect.x+clipRect.width)  < rt.getX() ) &&
		( clipRect.y > (rt.getY()+rt.getHeight()) || (clipRect.y+clipRect.height) < rt.getY() ) ) {
		bPaint = false;
	}

	return bPaint;
	}

	/**
	 * `}`̌vZ
	 * @param graphics OtBbNX
	 */
	protected void createPaintShape(DocGraphics graphics) {
	ZPath path  = getPath();
	mPaintShape = graphics.getGridControler().transform( path );
	}

	//## FAGOT ########################################################
	/**
	 * l̎擾
	 */
	public ZPath getPath() {
	return new ZPath( mPath );
	}

	/**
	 * l̐ݒ
	 */
	public void setPath(ZPath data) {
	mPath.setPath( data );
	}

	/**
	 * `摮̐ݒ
	 * ǂȂɏĂ`悷邩H(sckeltonp)
	 * @param bValue \L
	 */
	public void setPaintIfSmall(boolean bValue) {
	mIsPaintIfSmall = bValue;
	}

	//## CLONE ########################################################
	/**
	 * CX^X̍쐬
	 * eNXɂăCX^X𐶐
	 * zNXiуCX^XȂNXjłnullԂ
	 */
	public Object createClone() {
	return new GPath();
	}

	/**
	 * Agr[g̕
	 * @param obj ̃IuWFNg
	 */
	public void copyAttribute( Object obj ) {
	super.copyAttribute( obj );
	((GPath)obj).setPath( getPath() );
	}

	//## Agr[g################################################
	/**
	 * W
	 */
	protected ZPath		mPath;

	/**
	 * ϊꂽ`W
	 * paihtCheck()ō쐬ApaintContents()ŗp
	 */
	protected Shape 	mPaintShape = null;

	/**
	 * Ă`悷邩H
	 */
	protected boolean mIsPaintIfSmall = false;
}
