/*
 * @(#)GLine.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */

package jp.co.iti.fagot.gob;

import java.awt.Shape;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

import java.awt.geom.Rectangle2D;
import java.awt.geom.AffineTransform;

import java.util.Enumeration;

import jp.co.iti.fagot.geom.ZPath;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZLine;
import jp.co.iti.fagot.geom.ZRectangle;

import jp.co.iti.fagot.fob.FobManager;
import jp.co.iti.fagot.fob.FInteger;
import jp.co.iti.fagot.fob.FDouble;

import jp.co.iti.fagot.doc.DocGraphics;
import jp.co.iti.fagot.doc.DocGridControler;

import jp.co.iti.fagot.util.ZGraphicUtil;
import jp.co.iti.fagot.util.ZDebug;
/**
 * Line
 *
 * @author  N
 * @version 1.01 2001/01/07
 */
public class GLine extends GPath {

	/**
	 * RXgN^
	 */
	public GLine() {
		super();
		//{{FAGOT_ATTR
		mLine  = new ZLine();
		mArrow = new FInteger();
		//}}FAGOT_ATTR
	}

	//## ʒu##########################################################
	/**
	 * ʒu̎擾
	 */
	public ZRectangle getMyBounds() {
	return new ZRectangle(mLine.getBounds2D());
	}

	/**
	 * vfɃqbg邩H
	 * @param pt   _W
	 */
	public byte getHitModeGob(ZPoint pt) {

	// ZN^[Ƀqbg邩H
	GSelector sel = new GSelector();
	AffineTransform at = getTransform().getTransform();
	sel = sel.createScaledSelector( 1/at.getScaleX(), 1/at.getScaleY() );
	if ( isSelect() ) {
		if ( sel.isHit(mLine.getP1Z(),pt) ) {
			mMovePoint = PT_START;
			return ( GOperation.POINT ) ;
		}
		if ( sel.isHit(mLine.getP2Z(),pt) ) {
			mMovePoint = PT_END;
			return ( GOperation.POINT ) ;
		}
	}

	// pX̋߂
	if ( ZGraphicUtil.isNearLine(
		mLine.getP1Z(),mLine.getP2Z(),pt,sel.getMargin(1,0) ) ) {
		mMovePoint = PT_NONE;
		return ( GOperation.MOVE ) ;
	}
	return ( GOperation.NONE );
	}

	//## ړ##########################################################
	/**
	 * ړ̊Jn
	 * @param grid ObhRg[
	 */
	public void moveStartGob(DocGridControler grid) {
	
	switch ( grid.getMoveMode() ) {
	  case GOperation.MOVE:		// ړ
		mMovePoint = PT_NONE;
		break;

	  case GOperation.NEW:		// VK쐬
		mMovePoint = PT_END;
		break;

	  case GOperation.POINT:	// _̈ړ
		double p1 = ZGraphicUtil.getDistance(
						grid.getStartPoint(),mLine.getP1Z());
		double p2 = ZGraphicUtil.getDistance(
						grid.getStartPoint(),mLine.getP2Z());
		if ( p1 < p2 ) {
			mMovePoint = PT_START;
		} else {
			mMovePoint = PT_END;
		}
	}
	}

	/**
	 * ړPath̎擾
	 * @param grid ObhRg[[
	 */
	public ZPath getMovingPathGob(DocGridControler grid) {
		return new ZPath( getMovingLine(grid) );
	}

	/**
	 * ړW̎擾
	 * @param grid ObhRg[[
	 */
	public ZLine getMovingLine(DocGridControler grid) {

	ZPoint pt1 = grid.getStartGrid();
	ZPoint pt2 = grid.getMoveGrid();
	ZLine  line = getLine() ;

	switch ( grid.getMoveMode() ) {
	  case GOperation.MOVE:		// ړ
		line.translate( grid.getOffsetGrid() ) ;
		break;

	  case GOperation.NEW:		// VK쐬
		line = new ZLine( pt1, pt2 );
		break;

	  case GOperation.POINT:	// _̈ړ
		if ( mMovePoint == PT_START ) {
			// n_̈ړ
			line = new ZLine( pt2, mLine.getP2Z() );
		} else if ( mMovePoint == PT_END ) {
			// I_̈ړ
			line = new ZLine( mLine.getP1Z(), pt2 );
		}
		break;
	}
	return( line );
	}
	//## ŗL##########################################################
	/**
	 * ړ_̎擾
	 */
	public int getMovePoint() {
	return mMovePoint;
	}

	//## `##########################################################
	/**
	 * `
	 * @param graphics OtBbNX
	 */
	public void paintContents(DocGraphics graphics) {
	super.paintContents(graphics);

	// ̕`
	Graphics2D g2 = graphics.getGraphics();
	PStyle style = getStyle();

	// F̐ݒ
	Color oldColor = g2.getColor();
	g2.setColor( style.getStroke().getColor().get() );

//	ZDebug.trace(mLine.getP1Z().toString()+""+mLine.getP2Z().toString());
	ZPoint pt1 = graphics.getGridControler().transform( mLine.getP1Z() );
	ZPoint pt2 = graphics.getGridControler().transform( mLine.getP2Z() );

	if ( isArrow(ARROW_FORWARD) ) {
		Shape sh = ZGraphicUtil.createArrowShape( pt1, pt2, 8,4);
		// hԂ
		g2.fill( sh );
	}

	if ( isArrow(ARROW_BACKWARD) ) {
		Shape sh = ZGraphicUtil.createArrowShape( pt2, pt1, 8,4);
		// hԂ
		g2.fill( sh );
	}

	// ɖ߂
	g2.setColor( oldColor ) ;
	}

	/**
	 * I_̕`FJn_AI_
	 * @param graphics OtBbNX
	 */
	public void paintSelector(DocGraphics graphics) {
	// Wϊ̓Kp
	graphics.getGridControler().pushTransform(getTransform());

	GSelector sel = new GSelector();
	ZPoint ptTrans = graphics.getGridControler().transform( mLine.getP1Z() );
	sel.paint(graphics.getGraphics(),ptTrans);

	ptTrans = graphics.getGridControler().transform( mLine.getP2Z() );
	sel.paint(graphics.getGraphics(),ptTrans);

	// Wϊɖ߂
	graphics.getGridControler().popTransform();
	}

	/**
	 * \̂ߕ`Ԉۂ𔻒肷B
	 * main gobł̂ݔ肵Aqgobmain gobɏ]
	 * @param graphics OtBbNX
	 */
	protected boolean paintCheck(DocGraphics graphics) {
	boolean bPaint = true;
	createPaintShape(graphics);

	// Nbv̈ɍW܂܂Ȃꍇ́A`悵Ȃ
	Rectangle2D rt     = mPaintShape.getBounds2D();
	Rectangle clipRect = graphics.getGraphics().getClipBounds();
	if (  clipRect != null &&
		( clipRect.x > (rt.getX()+rt.getWidth())  || (clipRect.x+clipRect.width)  < rt.getX() ) &&
		( clipRect.y > (rt.getY()+rt.getHeight()) || (clipRect.y+clipRect.height) < rt.getY() ) ) {
		bPaint = false;
	}

	return bPaint;
	}

	/**
	 * `}`̌vZ
	 * @param graphics OtBbNX
	 */
	protected void createPaintShape(DocGraphics graphics) {
	ZPath path  = new ZPath( getLine() );
	setPath( path );
	mPaintShape = graphics.getGridControler().transform( path );
	}

	//## FAGOT ########################################################
	/**
	 * ʒu̐ݒ
	 */
	public void setLine(ZLine data) {
		mLine.setLine( data );
	}

	/**
	 * ʒu̎擾
	 */
	public ZLine getLine() {
	return new ZLine(mLine);
	}

	/**
	 * ̐ݒ
	 */
	public void setArrow(int nDirection) {
	mArrow.set(nDirection);
	}

	/**
	 * ̎擾
	 */
	public boolean isArrow(int nDirection) {
	int nValue = mArrow.get();
	return ((nValue&nDirection)!=0);
	}

	/**
	 * Fob}l[W̓o^
	 * @param mgr }l[W
	 */
	public void setFobManager(FobManager mgr) {
		super.setFobManager(mgr);
		//{{FAGOT_ATTR
//		mLine.setFobManager(mgr,this);
		mArrow.setFobManager(mgr,this);
		//}}FAGOT_ATTR
	}

	//## CLONE ########################################################
	/**
	 * CX^X̍쐬
	 * eNXɂăCX^X𐶐
	 * zNXiуCX^XȂNXjłnullԂ
	 */
	public Object createClone() {
	return new GLine();
	}

	/**
	 * Agr[g̕
	 * @param obj ̃IuWFNg
	 */
	public void copyAttribute( Object obj ) {
	super.copyAttribute( obj );
	((GLine)obj).setLine( getLine() );
	((GLine)obj).mArrow.set( mArrow.get() );
	}

	//##{FAGOT_ATTRIBUTE###############################################
	/**
	 * W
	 */
	protected ZLine		mLine;

	/**
	 * 
	 */
	protected FInteger	mArrow;

	/**
	 * ԁFO
	 */
	static final public int   ARROW_FORWARD = 1;

	/**
	 * ԁF
	 */
	static final public int   ARROW_BACKWARD = 2;



	/**
	 * ړ_̃|C^ǂ
	 */
	protected int		mMovePoint = 0;

	/**
	 * ړ_ԁFȂS
	 */
	static final public int   PT_NONE    = -1;

	/**
	 * ړ_ԁFJn
	 */
	static final public int   PT_START   = 0;

	/**
	 * ړ_ԁFI
	 */
	static final public int   PT_END     = 1;
}
