/**
 * @(#)DocUIAdapter.java
 *
 * Copyright 2000 by Intelligent Technology Inc. All rights reserved.
 *
 * UI̕ߑ
 */
package jp.co.iti.fagot.doc;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Dimension;
import java.awt.Window;

import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyListener;
import java.awt.event.KeyEvent;

import java.util.Enumeration;
import java.util.Vector;
//import java.util.EventListener;

import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.JPopupMenu;

import jp.co.iti.fagot.ZApp;

import jp.co.iti.fagot.geom.ZPoint;

import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GOperation;
import jp.co.iti.fagot.gob.GOperationCreate;
import jp.co.iti.fagot.gob.GOperationMove;
import jp.co.iti.fagot.gob.GOperationSelect;
import jp.co.iti.fagot.gob.GOperationZoom;
import jp.co.iti.fagot.gob.GobManager;

import jp.co.iti.fagot.ui.UIFactory;

import jp.co.iti.fagot.util.ZUIUtil;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZReverseEnumeration;
/**
 * UIߑ܂B
 * <ul>
 * <li>}EXCxg
 * <li>}EX[VCxg
 * <li>L[{[hCxg
 * </ul>
 *
 * ReiƂɃ}EXA_v^͔̂ɑςȂ̂ŁA
 * View,RootȂǂŋz
 *
 * @author  N
 * @version 1.01 2000/12/01
 */
public class DocUIAdapter implements MouseListener,MouseMotionListener,KeyListener{
//	   implements EventListener,MouseListener,MouseMotionListener,KeyListener{

	/**
	 * RXgN^
	 * @param container Rei
	 * @param root		[gGg
	 */
	public DocUIAdapter(DocPane container){
	mEditor = container;
	}

	//## Cxg #####################################################
	/**
	 * {^down
	 * @param evt }EXCxg
	 */
	protected void OnLButtonDown( MouseEvent evt ) {
//	ZDebug.trace("{^Jn");
	mMoveMode = GOperation.NONE;

	// ҏW[h̏I
	// ҏWꍇ́AҏWLẐ
	if ( mEditor.editEnd() ) {
		return ;
	}

	mStartPoint = new ZPoint(evt.getPoint());
//	ZDebug.trace("OnLButtonDown.mStartpt="+mStartPoint.toString());

	// VK쐬AړAg̏ꍇ̓Iy[V̍쐬
	GElement ope = createOperation(evt);
	if ( ope != null ) {
		mMoveMode = ope.getHitMode(mStartPoint);
		GobManager.setSelect(mEditor.getPanelId(),false);
		GobManager.setCurrent(mEditor.getPanelId(),(GElement)ope);
	}

	// ݑI𒆗vfɃqbg邩H
	if ( mMoveMode == GOperation.NONE ) {
//		mMoveMode = GobManager.getSelectedHitMode(mEditor,mStartPoint);
		mMoveMode = GobManager.getSelectedPreMoveMode(mEditor,mStartPoint);

		// ݑI𒆗vfɃqbgH
		if ( mMoveMode != GOperation.NONE ) {
/*
			// ݑIvf̏ɂɃGg݂邩H
			GElement elm = GobManager.getHitElement(mEditor,mStartPoint);
			if ( !elm.isSelect() ) {
				// ݑIGgȊÕGgqbĝŁAI[hNONEɐݒ
//				ZDebug.trace("SetSelect:false");
				mMoveMode = GOperation.NONE;
				GobManager.setSelect(mEditor.getPanelId(),false);
			} else {
				// ݑIGgɃqbĝŁAIĂGgJgɐݒ
				GobManager.updateCurrent(mEditor.getPanelId());
			}
*/
				// ݑIGgɃqbĝŁAIĂGgJgɐݒ
				GobManager.updateCurrent(mEditor.getPanelId());
		}
	}

	// ݑI𒆗vfɃqbgȂAqbgIuWFNg
	if ( mMoveMode == GOperation.NONE ) {
		GElement elm = GobManager.getHitElement(mEditor,mStartPoint);

		// VtgL[ĂȂΈUS
		if ( !evt.isShiftDown() ) {
			GobManager.setSelect(mEditor.getPanelId(),false);
		}
		//  ȂɂɃqbg
		if ( elm != null ) {
//			elm.setSelect(true);
			GobManager.updateCurrent(mEditor.getPanelId());
			GobManager.addCurrent(mEditor.getPanelId(),elm);
			mMoveMode = GOperation.MOVE;
		} else {
			GobManager.setCurrent(mEditor.getPanelId(),new GOperationSelect());
			mMoveMode = GOperation.SELECTION;
		}
	}

	// gUNVJn
	mEditor.getDocument().beginTransaction();

	// ړJn
	mEditor.getGridControler().setMoveStart( mStartPoint,mMoveMode ) ;
	GobManager.moveStart(mEditor,mEditor.getGridControler());

	// ړ
	mEditor.getGridControler().setMoving( mStartPoint,0 ) ;

	// J[\̕ύXƍĕ`
	mEditor.setCursor(GOperation.getCursor(mMoveMode));
//	ZDebug.trace();
	// {^𗣂Ȃ̂ŁAx`悷
	// 1bĂ}EXȂ΍ĕ`悳
	// ̑OɃ}EXꂽȂAmouseMoveĂ΂repaintōĕ`悳
	mEditor.repaint(1000);
	}

	/**
	 * {^up
	 * @param evt }EXCxg
	 */
	protected void OnLButtonUp( MouseEvent evt ) {

//	ZDebug.trace("OnLButtonUp");
	ZPoint endPoint = new ZPoint( evt.getPoint() ) ;
	mEditor.getGridControler().setMoving( endPoint,0 ) ;

	// I
	Vector cur = GobManager.getCurrent(mEditor.getPanelId());
	if ( cur.size() == 0 ) {
		// ҏWꍇ́AJgnullɂȂĂ܂
		// JgnullȂ̂ŃR~bgȂ
		return ;
	}

	// ړȂꍇ
	if ( mStartPoint.equals( endPoint ) ) {
		if ( cur.size() == 1 ) {
			GElement item = (GElement)cur.elementAt(0);
			// VK쐬Iy[VAgkIy[V̂ݍWωȂĂ
			// MoveEndKv
			if ( item.needsMoveEnd() ) {
				GobManager.moveEnd(mEditor,mEditor.getGridControler());
			}
			item.setSelect( true );

		// I̕ύX
		} else {
			GElement item = GobManager.getCurrentHitElement(mEditor,endPoint);
			if ( item != null ) {
				// VtgL[Ăꍇ́AON/OFFgO
				if ( evt.isShiftDown() ) {
					item.setSelect( !item.isSelect() );
				} else {
					item.setSelect( true );
				}
			}
		}

		// vpeBpl̍XV
		jp.co.nri.rid.RUpdateManager.update(jp.co.nri.rid.RUpdateManager.SELECT_GOBS);

	// ړꍇ
	} else {
		GobManager.moveEnd(mEditor,mEditor.getGridControler());
		GobManager.setCurrentSelect(mEditor.getPanelId(),true);
	}

	GobManager.setCurrent(mEditor.getPanelId(),null);
	mEditor.updateGobs();

	mEditor.getDocument().commit();
	updateCursor(evt);
//	ZDebug.trace();
	mEditor.repaint();
//	ZDebug.trace("{^I");
	}

	/**
	 * E{^down
	 * @param evt }EXCxg
	 */
	protected void OnRButtonDown( MouseEvent evt ) {

//	System.out.println("OnRButtonDown");
	// ҏW[h̏I
	// ҏWꍇ́AҏWLẐ
	if ( mEditor.editEnd() ) {
		return ;
	}

	// ݃IuWFNgꍇ́A쒆Ȃ̂ő̃LZ
	Vector cur = GobManager.getCurrent(mEditor.getPanelId());
	if ( cur.size() != 0 ) {
		mEditor.getDocument().rollback();
		GobManager.setCurrent(mEditor.getPanelId(),null);
		mEditor.setCursor(new Cursor(Cursor.DEFAULT_CURSOR) );
//		mEditor.repaint();

	// ݃IuWFNgȂꍇ́AE{^j[
	} else {
		// NbNʒu̎擾
		ZPoint pt = new ZPoint(evt.getPoint());

		// ݑI𒆗vfɃqbg邩H
		if ( GobManager.getSelectedHitMode(mEditor,pt) == GOperation.NONE ) {
			// qbgȂꍇ́AISăqbgGǧo
//			ZDebug.trace("SetSelect:false");
			GobManager.setSelect(mEditor.getPanelId(),false);
			GElement elm = GobManager.getHitElement(mEditor,pt);
			if ( elm != null ) {
//				ZDebug.trace("SetSelect:true");
				elm.setSelect(true);
			}
		}

		// j[ʃL[̍쐬
		Vector gobs = GobManager.getSelectedElement(mEditor.getPanelId());
		Vector targets = new Vector();
//		ZDebug.trace("SetElement.count:"+gobs.size());

/*
		if ( true ) {
			// XgnE{^j[̃eXg
			Vector targets = new Vector();
			Enumeration ge = gobs.elements();
			while ( ge.hasMoreElements() ) {
				DocElement target = (DocElement)((GElement)ge.nextElement()).getContainer();
				targets.add( target );
			}
			jp.co.nri.rid.RMenu.createContextMenu( evt, targets );
			return;
		}
*/

		// IꂽGgȂRootElement
		UIFactory ui = DocManager.createUIFactory(DocManager.ELEMENT);
		String szContext = null;
		if ( gobs.size() == 0 ) {
			szContext = mEditor.getPanelId();
			ui = DocManager.createUIFactory(DocManager.DOCUMENT);
		} else if ( gobs.size() == 1 ) {
			DocElement target = (DocElement)((GElement)gobs.firstElement()).getContainer();
			targets.add( target );
			szContext = target.getContextKey(mEditor.getPanelId());
		}

		JPopupMenu popup = null;
		if ( szContext != null ) {
//			ZDebug.trace();
			popup = ui.createContextMenu(mEditor,szContext);
		} else {
//			ZDebug.trace();
			Vector keys = new Vector();
			Enumeration elm = gobs.elements();
			while(elm.hasMoreElements()) {
//				ZDebug.trace();
				DocElement target = (DocElement)((GElement)elm.nextElement()).getContainer();
				keys.add( target.getContextKey(mEditor.getPanelId()) );
				targets.add( target );
			}
			popup = ui.createContextMenu(mEditor,keys);
		}

		// \ʒǔvZ
		Dimension scrDim = popup.getToolkit().getScreenSize();
		Dimension popDim = popup.getPreferredSize();
		Window win = ZUIUtil.getParentWindow(mEditor);
		Point  ptEditor = mEditor.getLocationOnScreen();
		Point  ptWin = win.getLocationOnScreen();

//		ZDebug.trace("popDim:"+popDim);
//		ZDebug.trace("scrDim:"+scrDim);
//		ZDebug.trace("ptEditor:"+ptEditor);

		// EBhËʒuɏC
		int nX = (int)(evt.getX()+ptEditor.getX()-ptWin.getX());
		int nY = (int)(evt.getY()+ptEditor.getY()-ptWin.getY());
		// ʒu̕␳
		if ( nX+ptWin.getX()+popDim.getWidth() > (scrDim.getWidth()-40) ) {
			nX -= popDim.getWidth();
		}
		if ( nY+ptWin.getY()+popDim.getHeight() > (scrDim.getHeight()-40) ) {
			nY -= popDim.getHeight();
		}

		ZInstance.map().put("doc.rmenu.target", targets );
		popup.show(win, nX, nY);

//		popup.show(mEditor, evt.getX(),evt.getY());
	}
//	ZDebug.trace();
	mEditor.repaint();
	}

	/**
	 * E{^up
	 */
	protected void OnRButtonUp( MouseEvent evt ) {
//	System.out.println("OnRButtonUp");
	}

	/**
	 * _uNbN
	 */
	protected void OnDblClick( MouseEvent evt ) {
//	ZDebug.trace();
	ZPoint pt = new ZPoint(evt.getPoint());
	// ݑI𒆗vfɃqbg邩H
	String panelId = mEditor.getPanelId();
	ZPoint transPt = ((DocElement)mEditor.getDocument().getRootElement(panelId)).getDisplayScaledTransform(panelId).inverseTransform(pt);
	
	// ݑIĂGg̎擾
	Enumeration elm = new ZReverseEnumeration(GobManager.getSelectedElement( panelId ));
	while ( elm.hasMoreElements() ) {
//		ZDebug.trace();
		GElement item = (GElement)elm.nextElement();
		byte mode = item.getHitMode(transPt);
		if ( mode != GOperation.NONE ) {
			item.verbDblClick( transPt );
			break;
		}
	}
	}

	//## KeyListener ##################################################
	/**
	 * L[{[hꂽ
	 */
	public void keyPressed(KeyEvent e) {
	if ( e.getKeyCode() == KeyEvent.VK_SPACE ) {
//		ZDebug.trace("space in");
		ZInstance.prop().putBoolean(KEY_VK_SPACE,true);
	}
	}

	/**
	 * L[{[hꂽ
	 */
	public void keyReleased(KeyEvent e) {
	if ( e.getKeyCode() == KeyEvent.VK_SPACE ) {
//		ZDebug.trace("space out");
		ZInstance.prop().putBoolean(KEY_VK_SPACE,false);
	}
//	ZDebug.trace("KeyRelease:"+e);
	}

	/**
	 * L[{[hꂽ
	 */
	public void keyTyped(KeyEvent e) {
	}

	//## MouseListener ################################################
	/**
	 * }EXNbNꂽ
	 */
	public void mouseClicked(MouseEvent evt) {
	if(evt.getClickCount() == 2) {
		OnDblClick( evt );
	}
	}

	/**
	 * }EXꂽ
	 */
	public void mousePressed(MouseEvent evt) {
	if (  ( evt.getModifiers() & InputEvent.BUTTON3_MASK ) != 0 ) {
		OnRButtonDown( evt );
	} else if (  ( evt.getModifiers() & InputEvent.BUTTON1_MASK ) != 0 ) {
		OnLButtonDown( evt );
	}
	}

	/**
	 * }EXꂽ
	 */
	public void mouseReleased(MouseEvent evt) {
	if (  ( evt.getModifiers() & InputEvent.BUTTON3_MASK ) != 0 ) {
		OnRButtonUp( evt );
	} else if (  ( evt.getModifiers() & InputEvent.BUTTON1_MASK ) != 0 ) {
		OnLButtonUp( evt );
	}
	}

	/**
	 * }EX
	 */
	public void mouseEntered(MouseEvent evt) {
	}

	/**
	 * }EXo
	 */
	public void mouseExited(MouseEvent evt) {
	}

	//## MouseMotionListener ##########################################
	/**
	 * }EXhbOȂړ
	 * @param evt }EXCxg
	 */
	public void mouseDragged(MouseEvent evt){

	// r[|[g̎擾
	JViewport port  = (JViewport)mEditor.getParent();

	Point  ptCur  = evt.getPoint();
	Point  ptTL   = port.getViewPosition();

	Dimension dim = port.getSize();
	Dimension dc  = mEditor.getSize();

	// Â݂̏ꍇ͂ňړ
	if ( mMoveMode == GOperation.HANDON ) {
		ZPoint ptSta = mStartPoint ;

		Point pt = new Point( 
			(int)(ptSta.getX()-(ptCur.getX()-ptTL.x)),
			(int)(ptSta.getY()-(ptCur.getY()-ptTL.y)) );
		
		if (     pt.x < 0 )                    { pt.x = 0 ; }
		else if( pt.x > (dc.width-dim.width) ) { pt.x=dc.width-dim.width ;}
		if (     pt.y < 0 )                    { pt.y = 0 ; }
		else if( pt.y > (dc.height-dim.height)){ pt.y=dc.height-dim.height;}

		if ( pt.x != ptTL.x || pt.y != ptTL.y ) {
			port.setViewPosition( pt );
//			ZDebug.trace();
			mEditor.repaint();
		}
		return;
	}

	int offX = 0;
	int offY = 0;
	// ʂ͂ݏoĂꍇ͈ړTCY̐ݒ
	if (      ptCur.x < ptTL.x            ) { offX = -20 ; }
	else if ( ptCur.x > ptTL.x+dim.width  ) { offX =  20 ; }
	if (      ptCur.y < ptTL.y            ) { offY = -20 ; }
	else if ( ptCur.y > ptTL.y+dim.height ) { offY =  20 ; }

	// ʂ͂ݏoĂ̂ňړ
	if ( offX != 0 || offY != 0 ) {
		Point pt = new Point();
		pt.x = ptTL.x + offX ;
		pt.y = ptTL.y + offY ;
		// ʃTCYOɏoꍇ͈ړȂ
		if (    pt.x<0 )                    { pt.x=0 ; }
		else if(pt.x>(dc.width-dim.width) ) { pt.x=dc.width-dim.width ; }
		if (    pt.y<0 )                    { pt.y=0 ; }
		else if(pt.y>(dc.height-dim.height)){ pt.y=dc.height-dim.height;}
		port.setViewPosition( pt );

	}

	// ǉGob̍폜
	// ǉGob́ArepaintĂ΂getMovingPath()ō쐬A
	// GobManager.paintŕ`悳
	GobManager.list(mEditor.getPanelId(),GobManager.HIGHLIGHT).removeAllElements();

	if ( GobManager.getCurrent(mEditor.getPanelId()).size() > 0 ) {
		mEditor.getGridControler().setMoving( new ZPoint(evt.getPoint()),0 );
//		ZDebug.trace();
		mEditor.repaint();
	}
	}

	/**
	 * }EXړ
	 * @param evt }EXCxg
	 */
	public void mouseMoved(MouseEvent evt){
//	ZDebug.trace("mouseMoved:"+evt.getPoint());
	int nPrev = GobManager.size(mEditor.getPanelId(),GobManager.HIGHLIGHT);
	updateCursor(evt);
	int nCur = GobManager.size(mEditor.getPanelId(),GobManager.HIGHLIGHT);
	// nCCgɕωƂĕ`
	if ( nPrev != 0 || nCur != 0 ) {
//		ZDebug.trace();
		mEditor.repaint();
	}
	}

	//## [eBeB ###############################################
	/**
	 * J[\`̕ύX
	 * @param evt }EXCxg
	 */
	public void updateCursor(MouseEvent evt){
	byte nMode = GOperation.NONE;

	// nCCgGob̍폜
	// nCCgGob́AgetSelectedPreMoveMode()ō쐬A
	// GobManager.paintŕ`悳
	GobManager.list(mEditor.getPanelId(),GobManager.HIGHLIGHT).removeAllElements();

	// VK쐬AړAg̏ꍇ̓Iy[V̍쐬
	GElement ope = createOperation(evt);
	if ( ope != null ) {
		ZPoint transPt = ((DocElement)mEditor.getDocument().getRootElement(mEditor.getPanelId())).getDisplayScaledTransform(mEditor.getPanelId()).inverseTransform(new ZPoint(evt.getPoint()));
		nMode = ope.getPreMoveMode(transPt);
	}

	// VK쐬łȂꍇ
	if ( nMode == GOperation.NONE ) {
		// ݑI𒆗vfɃqbg邩H
		nMode = GobManager.getSelectedPreMoveMode(mEditor,new ZPoint(evt.getPoint()));
	}

	mEditor.setCursor(GOperation.getCursor(nMode));
	// ł͍ĕ`悵Ȃ
	// nCCgɕύXꍇ́AĂяoōĕ`悷
	}

	/**
	 * ̎擾
	 * @param evt }EXCxg
	 */
	public GElement createOperation(MouseEvent evt){
	GElement ope = null;
//	ZDebug.trace("SPC:"+ZInstance.prop().getProperty(KEY_VK_SPACE));

	String szState = ZInstance.prop().getProperty(DocBar.ACTION);

	// Rg[L[Ăꍇ
	if ( evt.isControlDown() ) {
		if ( evt.isAltDown() && evt.isShiftDown() ) {
			ope = new GOperationZoom(false);	// Ctrl+Alt+Shift	k
		} else if ( evt.isAltDown() ) {
			ope = new GOperationZoom(true);		// Ctrl+Alt			g
		}
		// else ړ	// NOP

	// AgL[Aړ[h
	} else if ( evt.isAltDown() ) {
		ope = new GOperationMove();

	} else if ( szState.equals(DocBar.SELECT_ACTION) ) {
		// NOP
	} else if ( szState.equals(DocBar.MOVE_ACTION) ) {
		ope = new GOperationMove();
	} else if ( szState.equals(DocBar.ZOOM_ACTION) ) {
		// ALT : k
		if ( evt.isShiftDown() ) {
			ope = new GOperationZoom(false);
		// : g
		} else {
			ope = new GOperationZoom(true);
		}
	} else {
		ope = new GOperationCreate(mEditor.getDocument(),szState);
	}

	return ope;
	}

	//## Agr[g################################################
    /**
     * Rei
     */
	protected DocPane	mEditor  = null ;

    /**
     * ړJn_
     */
	protected ZPoint	mStartPoint = null ;

    /**
     * ړ[h
     */
	protected byte		mMoveMode   = GOperation.NONE ;

    /**
     * ZInstanceL[FXy[XL[̏
     */
	static protected String KEY_VK_SPACE = "uiadapter.key.space" ;
}
