/*
 * @(#)DocElement.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */
package jp.co.iti.fagot.doc;

import java.awt.Color;

import java.util.Vector;

import org.w3c.dom.Node;
import org.w3c.dom.DOMException;

import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZPath;
import jp.co.iti.fagot.geom.ZRectangle;

import jp.co.iti.fagot.fob.FColor;

import jp.co.iti.fagot.fob.xml.XElementNS;

import jp.co.iti.fagot.gob.IGobContainer;
import jp.co.iti.fagot.gob.GobManager;
import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GRectangle;
import jp.co.iti.fagot.gob.GOperation;
import jp.co.iti.fagot.gob.PTransform;

import jp.co.iti.fagot.util.ZDebug;
/**
 * Gob ContainerGg
 *
 * ReiƂĕKvȃ\bhQ`B
 * implements IGobContainer ͂̃NX̔hNXł
 * DefaultElement Ɏ
 *
 * @author  N
 * @version 1.01 2001/03/22
 */
public class DocElement extends XElementNS implements IGobContainer {

	/**
	 * ftHgRXgN^
	 */
	protected DocElement() throws DOMException {
	}

	//## {:Rect #################################################
	/**
	 * `ێĂ邩H
	 * @param szKey ʒuL[
	 */
	public boolean hasRect(String szKey) {
	XElementNS elm = findChildElement(".ViewInfo."+szKey,null);
	if ( elm != null ) {
		return ( elm.hasAttribute("X") &&
				 elm.hasAttribute("Y") &&
				 elm.hasAttribute("Width") &&
				 elm.hasAttribute("Height") ) ;
	}
	return false;
	}

	/**
	 * `̐ݒ
	 * @param szKey ʒuL[
	 * @param rect  `
	 */
	public void setRect(String szKey, ZRectangle rect) {
	XElementNS elm = getChildElement(".ViewInfo."+szKey,null);
//	ZDebug.trace("DocElement:setRect:"+rect.toString());
//	if ( !szKey.endsWith("child") ) {
//		ZDebug.printStack();
//	}
	elm.setDoubleAttr("X"		, rect.getX());
	elm.setDoubleAttr("Y"		, rect.getY());
	elm.setDoubleAttr("Width"	, rect.getWidth());
	elm.setDoubleAttr("Height"	, rect.getHeight());
	}

	/**
	 * `̎擾
	 * @param szKey ʒuL[
	 */
	public ZRectangle getRect(String szKey) {
	XElementNS elm = findChildElement(".ViewInfo."+szKey,null);
	if ( elm == null ) {
		return new ZRectangle();
	}
	double dX      = elm.getDoubleAttr("X",0);
	double dY      = elm.getDoubleAttr("Y",0);
	double dWidth  = elm.getDoubleAttr("Width",0);
	double dHeight = elm.getDoubleAttr("Height",0);
	return new ZRectangle( dX, dY, dWidth, dHeight );
	}

	//## {:Scale ################################################
	/**
	 * \{̐ݒ
	 * {IɃ[gGĝݕێAgr[g
	 * @param szKey ʒuL[
	 * @param scale \{(1̎A100%)
	 */
	public void setDisplayScale(String szKey, double scale) {
	XElementNS elm = getChildElement(".ViewInfo."+szKey,null);
	elm.setDoubleAttr("DisplayScale", scale);
	}

	/**
	 * \{̎擾
	 * {IɃ[gGĝݕێAgr[g
	 * @param szKey ʒuL[
	 * @param scale \{(1̎A100%)
	 */
	public double getDisplayScale(String szKey) {
	XElementNS elm = findChildElement(".ViewInfo."+szKey,null);
	if ( elm == null ) {
		return 1;
	}
	return elm.getDoubleAttr("DisplayScale", 1);
//	return 1;
	}

	/**
	 * \{̎擾
	 * {IɃ[gGĝݕێAgr[g
	 *
	 * ʏDisplayOffset͎gpȂApplȂǓȃplŗLƂȂ
	 *
	 * @param szKey ʒuL[
	 */
	public PTransform getDisplayScaledTransform(String szKey) {
	XElementNS elm = getChildElement(".ViewInfo."+szKey,null);
	if ( elm == null ) {
		return new PTransform(1,0,0,1,0,0);
	}
	double dX = elm.getDoubleAttr("DisplayOffsetX",0);
	double dY = elm.getDoubleAttr("DisplayOffsetY",0);
	double dZ = getDisplayScale(szKey);
	return new PTransform(dZ,0,0,dZ,dX,dY);
	}

	//## {:DOM ##################################################
	/**
	 * Gob̍폜
	 * @param gob 폜ꂽgob
	 */
	public void removeGob(GElement gob) {
	removeFromDocTree();
	}

	/**
	 * DOM폜
	 */
	public void removeFromDocTree() {
	DocElement parent = (DocElement)getParentNode();
	if ( parent != null ) {
		parent.removeChild(this);
	}
	setStatus( "remove" ) ;
	}

	/**
	 * Ԃ̐ݒ
	 * @param szStatus 
	 */
	public void setStatus(String szStatus) {
//	mStatus = szStatus ;
	setAttribute("DocElementStatus",szStatus);
	for ( int nIndex=0; nIndex<getLength() ; nIndex++ ) {
		Node elm = (Node)item(nIndex);
		if ( elm instanceof DocElement ) {
			((DocElement)elm).setStatus( szStatus );
		}
	}
	}

	/**
	 * Ԃ̎擾
	 */
	public String getStatus() {
	return getAttribute("DocElementStatus");
//	return mStatus ;
	}


	//## I[oChFhLg ###############################
	/**
	 * Gg̒ǉ
	 * @param element Gg
	 */
//	public void addElement( DocElement element ) {
//	appendChild(element);
//	}

	/**
	 * `Gg̎擾
	 * @param szPanelId plʎq
	 * @param isRoot    [g̗L
	 */
	public Vector createGobs(String szPanelId,boolean isRoot) {
	Vector gobs = new Vector();
//	gobs.addAll(createChildGobs(szPanelId));
	return gobs;
	}

	/**
	 * `Gg̎擾̑O
	 * @param szPanelId plʎq
	 */
	public void preCreateGobs(String szPanelId) {
	// qm[h̕`
	for ( int nIndex=0; nIndex<getLength() ; nIndex++ ) {
		Node elm = (Node)item(nIndex);
		if ( elm instanceof DocElement ) {
			((DocElement)elm).preCreateGobs( szPanelId );
		}
	}
	}

	/**
	 * XPg`Gg̎擾
	 * @param szPanelId plʎq
	 * @param isRoot    [g̗L
	 */
	public Vector createSkeltonGobs(String szPanelId,boolean isRoot) {
	// Ƃ肠g̕`IuWFNgSĂԂ
	return createGobs(szPanelId,isRoot);
	}

	/**
	 * qm[h̕`Gg̎擾
	 * @param szPanelId plʎq
	 */
	public Vector createChildGobs(String szPanelId) {
	Vector gobs = new Vector();
	// qm[h̕`
	for ( int nIndex=0; nIndex<getLength() ; nIndex++ ) {
		Node elm = (Node)item(nIndex);
		if ( elm instanceof DocElement ) {
			gobs.addAll(((DocElement)elm).createGobs( szPanelId,false ));
		}
	}
	return gobs;
	}

	/**
	 * ReLXgL[̎擾
	 * @param szPanelId plʎq
	 */
	public String getContextKey(String szPanelId) {
	return getTagName()+"."+szPanelId;
	}

	//## IGobContainerFqbg ########################################
	/**
	 * vfɃqbg邩H
	 * @param gob NGXgGob
	 * @param pt  _W
	 */
	public byte getHitMode(GElement gob,ZPoint pt) {
	return gob.getHitModeGob(pt);
	}

	/**
	 * vf̈ړ[h͂ȂɂH
	 * @param gob NGXgGob
	 * @param pt   _W
	 */
	public byte getPreMoveMode(GElement gob,ZPoint pt) {
	return gob.getPreMoveModeGob(pt);
	}

	/**
	 * vfɐڑ邩H
	 * @param gob NGXgGob
	 * @param pt  _W
	 * @param obj  ڑΏ
	 */
	public byte getConnectMode(GElement gob,ZPoint pt,Object obj) {
	return gob.getConnectModeGob(pt,obj);
	}

	/**
	 * _uNbN̓
	 * @param gob  NGXgGob
	 * @param mode NbNʒu
	 */
	public void verbDblClick(GElement gob,ZPoint pt) {
	gob.verbDblClickGob(pt);
	}

	//## IGobContainerFړ ##########################################
	/**
	 * ړ̊Jn
	 * @param gob  NGXgGob
	 * @param grid ObhRg[
	 */
	public void moveStart(GElement gob,DocGridControler grid) {
	gob.moveStartGob(grid);
	}

	/**
	 * ړPath̎擾
	 * @param gob  NGXgGob
	 * @param grid ObhRg[
	 */
	public ZPath getMovingPath(GElement gob,DocGridControler grid) {
//	ZDebug.trace();
	return gob.getMovingPathGob(grid);
	}

	/**
	 * ړ̊
	 * @param gob  NGXgGob
	 * @param grid ObhRg[
	 */
	public void moveEnd(GElement gob,DocGridControler grid) {
	gob.moveEnd(grid);
	}

	//## IGobContainerFI ##########################################
	/**
	 * I̎擾
	 */
	public boolean isSelect() {
	return mSelect;
	}

	/**
	 * I̐ݒ
	 * @param gob  NGXgGob
	 * @param bSel I
	 */
	public boolean setSelect(GElement gob,boolean bSel) {
	mSelect = bSel;
	return mSelect;
	}

	//## ҏW #########################################################
	/**
	 * ̐ݒ
	 */
	public void setText(String szText) {
	}

	/**
	 * ̎擾
	 */
	public String getText() {
	return null;
	}

	//## SubTag #######################################################
	/**
	 * Tu^O̐ݒ
	 * Docbar琶ƂattributeŗL̂̂ɂ邽߂̃L[
	 * @param szText Tu^O
	 */
	public void setSubTag(String szText) {
	}

	//## Agr[g################################################
	/**
	 * IL
	 */
	protected boolean  mSelect     = false;

}
