/*
 * @(#)DocDocument.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */
package jp.co.iti.fagot.doc;

import java.awt.Color;
import java.awt.Dimension;

import java.util.Vector;
import java.util.Properties;

import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.DOMException;

import jp.co.iti.fagot.fob.FobManager;
import jp.co.iti.fagot.fob.xml.XDocument;

import jp.co.iti.fagot.geom.ZPoint;

import jp.co.iti.fagot.gob.PTransform;

import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.util.ZDebug;
/**
 * `敔iێhLgłB
 *
 * @author  N
 * @version 1.01 2001/03/22
 */
public class DocDocument extends XDocument {
//public class DocDocument extends org.apache.xerces.dom.DeferredDocumentImpl {

	/**
	 * RXgN^
	 */
	public DocDocument(){
	}

	/**
	 * RXgN^
	 * @param szDocumentId hLgʎq
	 */
	public DocDocument(String szDocumentId){
	this();
	setDocumentId(szDocumentId);
	}

	/**
	 * id̐ݒ
	 * @param szDocumentId hLgʎq
	 */
	public void setDocumentId(String szDocumentId) {
	mDocumentId = szDocumentId;

	// vpeB[h
	ZProperties prop = DocManager.loadProperty( DocManager.DOCUMENT );
	setEncoding(prop.getProperty(mDocumentId+".encoding"));
	mIndenting = prop.getBoolean(mDocumentId+".indenting",true);
	}

	/**
	 * id̎擾
	 * @param hLgId
	 */
	public String getDocumentId() {
	return mDocumentId;
	}

	/**
	 * GR[fBO̎擾
	 * @param GR[fBO
	 */
//	public String getEncoding() {
//	return mEncoding;
//	}

	/**
	 * Cfg̎擾
	 * @param Cfg
	 */
	public boolean getIndenting() {
	return mIndenting;
	}

	//## plĂяo郁\bh ###############################
	/**
	 * wiF̎擾
	 * @param szPanelId plʎq
	 */
	public Color getBackground(String szPanelId) {
	return new Color(0xFFFFFF);
	}

	/**
	 * R|[lgɍœKȃTCYԂ܂
	 * [gGg̕\{Ƙ_TCY킹܂
	 */
	public Dimension getPreferredSize(String szPanelId) {
	DocElement root = (DocElement)getRootElement(szPanelId);
	if ( root == null ) {
		return getLogicalSize();
	}
	double scale = root.getDisplayScale(szPanelId);
	// PȊ|ZAȂ悤PTransformŌvZ
	// offset0łȂȂ̂ŁAgetDisplayScaledTransform͎gpȂ
	PTransform trans = new PTransform(scale,0,0,scale,0,0);
	Dimension dim = getLogicalSize();
	ZPoint pttrans = trans.transform(new ZPoint(dim.getWidth(),dim.getHeight()));
	dim = new Dimension((int)pttrans.getX(),(int)pttrans.getY());
//	ZDebug.trace(dim.toString());
	return dim;
	}

	/**
	 * R|[lg̘_IȍœKTCYԂ܂
	 * ̒l͊gk\̗Lɂ炸ŒłB
	 *
	 * getPreferredSize͊g\Ƒ傫ȂAk\ƏȂ܂
	 */
	public Dimension getLogicalSize() {
	return new Dimension(800,600);
	}

	//## IDocument ####################################################
	/**
	 * 
	 */
	public void initDocument() {
	ZProperties prop = DocManager.loadProperty( DocManager.DOCUMENT );

	// hLg^Cv
	String szRoot   = prop.getProperty(mDocumentId+".doctype.root");
	String szPublic = prop.getProperty(mDocumentId+".doctype.public");
	String szSystem = prop.getProperty(mDocumentId+".doctype.ststem");
	if ( szPublic != null || szSystem != null ) {
		DocumentType doctype = createDocumentType( szRoot, szPublic, szSystem );
		appendChild(doctype);
	}

	// Processing instruction
	for ( int nIndex=1 ; nIndex<100 ; nIndex++ ) {
		String target = prop.getProperty(mDocumentId+".processinginstruction.target."+nIndex);
		String data   = prop.getProperty(mDocumentId+".processinginstruction.data."+nIndex);
		if ( target != null && data != null ) {
			ProcessingInstruction pi = createProcessingInstruction(target, data);
			appendChild(pi);
		} else {
			break;
		}
	}

	// [gGg̍쐬
	Element elm = createElementNS(null,szRoot);
	appendChild(elm);
	}

	//## ŗL #########################################################
	/**
	 * ݃[g̎擾
	 * @param szPanelId
	 */
	public Element getRootElement(String szPanelId) {
	return getDocumentElement();
	}

	//## I[oChFDOMt@Ng[ ################################
	/**
	 * Gg
	 */
	public Element createElement(String tagName) throws DOMException {
	return createElementNS(null,tagName);
	}

	//## I[oChFDOM2 NameSpace t@Ng[ ####################
	/**
	 * Gg
	 * @param ns    l[Xy[X
	 * @param name  ^O
	 */
	public Element createElementNS(String ns, String name) throws DOMException {
	Element elm = (Element)DocManager.createElement(this,ns,name);
	// Ȃꍇ͐eNX璊o
	if ( elm == null ) {
		// ڍ׃^Cv邩H
		String [] names = ZString.tokenize(name,"@");
		if ( names.length == 2 ) {
			elm = (Element)DocManager.createElement(this,ns,names[0]);
			if ( elm instanceof DocElement ) {
				((DocElement)elm).setSubTag( names[1] );
			}
		} else {
			elm = new DocElement();
			((DocElement)elm).constructElement(this,ns,name);
		}
	}
	return elm;
	}

	//## ̑ #######################################################
	/**
	 * `Gg̎擾
	 * @param szPanelId plʎq
	 */
	public Vector createGobs(String szPanelId) {
	DocElement elm = (DocElement)getRootElement(szPanelId);
	if ( elm != null ) {
		return elm.createGobs(szPanelId,true);
	}
	return new Vector();
	}

	/**
	 * `Gg̎擾
	 * @param szPanelId plʎq
	 */
	public Vector createSkeltonGobs(String szPanelId) {
	DocElement elm = (DocElement)getRootElement(szPanelId);
	if ( elm != null ) {
		return elm.createSkeltonGobs(szPanelId,true);
	}
	return new Vector();
	}

	//## Agr[g ###############################################
	/**
	 * hLgID
	 */
	protected String mDocumentId = "default";

	/**
	 * GR[fBO
	 */
//	protected String mEncoding = null;

	/**
	 * Cfg
	 */
	protected boolean mIndenting = true;
}
