/**
 * @(#)DocComponent.java
 *
 * Copyright 2000 by Intelligent Technology Inc. All rights reserved.
 *
 * hLgRei
 */
package jp.co.iti.fagot.doc;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Graphics;

import java.awt.image.BufferedImage;

import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.UIManager;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingConstants;

import javax.swing.event.AncestorListener;
import javax.swing.event.AncestorEvent;

import jp.co.iti.fagot.ZApp;

import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZDebug;
/**
 * hLgReiƂȂJComponent
 * JComponentƂĕKvȃ\bhQ`B
 * ̃NX̔hNXłDocPaneɂāA`ɕKvȍ\`B
 *
 * DocComponent(JComponent):Rei
 *
 * DocUI(ComponentUI):
 *     - ReiL&Fݒ
 *     - PropertyChangenh̓o^
 *     - EditorKitĂяoView,Docuemnt̐
 *     - `(DocView.painťĂяo)
 * DocUIAdapter:}EXAL[{[hCxgnh
 * DocGridControler:gkĂՂȃTCỸObh`
 *
 * @author  N
 * @version 1.01 2000/12/01
 */
public class DocComponent extends JComponent implements Scrollable, Accessible {

	/**
	 * RXgN^
	 */
	public DocComponent() {
	super();
	updateUI();
	setDocument(createDocument());

	addAncestorListener( new DocAncestorAdapter());
	}

	/**
	 * RXgN^
	 * @param panelId plʎq
	 */
	public DocComponent(String panelId){
	this();
	mPanelId = panelId;
	}

	//## IPane ########################################################
	/**
	 * plʎq̎擾
	 */
	public String getPanelId() {
	return mPanelId;
	}

	/**
	 * hLg̍쐬
	 */
	public DocDocument createDocument() {
	DocDocument doc = new DocDocument();
	doc.initDocument();
	return doc;
	}

	/**
	 * hLg̐ݒ
	 * @param doc hLg
	 * @see JComponent#accessibleContext
	 */
	public void setDocument(DocDocument doc) {
	DocDocument oldDoc = mDoc;
    mDoc = doc;
    firePropertyChange("document", oldDoc, mDoc);
    revalidate();	// JComponent:xCAEgT|[g܂B
					// CAEg͎gȂ̂Ŋ֌WȂȁH
    repaint();		//

	// R|[lg̏
	setUIAdapter( createUIAdapter() );
	setGridControler( createGridControler() );
	}

	/**
	 * hLg̎擾
	 */
	public DocDocument getDocument() {
	return mDoc ;
	}

	//## UIA_v^[ #################################################
	/**
	 * UIA_v^̍쐬
	 * @return UIA_v^
	 */
	public DocUIAdapter createUIAdapter() {
	return null;
	}

	/**
	 * UIA_v^̐ݒ
	 * @param adapter UIA_v^
	 */
	public void setUIAdapter(DocUIAdapter adapter) {
	// A_v^[̐ݒ
	if ( mUIAdapter != null ) {
		removeMouseListener( mUIAdapter );
		removeMouseMotionListener( mUIAdapter );
		removeKeyListener( mUIAdapter );
	}
	mUIAdapter = adapter;
	addMouseListener( mUIAdapter );
	addMouseMotionListener( mUIAdapter );
	addKeyListener( mUIAdapter );
	}


	//## ObhRg[ #########################################
	/**
	 * ObhRg[̍쐬
	 * @param grid ObhRg[
	 */
	public DocGridControler createGridControler() {
	return new DocGridControler();
	}

	/**
	 * ObhRg[̐ݒ
	 * @param grid ObhRg[
	 */
	public void setGridControler(DocGridControler grid) {
	mGrid = grid;
	}

	/**
	 * ObhRg[̐ݒ
	 * @param grid ObhRg[
	 */
	public DocGridControler getGridControler() {
	ZResource res = ZApp.getTheApp().getResource();
	boolean isGrid = res.getBoolean( "edit.grid", true );
	double  dSize  = res.getInt( "edit.gridsize", 10 );
	mGrid.setEnable(isGrid);
	mGrid.setGrid(dSize,dSize);
	return mGrid;
	}

	//## UI ###########################################################
	/**
	 * UI̍XV
	 */
	public void updateUI() {
	setUI( new DocUI() );
	invalidate();
	}

	/**
	 * `(Gob̍쐬)
	 */
	public void paintTemporary() {
	BufferedImage bi = new BufferedImage(
		(int)10,
		(int)10,
		BufferedImage.TYPE_INT_RGB);
	paintComponent(bi.createGraphics());
    }

	//## C^[tFCXFScrollable #################################
	/**
	 * R|[lgɍœKȃTCYԂ܂
	 */
	public Dimension getPreferredScrollableViewportSize() {
	return getPreferredSize() ;
	}

	/**
	 * 1 s܂ 1 SɃGNX|[YXN[lvZ܂
	 */
	public int getScrollableUnitIncrement(Rectangle visibleRect,
    	                                  int orientation,
    	                                  int direction) {
	switch(orientation) {
      case SwingConstants.VERTICAL:
        return ( 10 );
      case SwingConstants.HORIZONTAL:
        return ( 10 );
      default:
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }
	}

	/**
	 *ubNGNX|[YXN[lvZ܂
	 */
	public int getScrollableBlockIncrement(Rectangle visibleRect,
    	                                   int orientation,
    	                                   int direction) {
	switch(orientation) {
      case SwingConstants.VERTICAL:
        return ( 100 /*visibleRect.height*/ );
      case SwingConstants.HORIZONTAL:
        return ( 100 /*visibleRect.width*/ );
      default:
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }
	}

	/**
	 * r[|[gł Scrollable ̕Ƀr[|[g̕ɍ킹ꍇ
	 * ɁAtrue Ԃ܂B
	 */
	public boolean getScrollableTracksViewportWidth() {
	if (getParent() instanceof JViewport) {
	    return (((JViewport)getParent()).getWidth() > getPreferredSize().width);
	}
	return (false);
	}

	/**
	 * r[|[gł Scrollable ̍Ƀr[|[g̍
	 * 킹ꍇɁAtrue Ԃ܂B
	 */
	public boolean getScrollableTracksViewportHeight() {
	if (getParent() instanceof JViewport) {
	    return (((JViewport)getParent()).getHeight() > getPreferredSize().height);
	}
	return false;
	}

	//## C^[tFCXFAccessible #################################
	/**
	 * IuWFNgɊ֘A AccessibleContext Ԃ܂
	 * @see JComponent#accessibleContext
	 */
	public AccessibleContext getAccessibleContext() {
	if (accessibleContext == null) {
		accessibleContext = new DocAccessibleComponent();
    }
    return accessibleContext;
	}

	//## TuNX ###################################################
	/**
	 * `NXp̃[U⏕@\̃T|[gĂ܂B
	 */
	public class DocAccessibleComponent extends AccessibleJComponent {
	/**
	 * RXgN^
	 */
	public DocAccessibleComponent() {
	}
	}

	//## TuNX:ComponentAdapter ##################################
	public class DocAncestorAdapter implements AncestorListener{
	/*
	 * RXgN^
	 */
	public DocAncestorAdapter(){
	}

	/*
	 * EBhEANeBuꂽ
	 * VK쐬{^̒u  {^̏
	 */
	public void ancestorAdded(AncestorEvent event){
	requestFocus();
	}

	/*
	 *
	 */
	public void ancestorMoved(AncestorEvent event){
	}

	/*
	 *
	 */
	public void ancestorRemoved(AncestorEvent event){
	}

	}

	//## Agr[g################################################
    /**
     * UIA_v^
     */
	protected DocUIAdapter	mUIAdapter = null;

    /**
     * hLg
     */
	protected DocDocument	mDoc = null;

	/**
	 * plʎq
	 */
	protected String mPanelId = "default";

	/**
	 * ObhRg[[
	 */
	protected DocGridControler	mGrid = null;
}
