/*
 * @(#)ZFileAction.java
 *
 * Copyright 2001 by Intelligent Technology Inc. All rights reserved.
 */
package jp.co.iti.fagot.action;

import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;

import java.io.File;
import java.io.IOException;

import javax.swing.Action;
import javax.swing.JFileChooser;

import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZFile;
import jp.co.iti.fagot.util.ZFileFilter;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.IZFileable;

import jp.co.iti.fagot.util.ZInstance;

import jp.co.nri.Ridual;
/**
 * JE㏑ۑEOtĕۑANV
 */
public class ZFileAction extends ZAction {
	/**
	 * ftHgRXgN^(save)
	 * @param app      AvP[VNX
	 * @param cmp      R|[lg
	 * @param szAction ANV
	 */
	public ZFileAction(IZApp app,IZFileable cmp,String szAction) {
    super(app,szAction);
	mCmp    = cmp ;
	}

	/**
	 * ŋߎgt@Cp̃RXgN^(open)
	 * @param app      AvP[VNX
	 * @param cmp      R|[lg
	 * @param szAction ANV
	 * @param szFile   Jt@C
	 */
	public ZFileAction(IZApp app,IZFileable cmp,String szAction,
		String szFile) {
    this(app,cmp,szAction);
	mFile = szFile ;
	}

	/**
	 * t@CtB^ݒp̃RXgN^(saveas)
	 * @param app      AvP[VNX
	 * @param cmp      R|[lg
	 * @param szAction ANV
	 * @param filter   t@CtB^
	 */
	public ZFileAction(IZApp app,IZFileable cmp,String szAction,
		ZFileFilter filter) {
    this(app,cmp,szAction);
	mFileFilter = filter ;
	}

	/**
	 * \[X璼OɊJt@C擾ꍇ̃L[{
	 * t@CtB^ݒp̃RXgN^(open)
	 * @param app      AvP[VNX
	 * @param cmp      R|[lg
	 * @param szAction ANV
	 * @param szRecent \[XL[
	 * @param filter   t@CtB^
	 */
	public ZFileAction(IZApp app,IZFileable cmp,String szAction,
		String szRecent,ZFileFilter filter) {
    this(app,cmp,szAction);
	mRecent     = szRecent;
	mFileFilter = filter  ;
	}

	/**
	 * ANVs
	 */
	public void doAction(ActionEvent e) {
	if ( getActionName().equals( NEW ) ) {
		if ( getApp().preExit( false ) ) {
			mCmp.open( null );
		}
	} else if ( getActionName().equals( OPEN ) ) {
		if ( getApp().preExit( false ) ) {
			if ( mFile != null ) {
				mCmp.open( mFile );
			} else {
				open();
			}
		}
	} else if ( getActionName().equals( SAVE  ) ) {
		if ( checkLicense() ) {
			if ( mCmp.canSave() ) {
				mCmp.save();
			} else {
				saveAs();
			}
		}
	} else if ( getActionName().equals( SAVEAS ) ) {
		if ( checkLicense() ) {
			saveAs();
		}
	}
	}

	/**
	 * J
	 */
	protected void open() {
    Frame   frame = getApp().getFrame();

    if (mFileDialog == null) {
		createDialog();
	}

	// ʒuC
    Point p = frame.getLocationOnScreen();
    mFileDialog.setLocation(p.x + 10, p.y +10);

	// _CAOJ
	int nRet = mFileDialog.showOpenDialog(frame);
	if ( nRet == JFileChooser.APPROVE_OPTION) {
		// t@CJ
		File fFile = mFileDialog.getSelectedFile();
		String szFile = null ;
		try {
			szFile = fFile.getCanonicalPath();
	    } catch ( java.io.IOException e) {
			szFile = fFile.getAbsolutePath();
		}
		mCmp.open( szFile );
	}
	}

	/**
	 * Otĕۑ
	 */
	public boolean saveAs() {
    Frame   frame = getApp().getFrame();
    if (mFileDialog == null) {
		createDialog();
	}

	// ʒuC
    Point p = frame.getLocationOnScreen();
    mFileDialog.setLocation(p.x + 10, p.y +10);

	// _CAOJ
	int nRet = mFileDialog.showSaveDialog(frame);
	if ( nRet == JFileChooser.APPROVE_OPTION) {
		// t@CJ
		File fFile = mFileDialog.getSelectedFile();
		String szFile = null ;
		try {
			szFile = fFile.getCanonicalPath();
	    } catch ( java.io.IOException e) {
			szFile = fFile.getAbsolutePath();
		}
		return ( mCmp.saveAs( szFile ) );
	}
	return false;
	}

	/**
	 * t@CI_CAO̍쐬
	 */
	protected void createDialog() {
	ZResource res = getApp().getResource();

	mFileDialog = new JFileChooser();
	// t@CtB^̐ݒ
	if ( mFileFilter != null ) {
		mFileDialog.setFileFilter(mFileFilter);
	}

	// fBNg̐ݒ
	if ( mRecent != null ) {
		String szFile = res.getString(mRecent);
		if ( szFile != null ) {
			mFileDialog.setCurrentDirectory(
				new File(ZFile.getParent(szFile) ) );
		}
	}
	}

	/**
	 * CZX̃`FbN
	 */
	public boolean checkLicense() {
	Ridual app = (Ridual)ZApp.getTheApp();
	return app.checkLicense(true);
	}
	//## Agr[g ###############################################
    /**
     * _CAO{bNX
     */
    protected JFileChooser mFileDialog = null;

    /**
     * R|[lg
     */
	protected IZFileable mCmp = null ;

    /**
     * Jt@C
     */
    protected String       mFile = null;

    /**
     * OɊJt@C̃L[
     */
	protected String       mRecent = null ;

    /**
     * t@CtB^
     */
	protected ZFileFilter  mFileFilter = null ;

    /**
     * ANVFVK쐬
     */
	final static public String NEW    = "new" ;

    /**
     * ANVFJ
     */
	final static public String OPEN   = "open" ;

    /**
     * ANVFۑ
     */
	final static public String SAVE   = "save" ;

    /**
     * ANVFOtĕۑ
     */
	final static public String SAVEAS = "saveas" ;
}
