/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.table.editor;

import java.awt.Color;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import jp.co.nri.rid.table.editor.CECAdapter;
import jp.co.nri.rid.table.editor.iCellEditorComponent;

public class ChooseCEC
extends JComboBox
implements iCellEditorComponent {
    protected Color myFore;
    protected Color myBack;
    private CECAdapter myCECAdapter;

    protected ChooseCEC() {
    }

    public ChooseCEC(boolean bl, ActionListener actionListener) {
        this.init(bl, actionListener);
    }

    public ChooseCEC(String[] stringArray, boolean bl, ActionListener actionListener) {
        super(stringArray);
        this.insertItemAt("", 0);
        this.init(bl, actionListener);
    }

    protected void init(boolean bl, ActionListener actionListener) {
        this.myFore = this.getForeground();
        this.myBack = this.getBackground();
        this.setBorder(null);
        this.editable(bl);
        this.addActionListener(actionListener);
        if (actionListener instanceof CECAdapter) {
            this.myCECAdapter = (CECAdapter)actionListener;
            this.playCECAdapter();
        }
    }

    public String text() {
        return (String)this.getSelectedItem();
    }

    public void text(String string) {
        this.pauseCECAdapter();
        this.setSelectedIndex(this.index(string));
        this.playCECAdapter();
    }

    public JComponent component() {
        return this;
    }

    private int index(String string) {
        if (null == string) {
            return 0;
        }
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getItemAt(i).toString().equals(string)) continue;
            return i;
        }
        return 0;
    }

    public void focus(boolean bl, JTable jTable) {
        if (bl) {
            this.setForeground(jTable.getSelectionForeground());
            this.setBackground(jTable.getSelectionBackground());
        } else {
            this.setForeground(this.myFore);
            this.setBackground(this.myBack);
        }
    }

    public void editable(boolean bl) {
        this.setEnabled(bl);
    }

    public void pauseCECAdapter() {
        try {
            this.myCECAdapter.editor(null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void playCECAdapter() {
        try {
            this.myCECAdapter.editor(this);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

