/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.table;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZResource;
import jp.co.nri.rid.RMenu;
import jp.co.nri.rid.table.ClmDef;
import jp.co.nri.rid.table.RClmDefs;
import jp.co.nri.rid.table.RXMLTableModel;
import jp.co.nri.rid.table.editor.RCellEditor;
import jp.co.nri.rid.table.editor.SortedHeaderRenderer;
import jp.co.nri.rid.xml.elementBooster;
import org.w3c.dom.Document;

public class RTable
extends JTable {
    private TableColumnModel dmyColumnModel;
    public Columns columns;
    public int SortedModelIndex = -1;

    public RTable(String string) {
        this.columns = new Columns(string);
        this.dmyColumnModel = new DefaultTableColumnModel();
        this.setAutoResizeMode(0);
        this.setRowHeight(24);
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setDefaultRenderer(new SortedHeaderRenderer());
        jTableHeader.addMouseListener(new SortAdapter());
        this.addMouseListener(new RMouseAdapter());
    }

    public void reload(Document document) {
        this.setColumnModel(this.dmyColumnModel);
        this.setModel(new RXMLTableModel(document, this.columns.defs));
        this.setColumnModel(this.columns.model());
        this.SortedModelIndex = -1;
    }

    public void reloadColumn() {
        this.removeEditor();
        this.setColumnModel(this.columns.model());
    }

    private class RMouseAdapter
    implements MouseListener {
        private RMouseAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            DocElement docElement;
            elementBooster elementBooster2;
            int n = RTable.this.rowAtPoint(mouseEvent.getPoint());
            int n2 = RTable.this.columnAtPoint(mouseEvent.getPoint());
            if (0 <= n && 0 <= n2 && mouseEvent.isPopupTrigger() && null != (elementBooster2 = ((RXMLTableModel)RTable.this.getModel()).element(n, n2)) && null != (docElement = (DocElement)((Object)elementBooster2.element()))) {
                RMenu.createContextMenu(mouseEvent, docElement);
            }
        }
    }

    private class ColumnAdapter
    implements TableColumnModelListener {
        private RClmDefs myClmDefs;

        public ColumnAdapter(RClmDefs rClmDefs) {
            this.myClmDefs = rClmDefs;
        }

        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnMarginChanged(ChangeEvent changeEvent) {
            this.myClmDefs.save();
        }

        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            String string = null;
            int n = RTable.this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                String string2 = RTable.this.getColumnName(i);
                string = null == string ? string2 : string + " " + string2;
            }
            ZResource zResource = ZApp.getTheApp().getResource();
            zResource.putString(RTable.this.columns.TableName() + ".columnsorder." + RTable.this.columns.ColumnOrder(), string);
        }

        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    private class SortAdapter
    extends MouseAdapter {
        private SortAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            int n2 = jTableHeader.columnAtPoint(point);
            ((RTable)jTableHeader.getTable()).SortedModelIndex = n = jTableHeader.getColumnModel().getColumn(n2).getModelIndex();
            RXMLTableModel rXMLTableModel = (RXMLTableModel)jTableHeader.getTable().getModel();
            rXMLTableModel.sort(n);
        }
    }

    public class Columns {
        public RClmDefs defs;
        private HashMap myColumns;
        private String myTableName;
        private String myColumnOrderKey;

        public Columns(String string) {
            this.myTableName = string;
            this.myColumnOrderKey = ZApp.getTheApp().getResource().getString(this.myTableName + ".columnorder");
            if (null == this.myColumnOrderKey) {
                this.myColumnOrderKey = DocManager.loadProperty("element").getProperty(this.myTableName + ".columnsorder.defaultkey");
            }
            this.defs = new RClmDefs(this.myTableName);
            this.myColumns = new HashMap();
            ClmDef[] clmDefArray = this.defs.ClmDefs();
            int n = clmDefArray.length;
            for (int i = 0; i < n; ++i) {
                ClmDef clmDef = clmDefArray[i];
                TableColumn tableColumn = new TableColumn(i, clmDef.width, new RCellEditor(clmDef.type, clmDef.editable), new RCellEditor(clmDef.type, clmDef.editable));
                if (clmDef.sorttype != null && clmDef.sorttype.equals("int")) {
                    RCellEditor rCellEditor;
                    RCellEditor rCellEditor2 = (RCellEditor)tableColumn.getCellRenderer();
                    if (rCellEditor2.CEC() instanceof JTextField) {
                        ((JTextField)((Object)rCellEditor2.CEC())).setHorizontalAlignment(4);
                    }
                    if ((rCellEditor = (RCellEditor)tableColumn.getCellEditor()).CEC() instanceof JTextField) {
                        ((JTextField)((Object)rCellEditor.CEC())).setHorizontalAlignment(4);
                    }
                }
                tableColumn.setHeaderValue(clmDef.title);
                clmDef.column = tableColumn;
                this.myColumns.put(clmDef.name, tableColumn);
            }
        }

        public String ColumnOrder() {
            return this.myColumnOrderKey;
        }

        public void ColumnOrder(String string) {
            this.myColumnOrderKey = string;
            ZApp.getTheApp().getResource().putString(this.myTableName + ".columnorder", string);
        }

        public TableColumnModel model() {
            Object object;
            DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
            ZProperties zProperties = DocManager.loadProperty("element");
            String string = null;
            if (null != this.myColumnOrderKey) {
                object = this.myTableName + ".columnsorder." + this.myColumnOrderKey;
                string = ZApp.getTheApp().getResource().getString((String)object);
                if (null == string) {
                    string = zProperties.getProperty((String)object);
                }
            }
            if (null == string) {
                string = DocManager.loadProperty("element").getProperty(this.myTableName + ".colums.names");
            }
            object = new StringTokenizer(string, " ");
            while (((StringTokenizer)object).hasMoreTokens()) {
                try {
                    defaultTableColumnModel.addColumn((TableColumn)this.myColumns.get(((StringTokenizer)object).nextToken()));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            defaultTableColumnModel.addColumnModelListener(new ColumnAdapter(this.defs));
            return defaultTableColumnModel;
        }

        public String TableName() {
            return this.myTableName;
        }
    }
}

