/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.mapper;

import java.io.FileOutputStream;
import java.io.OutputStream;
import jp.co.iti.fagot.util.ZDebug;
import org.apache.xml.serialize.DOMSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlUtil {
    public String getTextValue(Node node, String string) throws Exception {
        Node node2 = XPathAPI.selectSingleNode((Node)node, (String)string);
        if (node2 == null) {
            ZDebug.err("Fail to get text Value: \"" + string + "\" in " + node.getNodeName() + ".");
            throw new Exception();
        }
        return this.getTextValue(node2);
    }

    public String getTextValue(Node node) throws Exception {
        Node node2 = XPathAPI.selectSingleNode((Node)node, (String)"text()");
        if (node2 == null) {
            return "";
        }
        return node2.getNodeValue();
    }

    public String createOrGetTextValue(Node node) throws Exception {
        Node node2 = XPathAPI.selectSingleNode((Node)node, (String)"text()");
        if (node2 == null) {
            Document document = node.getOwnerDocument();
            node2 = document.createTextNode("");
            node.appendChild(node2);
        }
        return node2.getNodeValue();
    }

    public String createOrGetTextValue(Node node, String string) throws Exception {
        Element element = this.createOrGetSubElement(node, string);
        return this.createOrGetTextValue(element);
    }

    public void setTextValue(Node node, String string, String string2) throws Exception {
        Node node2 = XPathAPI.selectSingleNode((Node)node, (String)string);
        if (node2 == null) {
            ZDebug.err("Fail to set text Value.");
            throw new Exception();
        }
        this.setTextValue(node2, string2);
    }

    public void setTextValue(Node node, String string) throws Exception {
        Node node2 = XPathAPI.selectSingleNode((Node)node, (String)"text()");
        node2.setNodeValue(string);
    }

    public void createOrSetTextValue(Node node, String string) throws Exception {
        Node node2 = XPathAPI.selectSingleNode((Node)node, (String)"text()");
        if (node2 == null) {
            Document document = node.getOwnerDocument();
            Text text = document.createTextNode(string);
            node.appendChild(text);
        } else {
            node2.setNodeValue(string);
        }
    }

    public void createOrSetTextValue(Element element, String string, String string2) throws Exception {
        Element element2 = this.createOrGetSubElement(element, string);
        this.createOrSetTextValue(element2, string2);
    }

    public Element createOrGetSubElement(Node node, String string) throws Exception {
        Element element = (Element)XPathAPI.selectSingleNode((Node)node, (String)string);
        if (element == null) {
            Document document = node.getOwnerDocument();
            element = document.createElement(string);
            node.appendChild(element);
        }
        return element;
    }

    public Element createSubElement(Node node, String string) throws Exception {
        Document document = node.getOwnerDocument();
        Element element = document.createElement(string);
        node.appendChild(element);
        return element;
    }

    public boolean hasChild(Element element, String string) throws Exception {
        NodeList nodeList = XPathAPI.selectNodeList((Node)element, (String)string);
        return nodeList.getLength() > 0;
    }

    public boolean writeDocment2XMLFile(String string, Document document) throws Exception {
        OutputFormat outputFormat = new OutputFormat(document, "Shift_JIS", true);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        DOMSerializer dOMSerializer = new XMLSerializer((OutputStream)fileOutputStream, outputFormat).asDOMSerializer();
        dOMSerializer.serialize(document);
        return true;
    }
}

