/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.mapper;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Vector;
import jp.co.nri.rid.error.RidException;
import jp.co.nri.rid.error.RidMessage;
import jp.co.nri.rid.mapper.MapperBase;
import jp.co.nri.rid.mapper.MapperResource;
import jp.co.nri.rid.mapper.XmlUtil;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapperType3
extends MapperBase {
    private static String pr_errorString;
    private static final String ROOT_ELEMENT = "RidProject";
    private static final String MAP_ATTR = "MapAttr";
    private static final String MAP_ATTR_DATA = "MapAttrData";
    private static final String RID_TMP = "Rid_Tmp";
    private static final String MAPDATA = "MapData";
    private static final String SRC_TAG = "srcTag";
    private static final String SRC_KEY = "srcKey";
    private static final String DATA_TAG = "dataTag";
    private static final String DATA_KEY = "dataKey";
    private static final String IN_TAG = "inTag";
    private static final String OUT_ATTR = "outAttr";
    private static final String NAME = "name";

    public MapperType3() {
        pr_errorString = "";
    }

    public boolean Type3(String string, Document document, String string2) throws RidException {
        boolean bl = false;
        Vector vector = new Vector();
        RidMessage ridMessage = new RidMessage();
        try {
            if (this.checkFile(string) && (bl = this.type3DataDomParser(document, vector))) {
                bl = this.type3Generate(string, vector, string2);
            }
            if (bl) {
                MapperResource mapperResource = new MapperResource();
                mapperResource.imageFileCopy(string, string2);
            }
        }
        catch (Exception exception) {
            String string3 = ridMessage.Error("E4002", " (Mapper) " + exception.getMessage());
            if (string3.indexOf("Filename too long") != -1) {
                string3 = ridMessage.Error("E4003", " (Mapper) " + exception.getMessage());
            }
            throw new RidException(string3);
        }
        return bl;
    }

    public boolean type3DataDomParser(Document document, Vector vector) throws Exception {
        Object object;
        XmlUtil xmlUtil = new XmlUtil();
        boolean bl = false;
        Element element = document.getDocumentElement();
        if (!this.checkRootElement(element, ROOT_ELEMENT)) {
            object = "Root element name is different.";
            this.setErrorString((String)object);
            element = null;
        }
        if (element != null) {
            object = XPathAPI.selectNodeList((Node)element, (String)"*");
            for (int i = 0; i < object.getLength(); ++i) {
                Vector<MapperBase.MapData> vector2 = new Vector<MapperBase.MapData>();
                Element element2 = (Element)object.item(i);
                NodeList nodeList = XPathAPI.selectNodeList((Node)element2, (String)"*");
                for (int j = 0; j < nodeList.getLength(); ++j) {
                    Element element3 = (Element)nodeList.item(j);
                    MapperBase.MapData mapData = new MapperBase.MapData();
                    mapData.name = element3.getNodeName();
                    mapData.data = xmlUtil.getTextValue(element3);
                    vector2.add(mapData);
                }
                MapperBase.DataItem dataItem = new MapperBase.DataItem();
                dataItem.tagName = element2.getNodeName();
                dataItem.mapData_lst = vector2;
                vector.add(dataItem);
            }
            bl = true;
        }
        return bl;
    }

    private boolean type3Generate(String string, Vector vector, String string2) throws Exception {
        boolean bl = false;
        char[] cArray = new char[256];
        Vector vector2 = new Vector();
        this.inRepeatFileParser(string, vector2);
        InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(string));
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(string2));
        int n = 0;
        block0: for (int i = 0; i < vector2.size(); ++i) {
            MapperBase.TagItem tagItem = (MapperBase.TagItem)vector2.elementAt(i);
            while (inputStreamReader.read(cArray, 0, 1) != -1) {
                if (n >= tagItem.sPos) {
                    ++n;
                    break;
                }
                outputStreamWriter.write(cArray, 0, 1);
                ++n;
            }
            String string3 = this.getRepeatString(tagItem, vector);
            outputStreamWriter.write(string3, 0, string3.length());
            while (inputStreamReader.read(cArray, 0, 1) != -1) {
                if (n >= tagItem.ePos) {
                    ++n;
                    continue block0;
                }
                ++n;
            }
        }
        while (inputStreamReader.read(cArray, 0, 1) != -1) {
            outputStreamWriter.write(cArray, 0, 1);
        }
        inputStreamReader.close();
        outputStreamWriter.close();
        return true;
    }

    public String getRepeat(String string, int n, int n2) throws Exception {
        String string2 = "";
        char[] cArray = new char[256];
        InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(string));
        int n3 = 0;
        while (inputStreamReader.read(cArray, 0, 1) != -1) {
            if (n3 >= n && n3 <= n2) {
                string2 = string2 + cArray[0];
            }
            ++n3;
        }
        inputStreamReader.close();
        return string2;
    }

    private String getRepeatString(MapperBase.TagItem tagItem, Vector vector) {
        String string = "";
        String string2 = "";
        string2 = tagItem.tagString.substring(tagItem.tagString.indexOf(">") + 1, tagItem.tagString.lastIndexOf("<"));
        Vector vector2 = new Vector();
        this.mapDataParser(string2, vector2);
        for (int i = 0; i < vector.size(); ++i) {
            MapperBase.DataItem dataItem = (MapperBase.DataItem)vector.elementAt(i);
            if (tagItem.keyName.compareToIgnoreCase(dataItem.tagName) != 0) continue;
            int n = 0;
            for (int j = 0; j < vector2.size(); ++j) {
                MapperBase.TagItem tagItem2 = (MapperBase.TagItem)vector2.elementAt(j);
                string = string + string2.substring(n, tagItem2.sPos);
                for (int k = 0; k < dataItem.mapData_lst.size(); ++k) {
                    MapperBase.MapData mapData = (MapperBase.MapData)dataItem.mapData_lst.elementAt(k);
                    if (mapData.name.compareToIgnoreCase(tagItem2.keyName) != 0) continue;
                    string = string + mapData.data;
                }
                n = tagItem2.ePos + 1;
            }
            string = string + string2.substring(n);
        }
        return string;
    }

    private void mapDataParser(String string, Vector vector) {
        Vector vector2 = new Vector();
        this.htmlStringParser(string, vector2);
        for (int i = 0; i < vector2.size(); ++i) {
            String string2;
            String string3;
            MapperBase.TagItem tagItem = (MapperBase.TagItem)vector2.elementAt(i);
            String string4 = tagItem.tagString.toUpperCase();
            if (string4.indexOf(string3 = "{" + MAPDATA.toUpperCase()) == -1 || (string2 = this.getAttrValue(tagItem.tagString, NAME)) == "") continue;
            MapperBase.TagItem tagItem2 = new MapperBase.TagItem();
            tagItem2.tagName = MAPDATA;
            tagItem2.keyName = string2;
            tagItem2.tagString = tagItem.tagString;
            tagItem2.sPos = tagItem.sPos;
            tagItem2.ePos = tagItem.ePos;
            vector.add(tagItem2);
        }
    }

    public boolean htmlStringParser(String string, Vector vector) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            if (!bl) {
                if (string.charAt(i) == '{') {
                    bl = true;
                    n2 = n;
                    string2 = string2 + string.charAt(i);
                }
            } else {
                string2 = string2 + string.charAt(i);
                if (string.charAt(i) == '}') {
                    bl = false;
                    n3 = n;
                    MapperBase.TagItem tagItem = new MapperBase.TagItem();
                    tagItem.tagString = string2;
                    tagItem.sPos = n2;
                    tagItem.ePos = n3;
                    vector.add(tagItem);
                    string2 = "";
                    n2 = 0;
                    n3 = 0;
                }
            }
            ++n;
        }
        return true;
    }

    private void inRepeatFileParser(String string, Vector vector) throws Exception {
        String string2 = "<MAPREPEAT";
        String string3 = "</MAPREPEAT";
        Vector vector2 = new Vector();
        this.htmlParser(string, vector2);
        for (int i = 0; i < vector2.size(); ++i) {
            int n = 0;
            MapperBase.TagItem tagItem = (MapperBase.TagItem)vector2.elementAt(i);
            String string4 = tagItem.tagString.toUpperCase();
            if (string4.indexOf(string2) == -1) continue;
            String string5 = this.getAttrValue(tagItem.tagString, NAME);
            n = tagItem.ePos;
            for (int j = i; j < vector2.size(); ++j) {
                MapperBase.TagItem tagItem2 = (MapperBase.TagItem)vector2.elementAt(j);
                String string6 = tagItem2.tagString.toUpperCase();
                if (string6.indexOf(string3) == -1) continue;
                n = tagItem2.ePos;
                break;
            }
            MapperBase.TagItem tagItem3 = new MapperBase.TagItem();
            tagItem3.tagName = "MAPREPEAT";
            tagItem3.keyName = string5;
            tagItem3.sPos = tagItem.sPos;
            tagItem3.ePos = n;
            tagItem3.tagString = this.getRepeat(string, tagItem3.sPos, tagItem3.ePos);
            vector.add(tagItem3);
        }
    }

    public boolean checkFile(String string) {
        boolean bl = true;
        if (!this.isFile(string)) {
            String string2 = "no such source file: \"" + string + "\"";
            this.setErrorString(string2);
            bl = false;
        }
        return bl;
    }

    private void setErrorString(String string) {
        pr_errorString = string;
    }

    public String getErrorString() {
        return pr_errorString;
    }
}

