/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.mapper;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Vector;
import jp.co.nri.rid.error.RidException;
import jp.co.nri.rid.error.RidMessage;
import jp.co.nri.rid.mapper.MapperBase;
import jp.co.nri.rid.mapper.MapperResource;
import jp.co.nri.rid.mapper.XmlUtil;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MapperType2
extends MapperBase {
    private static String pr_errorString;
    private static final String ROOT_ELEMENT = "RidProject";
    private static final String MAP_ATTR = "MapAttr";
    private static final String MAP_ATTR_DATA = "MapAttrData";
    private static final String RID_TMP = "Rid_Tmp";
    private static final String MAPDATA = "MapData";
    private static final String SRC_TAG = "srcTag";
    private static final String SRC_KEY = "srcKey";
    private static final String DATA_TAG = "dataTag";
    private static final String DATA_KEY = "dataKey";
    private static final String IN_TAG = "inTag";
    private static final String OUT_ATTR = "outAttr";
    private static final String NAME = "name";

    public MapperType2() {
        pr_errorString = "";
    }

    public boolean Type2(String string, Document document, String string2) throws RidException {
        boolean bl = false;
        Vector vector = new Vector();
        RidMessage ridMessage = new RidMessage();
        try {
            if (this.checkFile(string) && (bl = this.type2DataDocParser(document, vector))) {
                bl = this.type2Generate(string, vector, string2);
            }
            if (bl) {
                MapperResource mapperResource = new MapperResource();
                mapperResource.imageFileCopy(string, string2);
            }
        }
        catch (Exception exception) {
            String string3 = ridMessage.Error("E4002", " (Mapper) " + exception.getMessage());
            if (string3.indexOf("Filename too long") != -1) {
                string3 = ridMessage.Error("E4003", " (Mapper) " + exception.getMessage());
            }
            throw new RidException(string3);
        }
        return bl;
    }

    public boolean TypeScript(String string, Document document, String string2) throws RidException {
        boolean bl = false;
        Vector vector = new Vector();
        RidMessage ridMessage = new RidMessage();
        try {
            if (this.checkFile(string) && (bl = this.type2DataDocParser(document, vector))) {
                bl = this.type2Generate(string, vector, string2);
            }
        }
        catch (Exception exception) {
            String string3 = ridMessage.Error("E4002", " (Mapper) " + exception.getMessage());
            if (string3.indexOf("Filename too long") != -1) {
                string3 = ridMessage.Error("E4003", " (Mapper) " + exception.getMessage());
            }
            throw new RidException(string3);
        }
        return bl;
    }

    public boolean type2DataDocParser(Document document, Vector vector) throws Exception {
        Object object;
        XmlUtil xmlUtil = new XmlUtil();
        boolean bl = false;
        Element element = document.getDocumentElement();
        if (!this.checkRootElement(element, ROOT_ELEMENT)) {
            object = "Root element name is different.";
            this.setErrorString((String)object);
            element = null;
        }
        if (element != null) {
            object = XPathAPI.selectNodeList((Node)element, (String)"*");
            for (int i = 0; i < object.getLength(); ++i) {
                Element element2 = (Element)object.item(i);
                MapperBase.DataItem dataItem = new MapperBase.DataItem();
                dataItem.tagName = RID_TMP;
                dataItem.keyName = element2.getNodeName();
                dataItem.inData = xmlUtil.getTextValue(element2);
                dataItem.outAttr = "";
                vector.add(dataItem);
            }
            bl = true;
        }
        return bl;
    }

    public boolean type2Generate(String string, Vector vector, String string2) throws Exception {
        boolean bl = false;
        char[] cArray = new char[256];
        Vector vector2 = new Vector();
        this.templateFileParser(string, vector2);
        InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(string));
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(string2));
        int n = 0;
        block0: for (int i = 0; i < vector2.size(); ++i) {
            MapperBase.TagItem tagItem = (MapperBase.TagItem)vector2.elementAt(i);
            while (inputStreamReader.read(cArray, 0, 1) != -1) {
                if (n >= tagItem.sPos) {
                    ++n;
                    break;
                }
                outputStreamWriter.write(cArray, 0, 1);
                ++n;
            }
            for (int j = 0; j < vector.size(); ++j) {
                MapperBase.DataItem dataItem = (MapperBase.DataItem)vector.elementAt(j);
                if (tagItem.keyName.compareToIgnoreCase(dataItem.keyName) != 0) continue;
                outputStreamWriter.write(dataItem.inData, 0, dataItem.inData.length());
            }
            while (inputStreamReader.read(cArray, 0, 1) != -1) {
                if (n >= tagItem.ePos) {
                    ++n;
                    continue block0;
                }
                ++n;
            }
        }
        while (inputStreamReader.read(cArray, 0, 1) != -1) {
            outputStreamWriter.write(cArray, 0, 1);
        }
        inputStreamReader.close();
        outputStreamWriter.close();
        return true;
    }

    private void templateFileParser(String string, Vector vector) throws Exception {
        Vector vector2 = new Vector();
        this.htmlParser(string, vector2);
        for (int i = 0; i < vector2.size(); ++i) {
            String string2;
            String string3;
            MapperBase.TagItem tagItem = (MapperBase.TagItem)vector2.elementAt(i);
            String string4 = tagItem.tagString.toUpperCase();
            if (string4.indexOf(string3 = "<" + RID_TMP.toUpperCase()) == -1 || (string2 = this.getAttrValue(tagItem.tagString, NAME)) == "") continue;
            MapperBase.TagItem tagItem2 = new MapperBase.TagItem();
            tagItem2.tagName = RID_TMP;
            tagItem2.keyName = string2;
            tagItem2.tagString = tagItem.tagString;
            tagItem2.sPos = tagItem.sPos;
            tagItem2.ePos = tagItem.ePos;
            vector.add(tagItem2);
        }
    }

    public boolean checkFile(String string) {
        boolean bl = true;
        if (!this.isFile(string)) {
            String string2 = "no such source file: \"" + string + "\"";
            this.setErrorString(string2);
            bl = false;
        }
        return bl;
    }

    private void setErrorString(String string) {
        pr_errorString = string;
    }

    public String getErrorString() {
        return pr_errorString;
    }
}

