/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.mapper;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.nri.rid.error.RidException;
import jp.co.nri.rid.error.RidMessage;
import jp.co.nri.rid.mapper.MapperBase;
import jp.co.nri.rid.mapper.MapperResource;
import jp.co.nri.rid.mapper.XmlUtil;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapperType1
extends MapperBase {
    private static String pr_errorString;
    private static final String ROOT_ELEMENT = "RidProject";
    private static final String MAP_ATTR = "MapAttr";
    private static final String MAP_ATTR_DATA = "MapAttrData";
    private static final String RID_TMP = "Rid_Tmp";
    private static final String MAPDATA = "MapData";
    private static final String SRC_TAG = "srcTag";
    private static final String SRC_KEY = "srcKey";
    private static final String DATA_TAG = "dataTag";
    private static final String DATA_KEY = "dataKey";
    private static final String IN_TAG = "inTag";
    private static final String OUT_ATTR = "outAttr";
    private static final String NAME = "name";

    public MapperType1() {
        pr_errorString = "";
    }

    public boolean Type1(String string, String string2, Document document, String string3) throws RidException {
        boolean bl = false;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        RidMessage ridMessage = new RidMessage();
        try {
            if (this.checkFile(string) && this.checkFile(string2) && (bl = this.type1MapFileParser(string2, vector)) && (bl = this.type1DataDocParser(document, vector, vector2))) {
                this.type1Generate(string, vector, vector2, string3);
                bl = true;
            }
            if (bl) {
                MapperResource mapperResource = new MapperResource();
                mapperResource.imageFileCopy(string, string3);
            }
        }
        catch (Exception exception) {
            String string4 = ridMessage.Error("E4002", " (Mapper) " + exception.getMessage());
            if (string4.indexOf("Filename too long") != -1) {
                string4 = ridMessage.Error("E4003", " (Mapper) " + exception.getMessage());
            }
            throw new RidException(string4);
        }
        return bl;
    }

    private boolean type1MapFileParser(String string, Vector vector) throws Exception {
        boolean bl = false;
        Element element = DocManager.createMapElement(string);
        if (element != null) {
            bl = this.getMapAttr(element, vector);
        } else {
            String string2 = "Root element name is different.";
            this.setErrorString(string2);
        }
        return bl;
    }

    private boolean getMapAttr(Element element, Vector vector) throws Exception {
        boolean bl = false;
        NodeList nodeList = XPathAPI.selectNodeList((Node)element, (String)MAP_ATTR);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute(SRC_TAG);
            String string2 = element2.getAttribute(SRC_KEY);
            String string3 = element2.getAttribute(DATA_TAG);
            String string4 = element2.getAttribute(DATA_KEY);
            NodeList nodeList2 = XPathAPI.selectNodeList((Node)element2, (String)MAP_ATTR_DATA);
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element3 = (Element)nodeList2.item(j);
                MapperBase.MapItem mapItem = new MapperBase.MapItem();
                mapItem.srcTag = string;
                mapItem.srcKey = string2;
                mapItem.dataTag = string3;
                mapItem.dataKey = string4;
                mapItem.inTag = element3.getAttribute(IN_TAG);
                mapItem.outAttr = element3.getAttribute(OUT_ATTR);
                if (!this.checkMapFile(mapItem) || -1 != vector.indexOf(mapItem)) continue;
                vector.add(mapItem);
            }
        }
        return true;
    }

    private boolean checkMapFile(MapperBase.MapItem mapItem) {
        boolean bl = false;
        if (mapItem.srcTag != "" && mapItem.srcKey != "" && mapItem.dataTag != "" && mapItem.dataKey != "" && mapItem.inTag != "" && mapItem.outAttr != "") {
            bl = true;
        }
        return bl;
    }

    private boolean type1DataDocParser(Document document, Vector vector, Vector vector2) throws Exception {
        boolean bl = false;
        Element element = document.getDocumentElement();
        if (!this.checkRootElement(element, ROOT_ELEMENT)) {
            String string = "Root element name is different.";
            this.setErrorString(string);
            element = null;
        }
        if (element != null) {
            bl = this.getDataTag(element, vector, vector2);
        }
        return bl;
    }

    private boolean getDataTag(Element element, Vector vector, Vector vector2) throws Exception {
        XmlUtil xmlUtil = new XmlUtil();
        for (int i = 0; i < vector.size(); ++i) {
            MapperBase.MapItem mapItem = (MapperBase.MapItem)vector.elementAt(i);
            NodeList nodeList = XPathAPI.selectNodeList((Node)element, (String)mapItem.dataTag);
            for (int j = 0; j < nodeList.getLength(); ++j) {
                Element element2 = (Element)nodeList.item(j);
                String string = element2.getAttribute(mapItem.dataKey);
                Element element3 = (Element)XPathAPI.selectSingleNode((Node)element2, (String)mapItem.inTag);
                if (element3 == null) continue;
                String string2 = xmlUtil.getTextValue(element3);
                MapperBase.DataItem dataItem = new MapperBase.DataItem();
                dataItem.tagName = mapItem.srcTag;
                dataItem.keyName = string;
                dataItem.inData = string2;
                dataItem.outAttr = mapItem.outAttr;
                vector2.add(dataItem);
            }
        }
        return true;
    }

    private boolean type1Generate(String string, Vector vector, Vector vector2, String string2) throws Exception {
        boolean bl = false;
        char[] cArray = new char[256];
        Vector vector3 = new Vector();
        this.inFileParser(string, vector, vector3);
        InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(string));
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(string2));
        int n = 0;
        block0: for (int i = 0; i < vector3.size(); ++i) {
            MapperBase.TagItem tagItem = (MapperBase.TagItem)vector3.elementAt(i);
            while (inputStreamReader.read(cArray, 0, 1) != -1) {
                if (n >= tagItem.sPos) {
                    ++n;
                    break;
                }
                outputStreamWriter.write(cArray, 0, 1);
                ++n;
            }
            boolean bl2 = false;
            for (int j = 0; j < vector2.size(); ++j) {
                MapperBase.DataItem dataItem = (MapperBase.DataItem)vector2.elementAt(j);
                if (dataItem.tagName.compareToIgnoreCase(tagItem.tagName) != 0 || dataItem.keyName.compareToIgnoreCase(tagItem.keyName) != 0) continue;
                int n2 = tagItem.tagString.length() - 1;
                String string3 = tagItem.tagString.substring(0, n2) + " " + dataItem.outAttr + "=\"" + dataItem.inData + "\">";
                outputStreamWriter.write(string3, 0, string3.length());
                bl2 = true;
                break;
            }
            if (!bl2) {
                outputStreamWriter.write(tagItem.tagString, 0, tagItem.tagString.length());
            }
            while (inputStreamReader.read(cArray, 0, 1) != -1) {
                if (n >= tagItem.ePos) {
                    ++n;
                    continue block0;
                }
                ++n;
            }
        }
        while (inputStreamReader.read(cArray, 0, 1) != -1) {
            outputStreamWriter.write(cArray, 0, 1);
        }
        inputStreamReader.close();
        outputStreamWriter.close();
        return true;
    }

    private void inFileParser(String string, Vector vector, Vector vector2) throws Exception {
        Vector vector3 = new Vector();
        this.htmlParser(string, vector3);
        for (int i = 0; i < vector3.size(); ++i) {
            MapperBase.TagItem tagItem = (MapperBase.TagItem)vector3.elementAt(i);
            for (int j = 0; j < vector.size(); ++j) {
                String string2;
                String string3;
                MapperBase.MapItem mapItem = (MapperBase.MapItem)vector.elementAt(j);
                String string4 = tagItem.tagString.toUpperCase();
                if (string4.indexOf(string3 = "<" + mapItem.srcTag.toUpperCase()) == -1 || (string2 = this.getAttrValue(tagItem.tagString, mapItem.srcKey)) == "") continue;
                MapperBase.TagItem tagItem2 = new MapperBase.TagItem();
                tagItem2.tagName = mapItem.srcTag;
                tagItem2.keyName = string2;
                tagItem2.tagString = tagItem.tagString;
                tagItem2.sPos = tagItem.sPos;
                tagItem2.ePos = tagItem.ePos;
                vector2.add(tagItem2);
            }
        }
    }

    public boolean Type1Xml(Element element, String string, Element element2) throws RidException {
        boolean bl = false;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        try {
            if (this.checkFile(string) && (bl = this.type1MapFileParser(string, vector)) && element2 != null && (bl = this.getDataTag(element2, vector, vector2))) {
                bl = this.type1XmlGenerate(element, vector, vector2);
            }
        }
        catch (Exception exception) {
            throw new RidException(exception.getMessage());
        }
        return bl;
    }

    private boolean type1XmlGenerate(Element element, Vector vector, Vector vector2) throws Exception {
        boolean bl = false;
        XmlUtil xmlUtil = new XmlUtil();
        String string = "";
        for (int i = 0; i < vector.size(); ++i) {
            MapperBase.MapItem mapItem = (MapperBase.MapItem)vector.elementAt(i);
            for (int j = 0; j < vector2.size(); ++j) {
                Element element2;
                MapperBase.DataItem dataItem = (MapperBase.DataItem)vector2.elementAt(j);
                if (mapItem.outAttr.compareTo(dataItem.outAttr) != 0 || (element2 = (Element)XPathAPI.selectSingleNode((Node)element, (String)(string = "//" + mapItem.srcTag + "[@" + mapItem.srcKey + " = '" + dataItem.keyName + "']"))) == null) continue;
                element2.setAttribute(mapItem.outAttr, dataItem.inData);
            }
            bl = true;
        }
        return bl;
    }

    public String getDateString() throws Exception {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd (EE) HH:mm:ss.SSS zz");
        return simpleDateFormat.format(date);
    }

    public boolean checkFile(String string) {
        boolean bl = true;
        if (!this.isFile(string)) {
            String string2 = "no such source file: \"" + string + "\"";
            this.setErrorString(string2);
            bl = false;
        }
        return bl;
    }

    private void setErrorString(String string) {
        pr_errorString = string;
    }

    public String getErrorString() {
        return pr_errorString;
    }
}

