/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.importer;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;
import jp.co.nri.rid.analyzer.RWarningException;
import jp.co.nri.rid.analyzer.iExceptionCode;
import jp.co.nri.rid.error.RidException;
import jp.co.nri.rid.error.RidMessage;
import jp.co.nri.rid.importer.RIgnoreFiles;
import jp.co.nri.rid.table.editor.filter.DirFilter;
import jp.co.nri.rid.table.editor.filter.ExtensionFilter;
import jp.co.nri.rid.xml.Attributes;
import jp.co.nri.rid.xml.elementBooster;

public abstract class RImporter
implements iExceptionCode {
    protected static final String WILD = "*";
    protected static final String SEPARATOR = "/";
    protected static final String NAMESEPARATOR = ".";
    protected static final String ZONEUNIT = "ZoneUnit";
    protected static final String KEY = "Key";
    protected static final String NAME = "Name";
    protected static final String EXIST = "Exist";
    protected static final String SIZE = "Size";
    protected static final String DATE = "Date";
    protected static final String WIDTH = "Width";
    protected static final String HEIGHT = "Height";
    protected static final String UNIT = ".unit";
    protected static final String ATTRIBUTES = ".attributes";
    protected static final String EXTENSIONS = ".extensions";
    protected static final String HIT = ".hit";
    protected static final String WITHOUT = "without";
    protected static final String TRUE = "true";
    protected static final String FALSE = "false";
    protected static final String CREATOR = "Creator";
    protected static final String IMPORTER = "importer";
    protected static final String KEY_DIR = "import.dir";
    protected static final String KEY_COMMENT = "import.comment";
    protected static final String COMMENT = "Comment";
    protected static final String PAGETYPE = "PageType";
    protected static final String STATIC = "static";
    protected static final String DYNAMIC = "dynamic";
    protected static final String SERVER = "server";
    protected elementBooster myElement = this.topelement();
    protected String myUnitName;
    protected FilenameFilter myFilter;
    protected FilenameFilter myDirFilter;
    protected String[] myAttributes;
    protected RWarningException myWarnings;

    protected abstract elementBooster topelement();

    protected abstract String getExtensionKey();

    protected abstract elementBooster extensionNewUnit(elementBooster var1) throws RidException;

    protected abstract String getPageType();

    public RImporter(String string) throws RidException {
        ZProperties zProperties = DocManager.loadProperty("element");
        this.myUnitName = zProperties.getProperty(string + UNIT);
        if (null == this.myUnitName) {
            throw new RidException(new RidMessage().Error("E3010", string + UNIT));
        }
        this.myAttributes = ZString.tokenize(zProperties.getProperty(string + ATTRIBUTES));
        if (null == this.myAttributes) {
            throw new RidException(new RidMessage().Error("E3010", string + ATTRIBUTES));
        }
        this.myFilter = this.getExtensionFilter(zProperties);
        this.myDirFilter = new DirFilter();
    }

    private ExtensionFilter getExtensionFilter(ZProperties zProperties) throws RidException {
        String string = this.getExtensionKey();
        String string2 = zProperties.getProperty(string);
        if (null == string2) {
            throw new RidException(new RidMessage().Error("E3010", string));
        }
        ExtensionFilter extensionFilter = WILD.equals(string2) ? new ExtensionFilter() : new ExtensionFilter(ZString.tokenize(string2));
        String string3 = zProperties.getProperty(string + HIT);
        if (WITHOUT.equals(string3)) {
            extensionFilter.hit = false;
        }
        return extensionFilter;
    }

    public void Import(String string) throws RidException {
        ZDebug.trace(string);
        this.myWarnings = new RWarningException();
        Zone zone = new Zone(string);
        elementBooster elementBooster2 = zone.buildZone(this.myElement);
        if (null == elementBooster2) {
            return;
        }
        this.resetExist(ZONEUNIT, elementBooster2);
        this.resetExist(this.myUnitName, elementBooster2);
        this.Import(zone.ImportDir, elementBooster2);
        if (0 < this.myWarnings.length()) {
            throw new RidException(this.myWarnings.getMessage());
        }
    }

    protected void Import(File file, elementBooster elementBooster2) throws RidException {
        int n;
        elementBooster2.attribute(EXIST, TRUE);
        File[] fileArray = file.listFiles(this.myFilter);
        int n2 = fileArray.length;
        for (n = 0; n < n2; ++n) {
            this.add(fileArray[n], elementBooster2);
        }
        fileArray = file.listFiles(this.myDirFilter);
        n2 = fileArray.length;
        for (n = 0; n < n2; ++n) {
            String string = fileArray[n].getName();
            if (RIgnoreFiles.ignorename(string)) continue;
            this.Import(fileArray[n], this.child(ZONEUNIT, string, elementBooster2));
        }
    }

    protected elementBooster child(String string, String string2, elementBooster elementBooster2) throws RidException {
        elementBooster[] elementBoosterArray = elementBooster2.children(string);
        if (null == elementBoosterArray) {
            return this.newchild(string, string2, elementBooster2);
        }
        int n = elementBoosterArray.length;
        for (int i = 0; i < n; ++i) {
            if (!string2.equalsIgnoreCase(elementBoosterArray[i].attribute(NAME))) continue;
            return elementBoosterArray[i];
        }
        return this.newchild(string, string2, elementBooster2);
    }

    protected elementBooster newchild(String string, String string2, elementBooster elementBooster2) throws RidException {
        Attributes attributes = new Attributes();
        attributes.add(NAME, string2);
        attributes.add(CREATOR, IMPORTER);
        attributes.add(COMMENT, ZApp.getTheApp().getResource().getString(KEY_COMMENT));
        return this.extensionNewUnit(elementBooster2.add(string, attributes));
    }

    protected void add(File file, elementBooster elementBooster2) throws RidException {
        String string = file.getName();
        if (RIgnoreFiles.ignorename(string)) {
            return;
        }
        elementBooster elementBooster3 = this.child(this.myUnitName, string, elementBooster2);
        elementBooster3.attribute(EXIST, TRUE);
        int n = this.myAttributes.length;
        for (int i = 0; i < n; ++i) {
            String string2 = this.myAttributes[i];
            try {
                if (SIZE.equals(string2)) {
                    elementBooster3.attribute(SIZE, String.valueOf(file.length()));
                    continue;
                }
                if (DATE.equals(string2)) {
                    elementBooster3.attribute(DATE, DateFormat.getDateTimeInstance().format(new Date(file.lastModified())));
                    continue;
                }
                if (WIDTH.equals(string2)) {
                    elementBooster3.attribute(WIDTH, this.width(file));
                    continue;
                }
                if (!HEIGHT.equals(string2)) continue;
                elementBooster3.attribute(HEIGHT, this.height(file));
                continue;
            }
            catch (RWarningException rWarningException) {
                this.myWarnings.add(rWarningException);
            }
        }
    }

    protected String width(File file) throws RWarningException {
        ImageIcon imageIcon;
        try {
            imageIcon = new ImageIcon(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            throw new RWarningException("W3020", file.getPath());
        }
        int n = imageIcon.getIconWidth();
        if (0 < n) {
            return String.valueOf(n);
        }
        return null;
    }

    protected String height(File file) throws RWarningException {
        ImageIcon imageIcon;
        try {
            imageIcon = new ImageIcon(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            throw new RWarningException("W3020", file.getPath());
        }
        int n = imageIcon.getIconHeight();
        if (0 < n) {
            return String.valueOf(n);
        }
        return null;
    }

    protected void resetExist(String string, elementBooster elementBooster2) throws RidException {
        elementBooster[] elementBoosterArray = elementBooster2.offspring(string);
        if (null == elementBoosterArray) {
            return;
        }
        String string2 = this.getPageType();
        int n = elementBoosterArray.length;
        for (int i = 0; i < n; ++i) {
            elementBooster elementBooster3 = elementBoosterArray[i];
            if (RIgnoreFiles.ignorefile(elementBooster3.attribute(KEY))) continue;
            String string3 = elementBooster3.attribute(PAGETYPE);
            if (null != string2 && !string2.equals(string3)) continue;
            elementBooster3.attribute(EXIST, FALSE);
        }
    }

    private class Zone {
        private File myBaseDir;
        public File ImportDir;

        public Zone(String string) {
            this.myBaseDir = new File(string);
            String string2 = ZApp.getTheApp().getResource().getString(RImporter.KEY_DIR);
            try {
                this.ImportDir = 0 < string2.length() ? new File(string2) : new File(string);
            }
            catch (NullPointerException nullPointerException) {
                this.ImportDir = new File(string);
            }
        }

        public elementBooster buildZone(elementBooster elementBooster2) throws RidException {
            return this.buildZone(elementBooster2, this.zonename(this.ImportDir));
        }

        private elementBooster buildZone(elementBooster elementBooster2, String string) throws RidException {
            if (null == string) {
                return null;
            }
            elementBooster elementBooster3 = elementBooster2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, RImporter.SEPARATOR);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                elementBooster elementBooster4 = this.child(elementBooster3, string2);
                if (null == elementBooster4) {
                    elementBooster4 = RImporter.this.newchild(RImporter.ZONEUNIT, string2, elementBooster3);
                }
                elementBooster3 = elementBooster4;
            }
            return elementBooster3;
        }

        private String zonename(File file) {
            try {
                if (!file.isDirectory()) {
                    return null;
                }
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
            if (this.myBaseDir.equals(file)) {
                return "";
            }
            String string = this.zonename(file.getParentFile());
            if (null == string) {
                return null;
            }
            return string + RImporter.SEPARATOR + file.getName();
        }

        private elementBooster child(elementBooster elementBooster2, String string) {
            elementBooster[] elementBoosterArray = elementBooster2.children(RImporter.ZONEUNIT);
            if (null == elementBoosterArray) {
                return null;
            }
            int n = elementBoosterArray.length;
            for (int i = 0; i < n; ++i) {
                if (!string.equalsIgnoreCase(elementBoosterArray[i].attribute(RImporter.NAME))) continue;
                return elementBoosterArray[i];
            }
            return null;
        }
    }
}

