/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.generator;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;
import jp.co.nri.rid.error.RidMessage;
import jp.co.nri.rid.generator.GeneratePage;
import jp.co.nri.rid.generator.GenerateParser;
import jp.co.nri.rid.generator.GenerateSiteMap;
import org.w3c.dom.Document;

public class RHTMLGenerator
extends GenerateParser {
    public static final String GENERATE_PAGE = "generate.page";
    public static final String GENERATE_SITEMAP = "generate.sitemap";
    public static final String GENERATE_BROWSER = "generate.browser";
    public static final String GENERATE_BROWSER_COMMAND = "generate.browser_command";

    public boolean generate(DocDocument docDocument, String string) throws Exception {
        boolean bl;
        boolean bl2 = true;
        ZResource zResource = ZApp.getTheApp().getResource();
        boolean bl3 = zResource.getBoolean(GENERATE_PAGE);
        if (bl3) {
            bl2 = this.generatePageFrame(docDocument, string);
        }
        if (bl = zResource.getBoolean(GENERATE_SITEMAP)) {
            bl2 &= this.generateSiteMap(docDocument, string);
        }
        if (bl2) {
            this.browserExec(string + File.separator + zResource.getString("rid.admin.dir") + File.separator + "index.html");
        }
        return bl2;
    }

    public boolean generatePageFrame(DocDocument docDocument, String string) throws Exception {
        boolean bl = false;
        ZDebug.trace(" >> Page start... ");
        GeneratePage generatePage = new GeneratePage();
        bl = generatePage.generate((Document)((Object)docDocument), string);
        ZDebug.trace(" >> Page end... \"" + bl + "\"");
        return bl;
    }

    public boolean generateSiteMap(DocDocument docDocument, String string) throws Exception {
        boolean bl = false;
        ZDebug.trace(" >> SiteMap start... ");
        String string2 = "_header.html";
        String string3 = "_footer.html";
        GenerateSiteMap generateSiteMap = new GenerateSiteMap();
        bl = generateSiteMap.generate((Document)((Object)docDocument), string, string2, string3);
        ZDebug.trace(" >> SiteMap end... \"" + bl + "\"");
        return bl;
    }

    public boolean browserExec(String string) throws Exception {
        String string2;
        boolean bl = true;
        ZResource zResource = ZApp.getTheApp().getResource();
        boolean bl2 = zResource.getBoolean(GENERATE_BROWSER);
        if (bl2 && !this.isNullString(string2 = zResource.getString(GENERATE_BROWSER_COMMAND))) {
            if (!new File(string2).exists()) {
                ZDebug.trace(new RidMessage().Warning("W4005", string2));
                return false;
            }
            File file = new File(string);
            if (!file.exists()) {
                ZDebug.trace(new RidMessage().Warning("W4006", string2));
                return false;
            }
            Runtime.getRuntime().exec(string2 + " " + file.toURL());
        }
        return bl;
    }

    public String getDateString() throws Exception {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd (EE) HH:mm:ss.SSS zz");
        return simpleDateFormat.format(date);
    }
}

