/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZString;
import jp.co.nri.Ridual;
import jp.co.nri.rid.error.RidException;
import jp.co.nri.rid.error.RidMessage;
import jp.co.nri.rid.generator.GenerateParser;
import jp.co.nri.rid.mapper.Mapper;
import jp.co.nri.rid.mapper.XmlUtil;
import jp.co.nri.rid.snapshot.xcopy;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GeneratePage
extends GenerateParser {
    private static final String RCSID = "$Id: GeneratePage.java,v 1.3 2003/01/24 15:19:29 nsmr Exp $";
    public static final String RID_TEMPLATE_DIR = "rid.template.dir";
    public static final String RID_PARTS_DIR = "rid.parts.dir";
    private static String pr_htmlDir;
    private static String pr_templateDir;
    private static String pr_partsDir;

    public GeneratePage() {
        pr_htmlDir = "";
        pr_templateDir = "";
        pr_partsDir = "";
    }

    public boolean generate(Document document, String string) throws RidException, Exception {
        boolean bl = false;
        RidMessage ridMessage = new RidMessage();
        ZResource zResource = ZApp.getTheApp().getResource();
        pr_htmlDir = Ridual.getHtmlDir();
        pr_templateDir = string + File.separator + zResource.getString(RID_TEMPLATE_DIR);
        pr_partsDir = string + File.separator + zResource.getString(RID_PARTS_DIR);
        GenerateParser.ProjectInfo projectInfo = new GenerateParser.ProjectInfo();
        projectInfo = this.documentParser(document, "", "");
        bl = this.pageZone(projectInfo.zone, null);
        return bl;
    }

    private boolean pageZone(GenerateParser.ZoneInfo zoneInfo, GenerateParser.ZoneInfo zoneInfo2) throws Exception {
        boolean bl = true;
        xcopy xcopy2 = new xcopy();
        if (!zoneInfo.top) {
            String string = this.web2SeparatorChar(pr_htmlDir + File.separator + zoneInfo.file);
            bl = xcopy2.makeDir(string);
            if (xcopy2.fileExists(string)) {
                zoneInfo.element.attribute("Exist", "true");
            }
        }
        if (bl) {
            Object object;
            if (zoneInfo.page_lst.size() > 0) {
                for (int i = 0; i < zoneInfo.page_lst.size(); ++i) {
                    object = (GenerateParser.PageInfo)zoneInfo.page_lst.elementAt(i);
                    bl = this.generatePage(zoneInfo, (GenerateParser.PageInfo)object);
                }
            }
            for (int i = 0; i < zoneInfo.zone_lst.size(); ++i) {
                object = (GenerateParser.ZoneInfo)zoneInfo.zone_lst.elementAt(i);
                bl = this.pageZone((GenerateParser.ZoneInfo)object, zoneInfo);
            }
        }
        return bl;
    }

    private boolean generatePage(GenerateParser.ZoneInfo zoneInfo, GenerateParser.PageInfo pageInfo) throws RidException, Exception {
        String string;
        boolean bl = true;
        xcopy xcopy2 = new xcopy();
        RidMessage ridMessage = new RidMessage();
        String string2 = this.web2SeparatorChar(pr_htmlDir + File.separator + pageInfo.file);
        if (!xcopy2.fileExists(string2) && xcopy2.fileExists(string = string2.substring(0, string2.lastIndexOf(File.separatorChar)))) {
            Document document;
            Mapper mapper = new Mapper();
            String string3 = this.getPageTemplate(zoneInfo);
            bl = mapper.Type2(string3, document = this.generatePageData(pageInfo), string2);
            if (!bl) {
                ZDebug.trace(ridMessage.Warning("W4001", string2));
            }
            if (string3.indexOf("_page.html") == -1) {
                File file = new File(string3);
                file.delete();
            }
            if (xcopy2.fileExists(string2)) {
                pageInfo.element.attribute("Exist", "true");
            }
        }
        return bl;
    }

    public String web2SeparatorChar(String string) {
        return string.replace('/', File.separatorChar);
    }

    private Document generatePageData(GenerateParser.PageInfo pageInfo) throws RidException, Exception {
        String[] stringArray;
        XmlUtil xmlUtil = new XmlUtil();
        DocumentImpl documentImpl = new DocumentImpl();
        Element element = documentImpl.createElement("RidProject");
        documentImpl.appendChild(element);
        for (int i = 0; i < pageInfo.attr_lst.size(); ++i) {
            stringArray = (String[])pageInfo.attr_lst.elementAt(i);
            xmlUtil.createOrSetTextValue(element, stringArray.name, stringArray.value);
        }
        ZProperties zProperties = DocManager.loadProperty("element");
        stringArray = ZString.tokenize(zProperties.getProperty("RidProgress.attributes"));
        String string = "<rid_progress";
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = "";
            for (int j = 0; j < pageInfo.attr_lst.size(); ++j) {
                GenerateParser.Attribute attribute = (GenerateParser.Attribute)pageInfo.attr_lst.elementAt(j);
                if (string2.compareTo(attribute.name) != 0) continue;
                string3 = attribute.value;
                break;
            }
            string = string + " " + string2.toLowerCase() + "=\"" + string3 + "\"";
        }
        string = string + ">";
        xmlUtil.createOrSetTextValue(element, "RidProgress", string);
        return documentImpl;
    }

    private String getPageTemplate(GenerateParser.ZoneInfo zoneInfo) throws RidException, Exception {
        String string;
        xcopy xcopy2 = new xcopy();
        RidMessage ridMessage = new RidMessage();
        if (this.isNullString(zoneInfo.template1) && this.isNullString(zoneInfo.template2)) {
            string = pr_templateDir + File.separator + "_page.html";
        } else {
            String string2;
            String string3;
            File file = File.createTempFile("_ridTmp", null, new File(pr_partsDir));
            string = file.getAbsolutePath();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            if (!this.isNullString(zoneInfo.template1)) {
                string3 = pr_partsDir + File.separator + zoneInfo.template1;
                if (xcopy2.fileExists(string3)) {
                    string2 = this.file2String(string3);
                    outputStreamWriter.write(string2, 0, string2.length());
                } else {
                    ZDebug.trace(ridMessage.Warning("W4002", string3));
                }
            }
            if (!this.isNullString(zoneInfo.template2)) {
                string3 = pr_partsDir + File.separator + zoneInfo.template2;
                if (xcopy2.fileExists(string3)) {
                    string2 = this.file2String(string3);
                    outputStreamWriter.write(string2, 0, string2.length());
                } else {
                    ZDebug.trace(ridMessage.Warning("W4002", string3));
                }
            }
            outputStreamWriter.close();
        }
        return string;
    }

    private String file2String(String string) throws RidException, IOException {
        String string2 = "";
        char[] cArray = new char[256];
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            while (inputStreamReader.read(cArray, 0, 1) != -1) {
                string2 = string2 + cArray[0];
            }
            inputStreamReader.close();
        }
        catch (IOException iOException) {
            throw new RidException(iOException.getMessage());
        }
        return string2;
    }
}

