/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.generator;

import java.io.File;
import java.util.Vector;
import jp.co.nri.rid.error.RidException;
import jp.co.nri.rid.error.RidMessage;
import jp.co.nri.rid.generator.GenerateParser;
import jp.co.nri.rid.mapper.Mapper;
import jp.co.nri.rid.mapper.XmlUtil;
import jp.co.nri.rid.snapshot.xcopy;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GenerateNavibar
extends GenerateParser {
    public static final String PRODUCT = "Product";
    public static final String PRESENT = "Present";
    private static String gn_templateDir = "";
    private static String gn_outDir = "";
    private static String gn_type = "";
    private static final String prAdminIndex = "../Admin/index.html";
    private static final String prAdminIndex1 = "../Admin/index_1.html";
    private static final String prAdminIndex2 = "../Admin/index_2.html";
    private static final String prAdminIndex3 = "../Admin/index_3.html";
    private static final String prAdminIndex4 = "../Admin/index_4.html";
    private static final String prAdminIndex5 = "../Admin/index_5.html";

    public boolean generate(String string, String string2, String string3, GenerateParser.ZoneInfo zoneInfo, GenerateParser.ZoneInfo zoneInfo2) throws Exception {
        boolean bl = false;
        gn_templateDir = string2;
        gn_outDir = string3;
        gn_type = string;
        this.generateNavi(zoneInfo, zoneInfo2);
        return true;
    }

    private NaviData createNaviData(String string, String string2) throws Exception {
        NaviData naviData = new NaviData();
        naviData.linkStart = this.replaceWebFileSeparator("<a href=\"" + string + "\" target=\"_top\">");
        naviData.name = string2;
        naviData.linkEnd = "</a>";
        return naviData;
    }

    private NaviData naviProductData(GenerateParser.ZoneInfo zoneInfo) throws Exception {
        String string = gn_type.compareTo(PRODUCT) == 0 ? zoneInfo.parent + "html_navi.html" : zoneInfo.parent + "../" + "PortalTeam" + "/" + "html_navi.html";
        return this.createNaviData(string, "");
    }

    private NaviData naviPresentData(GenerateParser.ZoneInfo zoneInfo) throws Exception {
        String string = gn_type.compareTo(PRESENT) == 0 ? zoneInfo.parent + "html_navi.html" : zoneInfo.parent + "../" + "PortalPublic" + "/" + "html_navi.html";
        return this.createNaviData(string, "");
    }

    private Vector naviPageLst(GenerateParser.ZoneInfo zoneInfo) throws Exception {
        Vector<NaviData> vector = new Vector<NaviData>();
        for (int i = 0; i < zoneInfo.page_lst.size(); ++i) {
            GenerateParser.PageInfo pageInfo = (GenerateParser.PageInfo)zoneInfo.page_lst.elementAt(i);
            NaviData naviData = this.naviPage(pageInfo);
            if (naviData == null) continue;
            vector.add(naviData);
        }
        return vector;
    }

    private NaviData naviPage(GenerateParser.PageInfo pageInfo) throws Exception {
        return this.createNaviData(pageInfo.name + "_frame.html", pageInfo.name);
    }

    private Vector naviZoneLst(GenerateParser.ZoneInfo zoneInfo) throws Exception {
        Vector<NaviData> vector = new Vector<NaviData>();
        for (int i = 0; i < zoneInfo.zone_lst.size(); ++i) {
            GenerateParser.ZoneInfo zoneInfo2 = (GenerateParser.ZoneInfo)zoneInfo.zone_lst.elementAt(i);
            NaviData naviData = this.naviZone(zoneInfo2);
            if (naviData == null) continue;
            vector.add(naviData);
        }
        return vector;
    }

    private NaviData naviZone(GenerateParser.ZoneInfo zoneInfo) throws Exception {
        String string;
        if (zoneInfo.page_lst.size() > 0) {
            GenerateParser.PageInfo pageInfo = (GenerateParser.PageInfo)zoneInfo.page_lst.elementAt(0);
            string = zoneInfo.name + "/" + pageInfo.name + "_frame.html";
        } else {
            string = zoneInfo.name + "/" + "Blank" + "_frame.html";
        }
        return this.createNaviData(string, zoneInfo.name);
    }

    private Vector naviParentLst(GenerateParser.ZoneInfo zoneInfo) throws Exception {
        NaviData naviData;
        Vector<NaviData> vector = new Vector<NaviData>();
        if (zoneInfo != null && (naviData = this.naviParent(zoneInfo)) != null) {
            vector.add(naviData);
        }
        return vector;
    }

    private NaviData naviParent(GenerateParser.ZoneInfo zoneInfo) throws Exception {
        String string;
        String string2;
        if (zoneInfo.page_lst.size() > 0) {
            GenerateParser.PageInfo pageInfo = (GenerateParser.PageInfo)zoneInfo.page_lst.elementAt(0);
            string2 = "../" + pageInfo.name + "_frame.html";
            string = zoneInfo.name + "/" + pageInfo.name + "_frame.html";
        } else {
            string2 = "../Blank_frame.html";
            string = zoneInfo.name + "/" + "Blank" + "_frame.html";
        }
        return this.createNaviData(string2, string);
    }

    private boolean generateNavi(GenerateParser.ZoneInfo zoneInfo, GenerateParser.ZoneInfo zoneInfo2) throws Exception {
        boolean bl = false;
        String string = "";
        xcopy xcopy2 = new xcopy();
        RidMessage ridMessage = new RidMessage();
        String string2 = gn_templateDir + File.separator + "_navi.html";
        if (!xcopy2.fileExists(string2)) {
            throw new RidException(ridMessage.Error("E4001", string2));
        }
        string = zoneInfo.top ? gn_outDir + File.separator + zoneInfo.name + "_navi.html" : gn_outDir + File.separator + zoneInfo.file + File.separator + zoneInfo.name + "_navi.html";
        Mapper mapper = new Mapper();
        Document document = this.generateNaviData(zoneInfo, zoneInfo2);
        bl = mapper.Type3(string2, document, string);
        if (!bl) {
            throw new RidException(ridMessage.Error("E4002", mapper.getErrorString()));
        }
        return bl;
    }

    private Document generateNaviData(GenerateParser.ZoneInfo zoneInfo, GenerateParser.ZoneInfo zoneInfo2) throws Exception {
        DocumentImpl documentImpl = new DocumentImpl();
        Element element = documentImpl.createElement("RidProject");
        documentImpl.appendChild(element);
        NaviData naviData = this.createNaviData(zoneInfo.parent + prAdminIndex, "");
        this.writeNaviData(element, "HomeData", naviData);
        NaviData naviData2 = this.createNaviData(zoneInfo.parent + prAdminIndex1, "");
        this.writeNaviData(element, "Index1", naviData2);
        NaviData naviData3 = this.createNaviData(zoneInfo.parent + prAdminIndex2, "");
        this.writeNaviData(element, "Index2", naviData3);
        NaviData naviData4 = this.createNaviData(zoneInfo.parent + prAdminIndex3, "");
        this.writeNaviData(element, "Index3", naviData4);
        NaviData naviData5 = this.createNaviData(zoneInfo.parent + prAdminIndex4, "");
        this.writeNaviData(element, "Index4", naviData5);
        NaviData naviData6 = this.createNaviData(zoneInfo.parent + prAdminIndex5, "");
        this.writeNaviData(element, "Index5", naviData6);
        NaviData naviData7 = this.naviProductData(zoneInfo);
        this.writeNaviData(element, "ProductData", naviData7);
        NaviData naviData8 = this.naviPresentData(zoneInfo);
        this.writeNaviData(element, "PresentData", naviData8);
        Vector vector = this.naviParentLst(zoneInfo2);
        for (int i = 0; i < vector.size(); ++i) {
            NaviData naviData9 = (NaviData)vector.elementAt(i);
            this.writeNaviData(element, "ParentData", naviData9);
        }
        Vector vector2 = this.naviPageLst(zoneInfo);
        for (int i = 0; i < vector2.size(); ++i) {
            NaviData naviData10 = (NaviData)vector2.elementAt(i);
            this.writeNaviData(element, "PageData", naviData10);
        }
        Vector vector3 = this.naviZoneLst(zoneInfo);
        for (int i = 0; i < vector3.size(); ++i) {
            NaviData naviData11 = (NaviData)vector3.elementAt(i);
            this.writeNaviData(element, "ZoneData", naviData11);
        }
        return documentImpl;
    }

    private void writeNaviData(Element element, String string, NaviData naviData) throws Exception {
        XmlUtil xmlUtil = new XmlUtil();
        Element element2 = xmlUtil.createSubElement(element, string);
        xmlUtil.createOrSetTextValue(element2, "linkStart", naviData.linkStart);
        xmlUtil.createOrSetTextValue(element2, "imageAlt", naviData.name);
        xmlUtil.createOrSetTextValue(element2, "linkEnd", naviData.linkEnd);
    }

    class NaviData {
        String linkStart;
        String name;
        String linkEnd;

        NaviData() {
        }
    }
}

