/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.environment;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.co.iti.fagot.ZApp;
import jp.co.nri.rid.environment.DocumentType;
import jp.co.nri.rid.environment.EnvDialog;
import jp.co.nri.rid.environment.EnvFileChooser;

public class DocumentTypeDialog {
    protected JPanel mPanel = null;
    protected JTextField mTApp = null;
    protected JTextField mTCmd = null;
    protected JButton mBCmd = null;
    protected JTextField mTExt = null;
    protected JTextField mTVext = null;

    public boolean newDocument(DocumentType documentType) {
        JFrame jFrame = (JFrame)ZApp.getTheApp().getFrame();
        EnvDialog envDialog = new EnvDialog(jFrame, "Document Type (New)");
        this.mPanel = this.crtPanel();
        envDialog.setControlPanel(this.mPanel);
        envDialog.doModal();
        boolean bl = envDialog.isOK();
        if (bl) {
            this.setDocumentType(documentType);
        }
        return bl;
    }

    public boolean editDocument(DocumentType documentType) {
        JFrame jFrame = (JFrame)ZApp.getTheApp().getFrame();
        EnvDialog envDialog = new EnvDialog(jFrame, "Document Type (Edit)");
        String string = documentType.app != null ? documentType.app : "";
        String string2 = documentType.cmd != null ? documentType.cmd : "";
        String string3 = documentType.ext != null ? documentType.ext : "";
        String string4 = documentType.view != null ? documentType.view : "";
        this.mPanel = this.crtPanel();
        this.mTApp.setText(string);
        this.mTApp.setColumns(Math.max(20, string.length()));
        this.mTCmd.setText(string2);
        this.mTCmd.setColumns(Math.max(20, string2.length()));
        this.mTExt.setText(string3);
        this.mTExt.setColumns(Math.max(20, string3.length()));
        this.mTVext.setText(string4);
        this.mTVext.setColumns(Math.max(20, string4.length()));
        envDialog.setControlPanel(this.mPanel);
        envDialog.doModal();
        boolean bl = envDialog.isOK();
        if (bl) {
            this.setDocumentType(documentType);
        }
        return bl;
    }

    public JPanel crtPanel() {
        this.mPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.mPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = this.createLabelConstraints();
        GridBagConstraints gridBagConstraints2 = this.createComponentConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel("Application");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.mPanel.add(jLabel);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        this.mTApp = new JTextField("", 20);
        gridBagLayout.setConstraints(this.mTApp, gridBagConstraints2);
        this.mPanel.add(this.mTApp);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jLabel = new JLabel("Command");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.mPanel.add(jLabel);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        this.mTCmd = new JTextField("", 20);
        gridBagLayout.setConstraints(this.mTCmd, gridBagConstraints2);
        this.mPanel.add(this.mTCmd);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jLabel = new JLabel("Extension");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.mPanel.add(jLabel);
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 0.0;
        this.mBCmd = new JButton("...");
        gridBagLayout.setConstraints(this.mBCmd, gridBagConstraints2);
        this.mPanel.add(this.mBCmd);
        this.mBCmd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DocumentTypeDialog.this.fileChooser();
            }
        });
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 2;
        this.mTExt = new JTextField("", 20);
        gridBagLayout.setConstraints(this.mTExt, gridBagConstraints2);
        this.mPanel.add(this.mTExt);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jLabel = new JLabel("View Extension");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.mPanel.add(jLabel);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 3;
        this.mTVext = new JTextField("", 20);
        gridBagLayout.setConstraints(this.mTVext, gridBagConstraints2);
        this.mPanel.add(this.mTVext);
        return this.mPanel;
    }

    public void setDocumentType(DocumentType documentType) {
        documentType.app = this.getAppText();
        documentType.cmd = this.getCmdText();
        documentType.ext = this.getExtText();
        documentType.view = this.getVExtText();
    }

    private GridBagConstraints createLabelConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        return gridBagConstraints;
    }

    private GridBagConstraints createComponentConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        return gridBagConstraints;
    }

    public void fileChooser() {
        EnvFileChooser envFileChooser = new EnvFileChooser();
        String string = envFileChooser.show(ZApp.getTheApp().getFrame(), this.getCmdText(), 2);
        if (string != null) {
            this.mTCmd.setText(string);
        }
    }

    private String getAppText() {
        String string = this.mTApp.getText();
        if (string == null || string.equals("")) {
            return null;
        }
        return string;
    }

    private String getCmdText() {
        String string = this.mTCmd.getText();
        if (string == null || string.equals("")) {
            return null;
        }
        return string;
    }

    private String getExtText() {
        String string = this.mTExt.getText();
        if (string == null || string.equals("")) {
            return null;
        }
        return string;
    }

    private String getVExtText() {
        String string = this.mTVext.getText();
        if (string == null || string.equals("")) {
            return null;
        }
        return string;
    }
}

