/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.doc;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import jp.co.iti.fagot.doc.DocGridControler;
import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.fob.FColor;
import jp.co.iti.fagot.geom.ZLine;
import jp.co.iti.fagot.geom.ZPath;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;
import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GLine;
import jp.co.iti.fagot.gob.GPath;
import jp.co.iti.fagot.gob.GobManager;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.nri.rid.doc.RidDocumentSite;
import jp.co.nri.rid.doc.RidElement;
import jp.co.nri.rid.doc.RidElementPage;
import jp.co.nri.rid.doc.RidElementScenario;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class RidElementScenarioItem
extends RidElement {
    protected RidElementPage[] mContainer = new RidElementPage[2];

    public byte getPreMoveMode(GElement gElement, ZPoint zPoint) {
        byte by = super.getPreMoveMode(gElement, zPoint);
        switch (by) {
            case 1: {
                by = 0;
                break;
            }
            case 11: {
                DocPane docPane = (DocPane)ZInstance.map().get("Map");
                String string = docPane.getPanelId();
                if (!this.findContainer(string, zPoint, null)) break;
                this.getContainer(1).setHighlight(string, (byte)1);
                break;
            }
        }
        return by;
    }

    public void moveStart(GElement gElement, DocGridControler docGridControler) {
    }

    public ZPath getMovingPath(GElement gElement, DocGridControler docGridControler) {
        DocPane docPane = docGridControler.getEditor();
        ZPoint zPoint = docGridControler.getMovePoint();
        ZPath zPath = new ZPath();
        switch (docGridControler.getMoveMode()) {
            case 11: 
            case 12: {
                if (!this.findContainer(docPane.getPanelId(), zPoint, null)) break;
                RidElementPage ridElementPage = this.getContainer(1);
                ridElementPage.setHighlight(docPane.getPanelId(), (byte)1);
                zPath = ridElementPage.getMapScenarioPath(docPane.getPanelId());
            }
        }
        return zPath;
    }

    public void moveEnd(GElement gElement, DocGridControler docGridControler) {
        DocPane docPane = docGridControler.getEditor();
        ZPoint zPoint = docGridControler.getMovePoint();
        switch (docGridControler.getMoveMode()) {
            case 11: {
                if (!this.findContainer(docPane.getPanelId(), zPoint, null)) break;
                this.updateContainer(docPane.getPanelId());
                this.setSelect(gElement, true);
                RidDocumentSite ridDocumentSite = (RidDocumentSite)docPane.getDocument();
                this.setDocument(ridDocumentSite);
                RidElementScenario ridElementScenario = ridDocumentSite.getScenario(ridDocumentSite.getScenarioName());
                if (ridElementScenario == null) break;
                ridElementScenario.appendChild((Node)((Object)this));
                break;
            }
        }
    }

    public Vector createGobs(String string) {
        Vector<GPath> vector = new Vector<GPath>();
        RidElementPage ridElementPage = this.getContainer(0);
        GElement gElement = ridElementPage.getMainGob(string);
        if (gElement != null) {
            ZPath zPath = ridElementPage.getMapScenarioPath(string);
            GPath gPath = new GPath();
            gPath.setPath(zPath);
            Color color = this.getBackgroundColor();
            gPath.getStyle().setFillColor(new FColor(color));
            gPath.setSelect(this.isSelect());
            gPath.setGobId("map");
            gPath.setContainer(this);
            vector.add(gPath);
            ZRectangle zRectangle = new ZRectangle(gPath.getBounds());
            ZPoint zPoint = zRectangle.getCenter();
            boolean bl = true;
            for (RidElementScenarioItem ridElementScenarioItem = this.getNextItem(string); ridElementScenarioItem != null; ridElementScenarioItem = ridElementScenarioItem.getNextItem(string)) {
                ridElementPage = ridElementScenarioItem.getContainer(0);
                gElement = ridElementPage.getMainGob(string);
                if (gElement != null) {
                    GLine gLine = new GLine();
                    zRectangle = new ZRectangle(gElement.getBounds());
                    ZPoint zPoint2 = zRectangle.getCenter();
                    gLine.getStyle().setStrokeColor(new FColor(color));
                    gLine.setLine(new ZLine(zPoint, zPoint2));
                    gLine.getStyle().getStroke().getWidth().set(20.0f);
                    if (!bl) {
                        float[] fArray = new float[]{10.0f};
                        gLine.getStyle().getStroke().getDashArray().set(fArray);
                    }
                    gPath.addBackChild(gLine);
                    break;
                }
                bl = false;
            }
        }
        return vector;
    }

    public void updateKeyAttribute(String string, RidElement ridElement) {
        String string2 = ridElement.getAttribute("Key");
        String string3 = string;
        if (string3 == null) {
            string3 = string2;
        }
        if (this.getAttribute("Container").equals(string3)) {
            if (string == null) {
                this.removeFromDocTree();
            } else {
                this.setAttribute("Container", string2);
                this.mContainer[0] = (RidElementPage)ridElement;
            }
        }
    }

    protected boolean findContainer(String string, ZPoint zPoint, RidElement ridElement) {
        this.mContainer[1] = null;
        Enumeration enumeration = GobManager.elements(string, ".all");
        while (enumeration.hasMoreElements()) {
            RidElementPage ridElementPage;
            GElement gElement = (GElement)enumeration.nextElement();
            byte by = gElement.getConnectMode(zPoint, this);
            if (by == 0 || (ridElementPage = (RidElementPage)gElement.getContainer()) == null || ridElementPage == ridElement) continue;
            this.mContainer[1] = ridElementPage;
            return true;
        }
        return false;
    }

    protected void updateContainer(String string) {
        this.mContainer[0] = this.mContainer[1];
        String string2 = this.mContainer[0].getAttribute("Key");
        this.setAttribute("Container", string2);
        this.mContainer[1] = null;
    }

    protected RidElementPage getContainer(int n) {
        if (n == 0 && this.mContainer[n] == null) {
            String string = this.getAttribute("Container");
            RidDocumentSite ridDocumentSite = (RidDocumentSite)ZInstance.map().get("document.site");
            this.mContainer[n] = (RidElementPage)ridDocumentSite.findChildElementInZone("PageUnit", string);
        }
        return this.mContainer[n];
    }

    protected RidElementScenarioItem getNextItem(String string) {
        for (Node node = this.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof RidElementScenarioItem)) continue;
            RidElementScenarioItem ridElementScenarioItem = (RidElementScenarioItem)((Object)node);
            return (RidElementScenarioItem)((Object)node);
        }
        return null;
    }
}

