/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.doc;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocGridControler;
import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.fob.FColor;
import jp.co.iti.fagot.fob.xml.XElementNS;
import jp.co.iti.fagot.geom.ZLine;
import jp.co.iti.fagot.geom.ZPath;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;
import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GLine;
import jp.co.iti.fagot.gob.GString;
import jp.co.iti.fagot.gob.GobManager;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZResource;
import jp.co.nri.rid.doc.RidDocumentSite;
import jp.co.nri.rid.doc.RidElement;
import jp.co.nri.rid.doc.RidElementZone;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class RidElementLink
extends RidElement {
    protected RidElement[] mConnectContainer = new RidElement[3];
    protected byte mConnectPosition = 0;

    public RidElementLink() throws DOMException {
        for (int i = 0; i < 2; ++i) {
            this.mConnectContainer[i] = null;
        }
    }

    public String getAttribute(String string) {
        if (string.equals("Connect0.Key")) {
            return this.getConnectElement(0).getAttribute("Key");
        }
        if (string.equals("Connect1.Key")) {
            return this.getConnectElement(1).getAttribute("Key");
        }
        return super.getAttribute(string);
    }

    public Vector createGobs(String string) {
        Vector<GLine> vector = new Vector<GLine>();
        String string2 = this.getAttribute("Intensity");
        boolean bl = true;
        ZResource zResource = ZApp.getTheApp().getResource();
        bl = string2.equals("Virtual") ? zResource.getBoolean("view.Link.Virtual", true) : zResource.getBoolean("view.Link.Real", false);
        if (!bl) {
            return vector;
        }
        boolean bl2 = true;
        boolean bl3 = zResource.getBoolean("view.Link.Select", false);
        GElement gElement = this.getConnectElement(0).getMainGob(string);
        GElement gElement2 = this.getConnectElement(1).getMainGob(string);
        if (string.equals("Zone")) {
            if (gElement == null && gElement2 == null) {
                bl = false;
            } else if (!(!bl3 || gElement != null && gElement.isSelect() || gElement2 != null && gElement2.isSelect())) {
                bl = false;
            }
        } else {
            if (gElement == null || gElement2 == null) {
                bl = false;
            } else if (gElement == gElement2) {
                bl = false;
            } else if (bl3 && !gElement.isSelect() && !gElement2.isSelect()) {
                bl = false;
            }
            bl2 = false;
        }
        if (!bl) {
            return vector;
        }
        ZPoint zPoint = this.getConnectPoint(string, 0);
        ZPoint zPoint2 = this.getConnectPoint(string, 1);
        GLine gLine = new GLine();
        Color color = this.getColorAttr("PaintColor");
        if (color == null) {
            color = string2.equals("Virtual") ? zResource.getColor("unit.color.StrongLink") : zResource.getColor("unit.color." + this.getTagName());
        }
        if (string2.equals("Virtual")) {
            gLine.getStyle().getStroke().getWidth().set(2.0f);
        }
        if (!this.getBooleanAttr("Exist", true)) {
            color = zResource.getColor("unit.color.NotExist");
        }
        gLine.getStyle().setStrokeColor(new FColor(color));
        gLine.setLine(new ZLine(zPoint, zPoint2));
        gLine.setArrow(1);
        gLine.setContainer(this);
        if (bl2) {
            gLine.setSelect(this.isSelect());
            gLine.setGobId("zone");
        } else {
            gLine.setGobId("map");
            gLine.setSelectable(false);
        }
        String string3 = this.getAttribute("Condition");
        if (string3.length() > 0) {
            ZRectangle zRectangle = new ZRectangle((zPoint.getX() + zPoint2.getX()) / 2.0, (zPoint.getY() + zPoint2.getY()) / 2.0, 1000.0, RidElementLink.getTitleHeight());
            GString gString = new GString();
            gString.setText(string3);
            gString.getStyle().setFillColor(new FColor(Color.black));
            gString.setFormat(16);
            gString.setRect(zRectangle);
            gLine.addForeChild(gString);
        }
        vector.add(gLine);
        return vector;
    }

    public Vector createSkeltonGobs(String string, boolean bl) {
        return new Vector();
    }

    public void updateKeyAttribute(String string, RidElement ridElement) {
        String string2 = ridElement.getAttribute("Key");
        String string3 = string;
        if (string3 == null) {
            string3 = string2;
        }
        XElementNS xElementNS = this.getChildElement("Connect0", null);
        String string4 = xElementNS.getAttribute("Key");
        XElementNS xElementNS2 = this.getChildElement("Connect1", null);
        String string5 = xElementNS2.getAttribute("Key");
        if (string == null) {
            if (string4.equals(string3) || string5.equals(string3)) {
                this.removeFromDocTree();
            }
        } else {
            if (string4.equals(string3)) {
                xElementNS.setAttribute("Key", string2);
                this.mConnectContainer[0] = ridElement;
            }
            if (string5.equals(string3)) {
                xElementNS2.setAttribute("Key", string2);
                this.mConnectContainer[1] = ridElement;
            }
        }
    }

    public byte getPreMoveMode(GElement gElement, ZPoint zPoint) {
        byte by = super.getPreMoveMode(gElement, zPoint);
        switch (by) {
            case 1: {
                by = 0;
                break;
            }
            case 11: 
            case 12: {
                String string = ZInstance.prop().getProperty("panel.active");
                if (!this.findConnectContainer(string, zPoint, null)) break;
                this.getConnectElement(2).setHighlight(string, this.mConnectPosition);
            }
        }
        return by;
    }

    public void moveStart(GElement gElement, DocGridControler docGridControler) {
        switch (docGridControler.getMoveMode()) {
            case 11: 
            case 12: {
                gElement.moveStartGob(docGridControler);
                DocPane docPane = docGridControler.getEditor();
                if (docGridControler.getMoveMode() != 11) break;
                if (this.findConnectContainer(docPane.getPanelId(), docGridControler.getStartPoint(), null)) {
                    if (this.mConnectPosition != 1) {
                        this.getConnectElement(2).setHighlight(docPane.getPanelId(), this.mConnectPosition);
                        this.updateConnectContainer(docPane.getPanelId(), 0);
                        break;
                    }
                    docGridControler.setMoveMode((byte)0);
                    break;
                }
                docGridControler.setMoveMode((byte)0);
                return;
            }
        }
    }

    public ZPath getMovingPath(GElement gElement, DocGridControler docGridControler) {
        DocPane docPane = docGridControler.getEditor();
        ZPoint zPoint = docGridControler.getMovePoint();
        ZPoint zPoint2 = docGridControler.getMovePoint();
        switch (docGridControler.getMoveMode()) {
            case 11: 
            case 12: {
                int n = 0;
                if (docGridControler.getMoveMode() == 12) {
                    n = ((GLine)gElement).getMovePoint() == 0 ? 1 : 0;
                }
                zPoint2 = this.getConnectPoint(docPane.getPanelId(), n);
                if (!this.findConnectContainer(docPane.getPanelId(), docGridControler.getMovePoint(), this.getConnectElement(n))) break;
                this.getConnectElement(2).setHighlight(docPane.getPanelId(), this.mConnectPosition);
                if (this.mConnectPosition == 1) break;
                zPoint = this.getConnectPoint(docPane.getPanelId(), 2);
            }
        }
        return new ZPath(new ZLine(zPoint, zPoint2));
    }

    public void moveEnd(GElement gElement, DocGridControler docGridControler) {
        DocPane docPane = docGridControler.getEditor();
        switch (docGridControler.getMoveMode()) {
            case 11: {
                if (!this.findConnectContainer(docPane.getPanelId(), docGridControler.getMovePoint(), this.getConnectElement(0)) || this.mConnectPosition == 1) break;
                this.updateConnectContainer(docPane.getPanelId(), 1);
                this.setAttribute("Intensity", "Virtual");
                this.setAttribute("Creator", "Operator");
                this.setSelect(gElement, true);
                DocDocument docDocument = docPane.getDocument();
                this.setDocument(docDocument);
                DocElement docElement = (DocElement)((DocElement)((Object)docDocument.getDocumentElement())).getChildElement("Link", null);
                docElement.appendChild((Node)((Object)this));
                break;
            }
            case 12: {
                int n;
                int n2 = n = ((GLine)gElement).getMovePoint() == 0 ? 1 : 0;
                if (!this.findConnectContainer(docPane.getPanelId(), docGridControler.getMovePoint(), this.getConnectElement(n)) || this.mConnectPosition == 1) break;
                this.updateConnectContainer(docPane.getPanelId(), ((GLine)gElement).getMovePoint());
            }
        }
    }

    protected boolean findConnectContainer(String string, ZPoint zPoint, RidElement ridElement) {
        this.mConnectContainer[2] = null;
        this.mConnectPosition = 0;
        Enumeration enumeration = GobManager.elements(string, ".all");
        while (enumeration.hasMoreElements()) {
            RidElement ridElement2;
            GElement gElement = (GElement)enumeration.nextElement();
            byte by = gElement.getConnectMode(zPoint, this);
            if (by == 0 || (ridElement2 = (RidElement)gElement.getContainer()) == null || ridElement2 == ridElement) continue;
            this.mConnectContainer[2] = ridElement2;
            this.mConnectPosition = by;
            return true;
        }
        return false;
    }

    protected void updateConnectContainer(String string, int n) {
        this.mConnectContainer[n] = this.mConnectContainer[2];
        XElementNS xElementNS = this.getChildElement("Connect" + n, null);
        String string2 = this.mConnectContainer[2].getAttribute("Key");
        xElementNS.setAttribute("Key", string2);
        xElementNS.setByteAttr("Position", this.mConnectPosition);
        this.mConnectContainer[2] = null;
    }

    protected ZPoint getConnectPoint(String string, int n) {
        byte by = this.mConnectPosition;
        if (n != 2) {
            XElementNS xElementNS = this.findChildElement(".Connect" + n, null);
            if (n == 0) {
                by = xElementNS.getByteAttr("Position", (byte)5);
            } else if (n == 1) {
                by = xElementNS.getByteAttr("Position", (byte)2);
            }
        }
        return this.getConnectElement(n).getConnectPoint(string, by);
    }

    protected RidElement getConnectElement(int n) {
        if (n != 2 && this.mConnectContainer[n] == null) {
            XElementNS xElementNS = this.getChildElement("Connect" + n, null);
            String string = xElementNS.getAttribute("Key");
            RidDocumentSite ridDocumentSite = (RidDocumentSite)((Object)this.getOwnerDocument());
            RidElementZone ridElementZone = ridDocumentSite.getTopZone();
            this.mConnectContainer[n] = (RidElement)ridElementZone.findChildElement(".UrlUnit", "Name=" + string);
            if (this.mConnectContainer[n] == null) {
                this.mConnectContainer[n] = ridDocumentSite.findChildElementInZone("PageUnit", string);
            }
            if (this.mConnectContainer[n] == null) {
                ZDebug.err("Connect element find failed:" + string);
            }
        }
        return this.mConnectContainer[n];
    }

    protected RidElement getLinkToElement(RidElement ridElement) {
        RidElement ridElement2 = null;
        if (this.getConnectElement(0) == ridElement) {
            ridElement2 = this.getConnectElement(1);
        }
        if (ridElement2 != null && ridElement2.getStatus().equals("remove")) {
            ZDebug.trace("no link");
            ridElement2 = null;
        }
        return ridElement2;
    }

    protected RidElement getLinkFromElement(RidElement ridElement) {
        RidElement ridElement2 = null;
        if (this.getConnectElement(1) == ridElement) {
            ridElement2 = this.getConnectElement(0);
        }
        if (ridElement2 != null && ridElement2.getStatus().equals("remove")) {
            ZDebug.trace("no link");
            ridElement2 = null;
        }
        return ridElement2;
    }
}

