/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.doc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.fob.xml.XElementNS;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;
import jp.co.iti.fagot.gob.GobManager;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZReverseEnumeration;
import jp.co.iti.fagot.util.ZString;
import jp.co.nri.rid.RUpdateManager;
import jp.co.nri.rid.doc.AccessCounts;
import jp.co.nri.rid.doc.MapMinorTree;
import jp.co.nri.rid.doc.MapModel;
import jp.co.nri.rid.doc.RidDocument;
import jp.co.nri.rid.doc.RidElement;
import jp.co.nri.rid.doc.RidElementLink;
import jp.co.nri.rid.doc.RidElementPage;
import jp.co.nri.rid.doc.RidElementScenario;
import jp.co.nri.rid.doc.RidElementScenarioItem;
import jp.co.nri.rid.doc.RidElementZone;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RidDocumentSite
extends RidDocument {
    protected Hashtable mRoot = new Hashtable();
    protected Hashtable mMapModel = new Hashtable();
    protected boolean mUpdateAccessCount = true;

    public void initDocument() {
        super.initDocument();
        ZResource zResource = ZApp.getTheApp().getResource();
        Element element = this.createElementNS(null, "ReferenceUnit");
        Element element2 = this.createElementNS(null, "FileUnit");
        element2.setAttribute("Type", "resource");
        element2.setAttribute("Name", zResource.getString("rid.resource.xml"));
        element.appendChild(element2);
        Element element3 = this.createElementNS(null, "FileUnit");
        element3.setAttribute("Type", "document");
        element3.setAttribute("Name", zResource.getString("rid.document.xml"));
        element.appendChild(element3);
        Element element4 = this.createElementNS(null, "FileUnit");
        element4.setAttribute("Type", "snapshot");
        element4.setAttribute("Name", zResource.getString("rid.snapshot.xml"));
        element.appendChild(element4);
        this.getDocumentElement().appendChild(element);
        Element element5 = this.createElementNS(null, "ZoneUnit");
        element5.setAttribute("Name", "_top");
        this.getDocumentElement().appendChild(element5);
        Element element6 = this.createElementNS(null, "Link");
        this.getDocumentElement().appendChild(element6);
        Element element7 = this.createElementNS(null, "Scenario");
        this.getDocumentElement().appendChild(element7);
    }

    public Color getBackground(String string) {
        ZResource zResource = ZApp.getTheApp().getResource();
        if (string != null) {
            if (string.equals("Zone")) {
                RidElement ridElement = (RidElement)((Object)this.getRootElement("Zone"));
                return ridElement.getBackgroundColor();
            }
            if (string.startsWith("Map")) {
                return zResource.getColor("panel.color." + string);
            }
        }
        return super.getBackground(string);
    }

    public Dimension getLogicalSize() {
        return new Dimension(16000, 12000);
    }

    public void setRootElement(String string, Element element) {
        if (element != null) {
            this.mRoot.put(string, element);
        } else {
            this.mRoot.remove(string);
        }
    }

    public Element getRootElement(String string) {
        Object object = (Element)this.mRoot.get(string);
        if (object != null && ((RidElement)object).getStatus().equals("remove")) {
            this.mRoot.remove(string);
        }
        if (object == null) {
            object = this.getTopZone();
        }
        return object;
    }

    public void setTopPage(String string, String string2) {
        RidElementZone ridElementZone = this.getTopZone();
        DocElement docElement = (DocElement)ridElementZone.getChildElement(".ViewInfo." + string, null);
        docElement.setAttribute("Top", string2);
    }

    public RidElementPage getTopPage(String string) {
        RidElementPage ridElementPage = null;
        RidElementZone ridElementZone = this.getTopZone();
        String string2 = ridElementZone.getChildElementAttribute(".ViewInfo." + string, null, "Top");
        if (string2.length() > 0 && (ridElementPage = (RidElementPage)this.findChildElementInZone("PageUnit", string2)) == null) {
            this.setTopPage(string, "");
            this.requestUpdateAccessCount();
        }
        if (ridElementPage == null) {
            ridElementPage = this.getDefaultTopPage(string);
        }
        return ridElementPage;
    }

    public RidElementPage getDefaultTopPage(String string) {
        RidElementZone ridElementZone = this.getTopZone();
        return ridElementZone.getDefaultTopPage();
    }

    public MapModel getMapModel(String string) {
        MapModel mapModel = (MapModel)this.mMapModel.get(string);
        if (mapModel == null) {
            Dimension dimension = this.getLogicalSize();
            mapModel = new MapModel();
            if (string.endsWith("Site")) {
                mapModel.setObjectTransform(new AffineTransform(1.0, 0.75, 0.0, 1.0, 0.0, 0.0));
                mapModel.setCoordTransform(new AffineTransform(80.0f, -60.0f, 80.0f, 60.0f, 0.0f, 0.0f));
                mapModel.setLinkOffset(new ZPoint(0.5, 1.0));
                mapModel.setBasePoint(new ZPoint(dimension.width / 3, dimension.height * 2 / 3));
            } else if (string.endsWith("Hier")) {
                mapModel.setCoordTransform(new AffineTransform(0.0f, 100.0f, 100.0f, 0.0f, 0.0f, 0.0f));
                mapModel.setBasePoint(new ZPoint(dimension.width / 2, 300.0));
            } else if (string.endsWith("Circle")) {
                mapModel.setCoordTransform(null);
                mapModel.setBasePoint(new ZPoint(dimension.width / 2, dimension.height / 2));
            }
            this.mMapModel.put(string, mapModel);
        }
        return mapModel;
    }

    public void createScenario() {
        ZResource zResource = ZApp.getTheApp().getResource();
        String string = zResource.getString("msg.askscenarioname1");
        String string2 = zResource.getString("msg.askscenarioname2");
        JFrame jFrame = (JFrame)ZInstance.map().get("frame");
        String string3 = JOptionPane.showInputDialog(jFrame, string, "Ridual", 3);
        DocElement docElement = (DocElement)((DocElement)((Object)this.getDocumentElement())).findChildElement(".Scenario", null);
        while (string3 != null && string3.length() > 0 && (string3 = ZString.trimLeft(string3)).length() != 0) {
            XElementNS xElementNS = docElement.findChildElement(".ScenarioUnit", "Name=" + string3);
            if (xElementNS == null) {
                this.beginTransaction();
                xElementNS = (XElementNS)((Object)this.createElementNS(null, "ScenarioUnit"));
                xElementNS.setAttribute("Name", string3);
                docElement.appendChild((Node)((Object)xElementNS));
                this.setScenarioName(string3);
                this.commit();
                break;
            }
            string3 = JOptionPane.showInputDialog(jFrame, string3 + " " + string2, "Ridual", 2);
        }
    }

    public void deleteScenario() {
        String string = this.getScenarioName();
        if (string.length() > 0) {
            this.beginTransaction();
            DocElement docElement = (DocElement)((DocElement)((Object)this.getDocumentElement())).findChildElement(".Scenario", null);
            XElementNS xElementNS = docElement.findChildElement(".ScenarioUnit", "Name=" + string);
            docElement.removeChild((Node)((Object)xElementNS));
            this.setScenarioName("");
            this.commit();
        }
    }

    public void setScenarioName(String string) {
        RidElementZone ridElementZone = this.getTopZone();
        XElementNS xElementNS = ridElementZone.getChildElement(".ViewInfo.Map", null);
        xElementNS.setAttribute("Scenario", string);
        RUpdateManager.update(4);
    }

    public String getScenarioName() {
        RidElementZone ridElementZone = this.getTopZone();
        XElementNS xElementNS = ridElementZone.getChildElement(".ViewInfo.Map", null);
        return xElementNS.getAttribute("Scenario");
    }

    public RidElementScenario getScenario(String string) {
        RidElementScenario ridElementScenario = null;
        if (string.length() > 0) {
            DocElement docElement = (DocElement)((DocElement)((Object)this.getDocumentElement())).findChildElement(".Scenario", null);
            ridElementScenario = (RidElementScenario)docElement.findChildElement(".ScenarioUnit", "Name=" + string);
        }
        return ridElementScenario;
    }

    public Vector createGobs(String string) {
        Vector vector = new Vector();
        if (string.equals("Zone")) {
            RidElementZone ridElementZone = this.getTopZone();
            ((DocElement)ridElementZone).preCreateGobs(string);
            GobManager.list(string, "additional").removeAllElements();
            RidElement.mAllUnits = null;
            vector.addAll(super.createGobs(string));
            Vector vector2 = this.createLinkGobs(string);
            vector.addAll(GobManager.list(string, "additional"));
            vector.addAll(vector2);
        } else if (string.startsWith("Map")) {
            Object object;
            Object object2;
            Object object3;
            Vector<RidElementPage> vector3;
            RidElementPage ridElementPage = this.getTopPage(string);
            if (ridElementPage == null) {
                return vector;
            }
            RidElementZone ridElementZone = this.getTopZone();
            ((DocElement)ridElementZone).preCreateGobs(string);
            Vector vector4 = new Vector();
            vector4.add(new Vector());
            if (string.endsWith("Circle")) {
                ridElementPage.preCreateMapGobs(string);
                ridElementPage.createMapGobs(string, 1, vector4);
            } else if (ridElementPage.getMapParent(string, "Auto").equals("root")) {
                vector3 = this.getTopZone().getPages(true);
                object3 = new Vector();
                object2 = vector3.elements();
                while (object2.hasMoreElements()) {
                    ridElementPage = (RidElementPage)object2.nextElement();
                    if (!ridElementPage.getMapParent(string, "Auto").equals("root")) continue;
                    ridElementPage.preCreateMapGobs(string);
                    ((Vector)object3).add(ridElementPage);
                }
                if (string.endsWith("Site")) {
                    this.updateAccessCount(string, (Vector)object3);
                }
                object2 = ((Vector)object3).elements();
                while (object2.hasMoreElements()) {
                    ridElementPage = (RidElementPage)object2.nextElement();
                    ridElementPage.createMapGobs(string, 1, vector4);
                }
            } else {
                ridElementPage.preCreateMapGobs(string);
                if (string.endsWith("Site")) {
                    vector3 = new Vector<RidElementPage>();
                    vector3.add(ridElementPage);
                    this.updateAccessCount(string, vector3);
                }
                ridElementPage.createMapGobs(string, 1, vector4);
            }
            vector3 = (Vector)vector4.elementAt(0);
            vector4.removeElementAt(0);
            vector.addAll(vector3);
            object3 = new ZReverseEnumeration(vector4);
            while (object3.hasMoreElements()) {
                vector.addAll((Vector)object3.nextElement());
            }
            ridElementPage = this.getTopPage(string);
            object2 = (DocElement)ridElementPage.findChildElement(".Comments", null);
            if (object2 != null) {
                for (int i = 0; i < object2.getLength(); ++i) {
                    object = object2.item(i);
                    if (!(object instanceof DocElement)) continue;
                    vector.addAll(((DocElement)object).createGobs(string, false));
                }
            }
            Vector vector5 = this.createScenarioGobs(string);
            vector5.addAll(vector);
            vector = vector5;
            object = this.createLinkGobs(string);
            vector.addAll(object);
        }
        return vector;
    }

    public Vector createSkeltonGobs(String string) {
        Vector vector = new Vector();
        if (string.equals("Zone")) {
            vector.addAll(super.createSkeltonGobs(string));
        } else if (string.startsWith("Map")) {
            RidElementPage ridElementPage = this.getTopPage(string);
            if (string.endsWith("Circle")) {
                if (ridElementPage != null) {
                    vector.addAll(ridElementPage.createMapSkeltonGobs(string));
                }
            } else if (ridElementPage != null) {
                if (ridElementPage.getMapParent(string, "Auto").equals("root")) {
                    Vector vector2 = this.getTopZone().getPages(true);
                    Enumeration enumeration = vector2.elements();
                    while (enumeration.hasMoreElements()) {
                        ridElementPage = (RidElementPage)enumeration.nextElement();
                        if (!ridElementPage.getMapParent(string, "Auto").equals("root")) continue;
                        vector.addAll(ridElementPage.createMapSkeltonGobs(string));
                    }
                } else {
                    vector.addAll(ridElementPage.createMapSkeltonGobs(string));
                }
            }
        }
        return vector;
    }

    public Vector createLinkGobs(String string) {
        DocElement docElement = (DocElement)((DocElement)((Object)this.getDocumentElement())).findChildElement(".Link", null);
        Vector vector = new Vector();
        if (docElement != null) {
            for (int i = 0; i < docElement.getLength(); ++i) {
                Node node = docElement.item(i);
                if (!(node instanceof RidElementLink)) continue;
                vector.addAll(((RidElementLink)((Object)node)).createGobs(string));
            }
        }
        return vector;
    }

    public Vector createScenarioGobs(String string) {
        RidElementScenario ridElementScenario = this.getScenario(this.getScenarioName());
        Vector vector = new Vector();
        if (ridElementScenario != null) {
            for (int i = 0; i < ridElementScenario.getLength(); ++i) {
                Node node = ridElementScenario.item(i);
                if (!(node instanceof RidElementScenarioItem)) continue;
                vector.addAll(((RidElementScenarioItem)((Object)node)).createGobs(string));
            }
        }
        return vector;
    }

    protected void updateAccessCount(String string, Vector vector) {
        MapModel mapModel = this.getMapModel(string);
        AccessCounts accessCounts = null;
        if (this.mUpdateAccessCount) {
            RidElementZone ridElementZone = this.getTopZone();
            String string2 = ridElementZone.getAttribute("AccessLogList");
            String string3 = ridElementZone.getAttribute("AccessLogType");
            boolean[] blArray = null;
            if (string2.length() > 0) {
                blArray = new boolean[string2.length()];
                for (int i = 0; i < string2.length(); ++i) {
                    blArray[i] = string2.charAt(i) != 'n';
                }
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                RidElementPage ridElementPage = (RidElementPage)enumeration.nextElement();
                AccessCounts accessCounts2 = ridElementPage.getMaxAccessCount(string, blArray);
                if (accessCounts == null) {
                    accessCounts = accessCounts2;
                    continue;
                }
                accessCounts.margeMax(accessCounts2);
            }
            if (accessCounts != null) {
                accessCounts.setLogType(string3);
                accessCounts.calcMaxCount();
            }
            mapModel.setAccessCounts(accessCounts);
        }
        this.mUpdateAccessCount = false;
    }

    public void requestUpdateAccessCount() {
        this.mUpdateAccessCount = true;
    }

    protected RidElement findChildElementInZone(String string, String string2) {
        RidElement ridElement = this.getTopZone();
        String[] stringArray = ZString.tokenize(string2, "/");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if ((ridElement = (RidElement)ridElement.findChildElement(".ZoneUnit", "Name=" + stringArray[i])) != null) continue;
            return null;
        }
        return (RidElement)ridElement.findChildElement("." + string, "File=" + string2);
    }

    public Vector getToLink(RidElementPage ridElementPage, String string) {
        Vector<RidElementLink> vector = new Vector<RidElementLink>();
        Hashtable<String, RidElementLink> hashtable = new Hashtable<String, RidElementLink>();
        DocElement docElement = (DocElement)((DocElement)((Object)this.getDocumentElement())).findChildElement(".Link", null);
        if (docElement != null) {
            NodeList nodeList = docElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                RidElementLink ridElementLink;
                RidElement ridElement;
                Node node = nodeList.item(i);
                if (!(node instanceof RidElementLink) || (ridElement = (ridElementLink = (RidElementLink)((Object)node)).getLinkToElement(ridElementPage)) == null || !(ridElement instanceof RidElementPage) || string != null && !ridElementPage.getAttribute("File").equals(((RidElementPage)ridElement).getMapParent(string, null))) continue;
                String string2 = ridElement.getAttribute("File");
                RidElementLink ridElementLink2 = (RidElementLink)hashtable.get(string2);
                if (ridElementLink2 == null) {
                    vector.add(ridElementLink);
                    hashtable.put(string2, ridElementLink);
                    continue;
                }
                if (ridElementLink2.getAttribute("Intensity").equals("Virtual") || !ridElementLink.getAttribute("Intensity").equals("Virtual")) continue;
                vector.remove(ridElementLink2);
                vector.add(ridElementLink);
                hashtable.put(string2, ridElementLink);
            }
        }
        return vector;
    }

    public Vector getFromPage(RidElementPage ridElementPage) {
        Vector<RidElement> vector = new Vector<RidElement>();
        Hashtable<String, RidElement> hashtable = new Hashtable<String, RidElement>();
        DocElement docElement = (DocElement)((DocElement)((Object)this.getDocumentElement())).findChildElement(".Link", null);
        if (docElement != null) {
            NodeList nodeList = docElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string;
                RidElementPage ridElementPage2;
                RidElementLink ridElementLink;
                RidElement ridElement;
                Node node = nodeList.item(i);
                if (!(node instanceof RidElementLink) || (ridElement = (ridElementLink = (RidElementLink)((Object)node)).getLinkFromElement(ridElementPage)) == null || !(ridElement instanceof RidElementPage) || (ridElementPage2 = (RidElementPage)hashtable.get(string = ridElement.getAttribute("File"))) != null) continue;
                vector.add(ridElement);
                hashtable.put(string, ridElement);
            }
        }
        return vector;
    }

    public void setLinksUnSelect() {
        DocElement docElement = (DocElement)((DocElement)((Object)this.getDocumentElement())).findChildElement(".Link", null);
        Vector vector = new Vector();
        if (docElement != null) {
            for (int i = 0; i < docElement.getLength(); ++i) {
                Node node = docElement.item(i);
                if (!(node instanceof RidElementLink)) continue;
                RidElementLink ridElementLink = (RidElementLink)((Object)node);
                ridElementLink.setSelect(null, false);
            }
        }
    }

    public void requestRecalcMap() {
        DocElement docElement = (DocElement)((Object)this.getRootElement("Map.Site"));
        DocElement docElement2 = (DocElement)docElement.getChildElement(".ViewInfo.Map.Site", null);
        docElement2.setAttribute("Calc", "none");
        docElement = (DocElement)((Object)this.getRootElement("Map.Hier"));
        docElement2 = (DocElement)docElement.getChildElement(".ViewInfo.Map.Hier", null);
        docElement2.setAttribute("Calc", "none");
        docElement = (DocElement)((Object)this.getRootElement("Map.Circle"));
        docElement2 = (DocElement)docElement.getChildElement(".ViewInfo.Map.Circle", null);
        docElement2.setAttribute("Calc", "none");
    }

    public void requestUpdateAccessCount(String string, boolean bl) {
    }

    public ZRectangle recalcMap(String string, boolean bl) {
        Object object;
        this.requestUpdateAccessCount();
        RidElementPage ridElementPage = null;
        ridElementPage = string.endsWith("Circle") ? this.getTopPage(string) : this.getDefaultTopPage(string);
        if (ridElementPage == null) {
            return null;
        }
        MapModel mapModel = this.getMapModel(string);
        mapModel.clearOffset();
        RidElementZone ridElementZone = this.getTopZone();
        Vector vector = ridElementZone.getPages(true);
        Vector<RidElementPage> vector2 = new Vector<RidElementPage>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (RidElementPage)enumeration.nextElement();
            ((RidElementPage)object).clearMap(string);
            if (object == ridElementPage) continue;
            vector2.add((RidElementPage)object);
        }
        vector2.add(0, ridElementPage);
        object = null;
        if (string.endsWith("Circle")) {
            object = new Vector();
            ((Vector)object).add(ridElementPage);
            this.recalcMapMajor(string, bl, (Vector)object);
        } else {
            object = this.recalcMapMajor(string, bl, vector2);
        }
        MapMinorTree mapMinorTree = this.recalcMapMinor(string, (Vector)object, 1.0, false);
        DocElement docElement = (DocElement)ridElementPage.getChildElement(".ViewInfo." + string, null);
        docElement.setIntAttr("Depth", mapMinorTree.getDepth());
        ZRectangle zRectangle = null;
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            RidElementPage ridElementPage2 = (RidElementPage)enumeration.nextElement();
            ZRectangle zRectangle2 = ridElementPage2.recalcMapEnd(string, mapMinorTree.getMaxMinor());
            if (zRectangle == null) {
                zRectangle = zRectangle2;
                continue;
            }
            zRectangle.union(zRectangle2);
        }
        if (zRectangle != null) {
            double d = 20.0;
            ZRectangle zRectangle3 = new ZRectangle(zRectangle.getX() - d, zRectangle.getY() - d, zRectangle.getWidth() + d * 2.0, zRectangle.getHeight() + d * 2.0);
            zRectangle = mapModel.fitToPanel(zRectangle3, this.getLogicalSize());
        }
        return zRectangle;
    }

    public Vector recalcMapMajor(String string, boolean bl, Vector vector) {
        Vector<RidElementPage> vector2 = new Vector<RidElementPage>();
        Enumeration enumeration = vector.elements();
        int n = 1;
        while (enumeration.hasMoreElements()) {
            RidElementPage ridElementPage = (RidElementPage)enumeration.nextElement();
            boolean bl2 = ridElementPage.recalcMapMajor(string, null, bl, n);
            if (bl2) {
                vector2.add(ridElementPage);
            }
            ++n;
        }
        return vector2;
    }

    public MapMinorTree recalcMapMinor(String string, Vector vector, double d, boolean bl) {
        Collections.sort(vector, new PreMinorSorter());
        MapMinorTree mapMinorTree = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            RidElementPage ridElementPage = (RidElementPage)enumeration.nextElement();
            double d2 = mapMinorTree == null ? d : mapMinorTree.getMaxMinor() + 1.0;
            MapMinorTree mapMinorTree2 = ridElementPage.recalcMapMinor(string, d2, bl);
            if (mapMinorTree == null) {
                mapMinorTree = mapMinorTree2;
            } else {
                if (!string.endsWith("Circle")) {
                    double d3 = mapMinorTree.distance(mapMinorTree2);
                    if (d3 > 1.0) {
                        mapMinorTree2 = ridElementPage.recalcMapMinorMove(string, 1.0 - d3);
                    } else if (d3 <= 0.0) {
                        mapMinorTree2 = ridElementPage.recalcMapMinorMove(string, 1.0 - d3);
                    }
                }
                mapMinorTree.marge(mapMinorTree2);
            }
            bl = !bl;
        }
        return mapMinorTree;
    }

    public class PreMinorSorter
    implements Comparator {
        public int compare(Object object, Object object2) {
            RidElementPage ridElementPage = (RidElementPage)object;
            RidElementPage ridElementPage2 = (RidElementPage)object2;
            int n = 0;
            double d = ridElementPage.wMinorPre - ridElementPage2.wMinorPre;
            if (d > 0.0) {
                n = 1;
            } else if (d < 0.0) {
                n = -1;
            }
            return n;
        }

        public boolean equals(Object object) {
            return object instanceof PreMinorSorter;
        }
    }
}

