/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.doc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DefaultApplication;
import jp.co.iti.fagot.doc.DocBar;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.fob.xml.XDocument;
import jp.co.iti.fagot.ui.UDialog;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZFile;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZString;
import jp.co.nri.rid.RUpdateManager;
import jp.co.nri.rid.RidMapTitlePane;
import jp.co.nri.rid.RidPane;
import jp.co.nri.rid.RidZoneTitlePane;
import jp.co.nri.rid.doc.RidDocumentSite;
import jp.co.nri.rid.doc.RidElementZone;
import jp.co.nri.rid.doc.RidExecAction;
import jp.co.nri.rid.environment.MessageDialog;
import jp.co.nri.rid.error.RidMessage;
import jp.co.nri.rid.mapper.Mapper;
import jp.co.nri.rid.search.SearchPanel;
import jp.co.nri.rid.snapshot.xcopy;
import jp.co.nri.rid.table.LineNoRowHeader;
import jp.co.nri.rid.table.RTable;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.DOMSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class RidApplication
extends DefaultApplication {
    private static final String[] label_keys = new String[]{"msg.newproject.name", "msg.newproject.abbreviation", "msg.newproject.formal", "msg.newproject.purpose", "msg.newproject.comment", "msg.newproject.start", "msg.newproject.cutover", "msg.newproject.leader", "msg.newproject.member"};
    private static final int[] panelIndexs = new int[]{0, 1, 1, 1, 1, 2, 2, 3, 3};
    protected UDialog mDialog = null;

    public boolean initApplication(JFrame jFrame) {
        JComponent jComponent;
        int n;
        ZInstance.map().put("application", this);
        ZInstance.map().put("frame", jFrame);
        jFrame.getContentPane().add("West", this.createDocBar());
        JTabbedPane jTabbedPane = new JTabbedPane();
        ZInstance.map().put("Tab", jTabbedPane);
        for (n = 0; n < 8; ++n) {
            jComponent = this.createPanel(n);
            jTabbedPane.add(this.getTabName(n), jComponent);
        }
        jTabbedPane.addChangeListener(new TabAdapter());
        jFrame.getContentPane().add("Center", jTabbedPane);
        n = jTabbedPane.getSelectedIndex();
        jComponent = (DocBar)ZInstance.map().get("docbar");
        ((DocBar)jComponent).setPanel(n);
        String string = jTabbedPane.getTitleAt(n);
        ZInstance.prop().setProperty("panel.active", string);
        return true;
    }

    public void exitApplication() {
        this.savePages();
    }

    public boolean open(String string) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (string == null) {
            string = this.createProject();
            if (string == null) {
                RUpdateManager.update(0);
                return false;
            }
        } else {
            object4 = ZApp.getTheApp().getResource();
            object3 = new File(string);
            if (object3.isDirectory()) {
                object2 = ((ZResource)object4).getString("rid.data.dir");
                object = ((ZResource)object4).getString("rid.site.xml");
                string = string + File.separator + (String)object2 + File.separator + (String)object;
            }
        }
        if (!((File)(object4 = new File(string))).exists()) {
            object3 = "site.xml not exists:" + string;
            ZDebug.err((String)object3);
            object2 = new RidMessage();
            MessageDialog.showError(((RidMessage)object2).Error("E1100", (String)object3));
            RUpdateManager.update(0);
            return false;
        }
        object3 = this.loadDocument("document.site", string);
        if (object3 == null) {
            object2 = "site.xml load failed:" + string;
            ZDebug.err((String)object2);
            object = new RidMessage();
            MessageDialog.showError(((RidMessage)object).Error("E1100", (String)object2));
            RUpdateManager.update(0);
            return false;
        }
        object2 = ZFile.getParent(string);
        object = ((DocElement)((Object)object3.getDocumentElement())).getChildElementAttribute(".ReferenceUnit.FileUnit", "Type=resource", "Name");
        if (((String)object).length() == 0) {
            String string2 = "Empty RidProject.ReferenceUnit.FileUnit(resource)";
            ZDebug.err(string2);
            RidMessage ridMessage = new RidMessage();
            MessageDialog.showError(ridMessage.Error("E1101", string2));
            RUpdateManager.update(0);
            return false;
        }
        String string3 = (String)object2 + File.separator + (String)object;
        object4 = new File(string3);
        if (!((File)object4).exists()) {
            String string4 = "resource.xml not exists:" + string3;
            ZDebug.err(string4);
            RidMessage ridMessage = new RidMessage();
            MessageDialog.showError(ridMessage.Error("E1100", string4));
            RUpdateManager.update(0);
            return false;
        }
        DocDocument docDocument = this.loadDocument("document.resource", string3);
        if (docDocument == null) {
            String string5 = "resource.xml load failed:" + string3;
            ZDebug.err(string5);
            RidMessage ridMessage = new RidMessage();
            MessageDialog.showError(ridMessage.Error("E1100", string5));
            RUpdateManager.update(0);
            return false;
        }
        object = ((DocElement)((Object)object3.getDocumentElement())).getChildElementAttribute(".ReferenceUnit.FileUnit", "Type=document", "Name");
        if (((String)object).length() == 0) {
            String string6 = "Empty RidProject.ReferenceUnit.FileUnit(document)";
            ZDebug.err(string6);
            RidMessage ridMessage = new RidMessage();
            MessageDialog.showError(ridMessage.Error("E1101", string6));
            RUpdateManager.update(0);
            return false;
        }
        string3 = (String)object2 + File.separator + (String)object;
        object4 = new File(string3);
        if (!((File)object4).exists()) {
            String string7 = "document.xml not exists:" + string3;
            ZDebug.err(string7);
            RidMessage ridMessage = new RidMessage();
            MessageDialog.showError(ridMessage.Error("E1100", string7));
            RUpdateManager.update(0);
            return false;
        }
        DocDocument docDocument2 = this.loadDocument("document.document", string3);
        if (docDocument2 == null) {
            String string8 = "document.xml load failed:" + string3;
            ZDebug.err(string8);
            RidMessage ridMessage = new RidMessage();
            MessageDialog.showError(ridMessage.Error("E1100", string8));
            RUpdateManager.update(0);
            return false;
        }
        object = ((DocElement)((Object)object3.getDocumentElement())).getChildElementAttribute(".ReferenceUnit.FileUnit", "Type=snapshot", "Name");
        if (((String)object).length() == 0) {
            String string9 = "Empty RidProject.ReferenceUnit.FileUnit(snapshot)";
            ZDebug.err(string9);
            RidMessage ridMessage = new RidMessage();
            MessageDialog.showError(ridMessage.Error("E1101", string9));
            RUpdateManager.update(0);
            return false;
        }
        string3 = (String)object2 + File.separator + (String)object;
        object4 = new File(string3);
        if (!((File)object4).exists()) {
            String string10 = "snapshot.xml not exists:" + string3;
            ZDebug.err(string10);
            RidMessage ridMessage = new RidMessage();
            MessageDialog.showError(ridMessage.Error("E1100", string10));
            RUpdateManager.update(0);
            return false;
        }
        DocDocument docDocument3 = this.loadDocument("document.snapshot", string3);
        if (docDocument3 == null) {
            String string11 = "snapshot.xml load failed:" + string3;
            ZDebug.err(string11);
            RidMessage ridMessage = new RidMessage();
            MessageDialog.showError(ridMessage.Error("E1100", string11));
            RUpdateManager.update(0);
            return false;
        }
        ZInstance.map().put("document.site", object3);
        ZInstance.map().put("document.resource", docDocument);
        ZInstance.map().put("document.document", docDocument2);
        ZInstance.map().put("document.snapshot", docDocument3);
        super.open(string);
        JTabbedPane jTabbedPane = (JTabbedPane)ZInstance.map().get("Tab");
        if (jTabbedPane != null) {
            jTabbedPane.setSelectedIndex(0);
            JComponent jComponent = (JComponent)ZInstance.map().get("Zone");
            jComponent.requestFocus();
        }
        this.updateDocument();
        return true;
    }

    public boolean save() {
        if (!this.canSave()) {
            return false;
        }
        String string = ZString.getDateTime();
        ZDebug.trace("Save:" + string);
        DocDocument docDocument = (DocDocument)((Object)ZInstance.map().get("document.site"));
        docDocument.beginTransaction();
        DocElement docElement = (DocElement)((Object)docDocument.getDocumentElement());
        docElement.setAttribute("Update", string);
        docDocument.commit();
        docDocument = this.saveDocument(docDocument, this.getFileName());
        if (docDocument != null) {
            String string2 = ZFile.getParent(this.getFileName());
            String string3 = ((DocElement)((Object)docDocument.getDocumentElement())).getChildElementAttribute(".ReferenceUnit.FileUnit", "Type=resource", "Name");
            if (string3.length() == 0) {
                String string4 = "Empty RidProject.ReferenceUnit.FileUnit(resource)";
                ZDebug.err(string4);
                RidMessage ridMessage = new RidMessage();
                MessageDialog.showError(ridMessage.Error("E1101", string4));
                return false;
            }
            DocDocument docDocument2 = (DocDocument)((Object)ZInstance.map().get("document.resource"));
            docDocument2.beginTransaction();
            docElement = (DocElement)((Object)docDocument2.getDocumentElement());
            docElement.setAttribute("Update", string);
            docDocument2.commit();
            this.saveDocument(docDocument2, string2 + File.separator + string3);
            string3 = ((DocElement)((Object)docDocument.getDocumentElement())).getChildElementAttribute(".ReferenceUnit.FileUnit", "Type=document", "Name");
            if (string3.length() == 0) {
                String string5 = "Empty RidProject.ReferenceUnit.FileUnit(document)";
                ZDebug.err(string5);
                RidMessage ridMessage = new RidMessage();
                MessageDialog.showError(ridMessage.Error("E1101", string5));
                return false;
            }
            docDocument2 = (DocDocument)((Object)ZInstance.map().get("document.document"));
            docDocument2.beginTransaction();
            docElement = (DocElement)((Object)docDocument2.getDocumentElement());
            docElement.setAttribute("Update", string);
            docDocument2.commit();
            this.saveDocument(docDocument2, string2 + File.separator + string3);
            string3 = ((DocElement)((Object)docDocument.getDocumentElement())).getChildElementAttribute(".ReferenceUnit.FileUnit", "Type=snapshot", "Name");
            if (string3.length() == 0) {
                String string6 = "Empty RidProject.ReferenceUnit.FileUnit(snapshot)";
                ZDebug.err(string6);
                RidMessage ridMessage = new RidMessage();
                MessageDialog.showError(ridMessage.Error("E1101", string6));
                return false;
            }
            docDocument2 = (DocDocument)((Object)ZInstance.map().get("document.snapshot"));
            docDocument2.beginTransaction();
            docElement = (DocElement)((Object)docDocument2.getDocumentElement());
            docElement.setAttribute("Update", string);
            docDocument2.commit();
            this.saveDocument(docDocument2, string2 + File.separator + string3);
            this.savePages();
        }
        return true;
    }

    public boolean saveAs(String string) {
        if (!string.endsWith(".xml")) {
            string = string + ".xml";
        }
        return super.saveAs(string);
    }

    public boolean isModified() {
        boolean bl = false;
        DocDocument docDocument = (DocDocument)((Object)ZInstance.map().get("document.site"));
        bl = docDocument.isModified();
        if (!bl) {
            docDocument = (DocDocument)((Object)ZInstance.map().get("document.resource"));
            bl = docDocument.isModified();
        }
        if (!bl) {
            docDocument = (DocDocument)((Object)ZInstance.map().get("document.document"));
            bl = docDocument.isModified();
        }
        if (!bl) {
            docDocument = (DocDocument)((Object)ZInstance.map().get("document.snapshot"));
            bl = docDocument.isModified();
        }
        return bl;
    }

    protected JComponent createDocBar() {
        DocBar docBar = new DocBar();
        docBar.setOrientation(1);
        docBar.setFloatable(false);
        ZInstance.map().put("docbar", docBar);
        return docBar;
    }

    protected JComponent createPanel(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JComponent jComponent = this.createNorthComponent(n);
        if (jComponent != null) {
            jPanel.add("North", jComponent);
        }
        JScrollPane jScrollPane = new JScrollPane();
        jComponent = this.createCenterComponent(n);
        jScrollPane.setViewportView(jComponent);
        if (jComponent instanceof DocPane) {
            jScrollPane.getViewport().addChangeListener(new ScrollAdapter());
        } else if (jComponent instanceof RTable) {
            LineNoRowHeader lineNoRowHeader = new LineNoRowHeader((RTable)jComponent);
            jScrollPane.setRowHeaderView(lineNoRowHeader);
            jScrollPane.getRowHeader().setPreferredSize(lineNoRowHeader.getPreferredSize());
            switch (n) {
                case 2: {
                    ZInstance.map().put("List_Header", lineNoRowHeader);
                    break;
                }
                case 3: {
                    ZInstance.map().put("Resources_Header", lineNoRowHeader);
                    break;
                }
                case 4: {
                    ZInstance.map().put("Documents_Header", lineNoRowHeader);
                    break;
                }
                case 5: {
                    ZInstance.map().put("Page-Resource_Header", lineNoRowHeader);
                    break;
                }
                case 6: {
                    ZInstance.map().put("Links_Header", lineNoRowHeader);
                }
            }
        }
        jPanel.add("Center", jScrollPane);
        return jPanel;
    }

    protected JComponent createNorthComponent(int n) {
        JPanel jPanel = null;
        switch (n) {
            case 0: {
                jPanel = new RidZoneTitlePane();
                ZInstance.map().put("Zone.Title", jPanel);
                break;
            }
            case 1: {
                jPanel = new RidMapTitlePane();
                ZInstance.map().put("Map.Title", jPanel);
            }
        }
        return jPanel;
    }

    protected JComponent createCenterComponent(int n) {
        JComponent jComponent = null;
        switch (n) {
            case 0: {
                jComponent = new RidPane("Zone");
                ((RidPane)jComponent).setKeyMap(((RidPane)jComponent).createDefaultKeyMap(ZApp.getTheApp()));
                ZInstance.map().put("Zone", jComponent);
                break;
            }
            case 1: {
                jComponent = new RidPane("Map");
                ((RidPane)jComponent).setKeyMap(((RidPane)jComponent).createDefaultKeyMap(ZApp.getTheApp()));
                ZInstance.map().put("Map", jComponent);
                break;
            }
            case 2: {
                jComponent = new RTable("table.pages");
                ZInstance.map().put("List", jComponent);
                break;
            }
            case 3: {
                jComponent = new RTable("table.resources");
                ZInstance.map().put("Resources", jComponent);
                break;
            }
            case 4: {
                jComponent = new RTable("table.documents");
                ZInstance.map().put("Documents", jComponent);
                break;
            }
            case 5: {
                jComponent = new RTable("table.linkedpages");
                ZInstance.map().put("Page-Resource", jComponent);
                break;
            }
            case 6: {
                jComponent = new RTable("table.links");
                ZInstance.map().put("Links", jComponent);
                break;
            }
            case 7: {
                jComponent = new SearchPanel();
                ZInstance.map().put("Search", jComponent);
            }
        }
        return jComponent;
    }

    protected String getTabName(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "Zone";
                break;
            }
            case 1: {
                string = "Map";
                break;
            }
            case 2: {
                string = "List";
                break;
            }
            case 3: {
                string = "Resources";
                break;
            }
            case 4: {
                string = "Documents";
                break;
            }
            case 5: {
                string = "Page-Resource";
                break;
            }
            case 6: {
                string = "Links";
                break;
            }
            case 7: {
                string = "Search";
            }
        }
        return string;
    }

    protected String createProject() {
        Object object;
        String string;
        IZApp iZApp = ZApp.getTheApp();
        ZResource zResource = iZApp.getResource();
        this.mDialog = new UDialog(iZApp, "newproject");
        JTextField[] jTextFieldArray = new JTextField[9];
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        JPanel[] jPanelArray = new JPanel[4];
        JPanel jPanel = new JPanel(new BorderLayout(8, 8));
        jPanel.setBorder(new EmptyBorder(4, 4, 0, 4));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JLabel("Option:"), "North");
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel2.add((Component)jTabbedPane, "Center");
        jPanel.add((Component)jPanel2, "Center");
        jPanelArray[0] = new JPanel();
        jPanelArray[0].setLayout(gridBagLayout);
        jPanel.add((Component)jPanelArray[0], "North");
        jPanelArray[1] = new JPanel();
        jPanelArray[1].setLayout(gridBagLayout);
        jTabbedPane.add(zResource.getString("msg.newproject.project"), jPanelArray[1]);
        jPanelArray[2] = new JPanel();
        jPanelArray[2].setLayout(gridBagLayout);
        jTabbedPane.add(zResource.getString("msg.newproject.schedule"), jPanelArray[2]);
        jPanelArray[3] = new JPanel();
        jPanelArray[3].setLayout(gridBagLayout);
        jTabbedPane.add(zResource.getString("msg.newproject.member"), jPanelArray[3]);
        int n = 9;
        for (int i = 0; i < n; ++i) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 0.0;
            jPanelArray[panelIndexs[i]].add((Component)new JLabel(zResource.getString(label_keys[i])), gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 10.0;
            jTextFieldArray[i] = new JTextField(){

                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    if (dimension.width < 300) {
                        dimension.width = 300;
                    }
                    return dimension;
                }
            };
            jPanelArray[panelIndexs[i]].add((Component)jTextFieldArray[i], gridBagConstraints);
        }
        JPanel jPanel3 = new JPanel();
        AbstractAction abstractAction = null;
        abstractAction = new AbstractAction("OK"){

            public void actionPerformed(ActionEvent actionEvent) {
                RidApplication.this.mDialog.onOK();
            }
        };
        JButton jButton = new JButton(abstractAction);
        jButton.setText("OK");
        jPanel3.add(jButton);
        abstractAction = new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent actionEvent) {
                RidApplication.this.mDialog.onCancel();
            }
        };
        JButton jButton2 = new JButton(abstractAction);
        jButton2.setText("Cancel");
        jPanel3.add(jButton2);
        jPanel.add((Component)jPanel3, "South");
        this.mDialog.getRootPane().setDefaultButton(jButton);
        this.mDialog.setComponent(jPanel, false);
        String string2 = null;
        RidMessage ridMessage = new RidMessage();
        while (this.mDialog.doModal()) {
            string = jTextFieldArray[0].getText();
            if (string != null && string.length() > 0) {
                string2 = zResource.getString("app.install.path") + File.separator + zResource.getString("app.project.dir") + File.separator + string;
                object = new File(string2);
                if (((File)object).exists()) {
                    MessageDialog.showError(ridMessage.Error("E1020", string));
                    string2 = null;
                    continue;
                }
                if (((File)object).mkdirs()) break;
                MessageDialog.showError(ridMessage.Error("E1021", string));
                string2 = null;
                continue;
            }
            MessageDialog.showError(ridMessage.Error("E1022", ""));
            string2 = null;
        }
        if (string2 != null) {
            Object object2;
            Object object3;
            Object object4;
            String string3;
            int n2;
            try {
                string = zResource.getString("app.install.path") + File.separator + zResource.getString("app.template.dir");
                object = new xcopy();
                ((xcopy)object).copy(string, string2);
            }
            catch (Exception exception) {
                ZDebug.err("Directory copy failed:" + string2);
                exception.printStackTrace();
                return null;
            }
            string = "mapper";
            object = (DocDocument)((Object)DocManager.createDocument(string));
            ((DocDocument)((Object)object)).setDocumentId(string);
            ((DocDocument)((Object)object)).initDocument();
            Element element = object.getDocumentElement();
            for (n2 = 1; n2 < n; ++n2) {
                string3 = null;
                switch (n2) {
                    case 1: {
                        string3 = "Abbreviation";
                        break;
                    }
                    case 2: {
                        string3 = "Formal";
                        break;
                    }
                    case 3: {
                        string3 = "Purpose";
                        break;
                    }
                    case 4: {
                        string3 = "Comment";
                        break;
                    }
                    case 5: {
                        string3 = "Start";
                        break;
                    }
                    case 6: {
                        string3 = "CutOver";
                        break;
                    }
                    case 7: {
                        string3 = "Leader";
                        break;
                    }
                    case 8: {
                        string3 = "Member";
                    }
                }
                object4 = ((DocDocument)((Object)object)).createElement(string3);
                object3 = jTextFieldArray[n2].getText();
                if (object3 == null || ((String)object3).length() == 0) {
                    object3 = "<!-- no data -->";
                }
                object2 = ((XDocument)((Object)object)).createTextNode((String)object3);
                element.appendChild((Node)object4);
                object4.appendChild((Node)object2);
            }
            n2 = 0;
            string3 = string2 + File.separator + zResource.getString("rid.template.dir") + File.separator + "_project.html";
            object4 = string2 + File.separator + zResource.getString("rid.plan.dir") + File.separator + "project.html";
            try {
                object3 = new Mapper();
                n2 = ((Mapper)object3).Type2(string3, (Document)object, (String)object4) ? 1 : 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n2 != 0) {
                object3 = zResource.getString("command.html.editor");
                if (zResource.getBoolean("newproject.edit.html", true) && object3 != null && !RidExecAction.exec((String)object3, (String)object4)) {
                    MessageDialog.showError(ridMessage.Error("E1901", (String)object3 + " " + (String)object4));
                }
            } else {
                MessageDialog.showError(ridMessage.Error("E1021", (String)object4));
            }
            object3 = zResource.getString("rid.data.dir");
            object2 = zResource.getString("rid.site.xml");
            return string2 + File.separator + (String)object3 + File.separator + (String)object2;
        }
        return null;
    }

    protected DocDocument createDocument(String string) {
        String string2 = string.substring(9);
        DocDocument docDocument = (DocDocument)((Object)DocManager.createDocument(string2));
        docDocument.setDocumentId(string2);
        docDocument.initDocument();
        ZInstance.map().put(string, docDocument);
        return docDocument;
    }

    protected DocDocument loadDocument(String string, String string2) {
        String string3 = string.substring(9);
        String string4 = DocManager.getClassName("document", string3);
        try {
            DOMParser dOMParser = new DOMParser();
            dOMParser.setProperty("http://apache.org/xml/properties/dom/document-class-name", (Object)string4);
            dOMParser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            InputSource inputSource = DocManager.createInputSource(string2);
            dOMParser.parse(inputSource);
            DocDocument docDocument = (DocDocument)((Object)dOMParser.getDocument());
            docDocument.setDocumentId(string3);
            return docDocument;
        }
        catch (Throwable throwable) {
            ZDebug.err("FileOpen failed:" + string2);
            ZDebug.err("    " + throwable.toString());
            RidMessage ridMessage = new RidMessage();
            MessageDialog.showError(ridMessage.Error("E1100", string2));
            return this.createDocument(string);
        }
    }

    protected void updateDocument() {
        SearchPanel searchPanel;
        DocPane docPane = null;
        DocDocument docDocument = (DocDocument)((Object)ZInstance.map().get("document.site"));
        docPane = (DocPane)ZInstance.map().get("Zone");
        if (docPane != null) {
            docPane.setDocument(docDocument);
        }
        if ((docPane = (DocPane)ZInstance.map().get("Map")) != null) {
            docPane.setDocument(docDocument);
        }
        if (docPane != null) {
            RUpdateManager.update(0);
        }
        if ((searchPanel = (SearchPanel)ZInstance.map().get("Search")) != null) {
            searchPanel.init();
        }
    }

    protected void fileChanged() {
        super.fileChanged();
        ZResource zResource = ZApp.getTheApp().getResource();
        String string = zResource.getString("rid.data.dir");
        String string2 = this.getFileName();
        if (string2 != null) {
            String string3 = ZFile.getParent(this.getFileName());
            if (string3.endsWith(string)) {
                String string4 = string3.substring(0, string3.length() - string.length() - 1);
                ZInstance.prop().setProperty("pj.dir", string4);
            } else {
                ZDebug.trace("invalid dir:" + string3);
                ZInstance.prop().remove("pj.dir");
            }
        } else {
            ZDebug.trace("unsaved");
            ZInstance.prop().remove("pj.dir");
        }
    }

    protected DocDocument saveDocument(DocDocument docDocument, String string) {
        try {
            String string2 = docDocument.getEncoding();
            boolean bl = docDocument.getIndenting();
            OutputFormat outputFormat = new OutputFormat((Document)((Object)docDocument), string2, bl);
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            DOMSerializer dOMSerializer = new XMLSerializer((OutputStream)fileOutputStream, outputFormat).asDOMSerializer();
            dOMSerializer.serialize((Document)((Object)docDocument));
            docDocument.setModified();
            return docDocument;
        }
        catch (Throwable throwable) {
            ZDebug.err("FileSave failed:" + string);
            throwable.printStackTrace();
            RidMessage ridMessage = new RidMessage();
            MessageDialog.showError(ridMessage.Error("E1110", string));
            return null;
        }
    }

    protected void savePages() {
    }

    protected class ScrollAdapter
    implements ChangeListener {
        protected ScrollAdapter() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            DocPane docPane = (DocPane)((JViewport)changeEvent.getSource()).getView();
            DocDocument docDocument = docPane.getDocument();
            boolean bl = docDocument.isTransaction();
            if (!bl) {
                docDocument.beginTransaction();
            }
            docPane.updateCenter();
            if (!bl) {
                docDocument.commit();
            }
            RUpdateManager.update(512);
        }
    }

    protected class TabAdapter
    implements ChangeListener {
        protected int mPrevTab = -1;

        protected TabAdapter() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() instanceof JTabbedPane) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                this.mPrevTab = jTabbedPane.getSelectedIndex();
                String string = jTabbedPane.getTitleAt(this.mPrevTab);
                ZInstance.prop().setProperty("panel.active", string);
                if (this.mPrevTab == 1) {
                    DocPane docPane = (DocPane)ZInstance.map().get(string);
                    RidElementZone ridElementZone = ((RidDocumentSite)docPane.getDocument()).getTopZone();
                    Vector vector = ridElementZone.getZones(true);
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        RidElementZone ridElementZone2 = (RidElementZone)enumeration.nextElement();
                        if (!ridElementZone2.isSelect()) continue;
                        ridElementZone2.setSelect(null, false);
                    }
                }
                RUpdateManager.update(0);
            }
        }
    }
}

