/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.analyzer;

import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;
import jp.co.nri.rid.analyzer.iExceptionCode;
import jp.co.nri.rid.error.RidException;
import jp.co.nri.rid.error.RidMessage;
import jp.co.nri.rid.table.editor.filter.ExtensionFilter;
import jp.co.nri.rid.xml.elementBooster;

public class FileNameStudio
implements iExceptionCode {
    private static final String DELIM_FILE = "/\\";
    private static final String DELIM_CONTENT = ";";
    private static final String DELIM_CONTENTURL = "=";
    private static final String SEPARATOR = "/";
    private static final String ZONEUNIT = "ZoneUnit";
    private static final String NAME = "Name";
    private static final String FILE = "File";
    private static final String CREATOR = "Creator";
    private static final String EXIST = "Exist";
    private static final String FALSE = "false";
    private static final String HIT = ".hit";
    private static final String WITHOUT = "without";
    private static final String WILD = "*";
    private static final String[] URLHEADERS = new String[]{"http://", "https://", "ftp://", "file://", "mail://", "news://", "mailto:", "telto:", "tel:", " "};
    private static final String[] SKIPHEADERS = new String[]{"#", "?", "javascript:"};
    private static final char[] URLCHARS = new char[]{':', ';', '*', '\"', '<', '>', '|', '#'};
    private static final String[] ACTIVEHEADERS = new String[]{"<%", "<?", "<cfoutput>"};
    private static ExtensionFilter filterStatic = null;
    private static ExtensionFilter filterDynamic = null;
    private static ExtensionFilter filterResource = null;

    public static boolean isURL(String string) {
        int n;
        String string2 = string.toLowerCase();
        int n2 = URLHEADERS.length;
        for (n = 0; n < n2; ++n) {
            if (!string2.startsWith(URLHEADERS[n])) continue;
            return true;
        }
        n2 = URLCHARS.length;
        for (n = 0; n < n2; ++n) {
            if (0 > string2.indexOf(URLCHARS[n])) continue;
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM_FILE);
        for (int i = stringTokenizer.countTokens() - 1; 0 <= i; --i) {
            String string3 = stringTokenizer.nextToken();
            if (string3.startsWith(" ")) {
                return true;
            }
            if (!string3.startsWith(".") || string3.equals("..") || string3.equals(".")) continue;
            return true;
        }
        return false;
    }

    public static boolean checkForSWF(String string) throws RidException {
        String string2 = string.toLowerCase();
        if (string2.startsWith("fscommand:")) {
            return false;
        }
        if (string.endsWith(SEPARATOR)) {
            return true;
        }
        if (FileNameStudio.isStaticPage(string)) {
            return true;
        }
        if (FileNameStudio.isDynamicPage(string)) {
            return true;
        }
        if (FileNameStudio.isResource(string)) {
            return true;
        }
        int n = URLHEADERS.length;
        for (int i = 0; i < n; ++i) {
            if (!string2.startsWith(URLHEADERS[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isStaticPage(String string) throws RidException {
        try {
            return filterStatic.hit(string);
        }
        catch (NullPointerException nullPointerException) {
            filterStatic = FileNameStudio.filter("import.page.extensions.static");
            return filterStatic.hit(string);
        }
    }

    public static boolean isDynamicPage(String string) throws RidException {
        try {
            return filterDynamic.hit(string);
        }
        catch (NullPointerException nullPointerException) {
            filterDynamic = FileNameStudio.filter("import.page.extensions.dynamic");
            return filterDynamic.hit(string);
        }
    }

    public static boolean isZone(String string) {
        return 0 > string.indexOf(".");
    }

    public static boolean isResource(String string) throws RidException {
        try {
            return filterResource.hit(string);
        }
        catch (NullPointerException nullPointerException) {
            filterResource = FileNameStudio.filter("import.resource.extensions");
            return filterResource.hit(string);
        }
    }

    public static boolean skip(String string) {
        String string2 = string.toLowerCase();
        int n = SKIPHEADERS.length;
        for (int i = 0; i < n; ++i) {
            if (!string2.startsWith(SKIPHEADERS[i])) continue;
            return true;
        }
        return false;
    }

    public static String getMetaContentLink(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM_CONTENT);
        for (int i = stringTokenizer.countTokens() - 1; 0 <= i; --i) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), DELIM_CONTENTURL);
            int n = stringTokenizer2.countTokens();
            if (2 != n || !"url".equalsIgnoreCase(stringTokenizer2.nextToken())) continue;
            return stringTokenizer2.nextToken();
        }
        return null;
    }

    private static int indexOfEx(String string, String[] stringArray) {
        int n = -1;
        for (int i = stringArray.length - 1; 0 <= i; --i) {
            int n2 = string.indexOf(stringArray[i]);
            n = FileNameStudio.ix(n, n2);
        }
        return n;
    }

    private static int indexOfEx(String string, char[] cArray) {
        int n = -1;
        for (int i = cArray.length - 1; 0 <= i; --i) {
            int n2 = string.indexOf(cArray[i]);
            n = FileNameStudio.ix(n, n2);
        }
        return n;
    }

    private static int ix(int n, int n2) {
        if (0 <= n && 0 <= n2) {
            return n < n2 ? n : n2;
        }
        return n > n2 ? n : n2;
    }

    private static String cutParam(String string) {
        int n;
        int n2 = FileNameStudio.indexOfEx(string, ACTIVEHEADERS);
        int n3 = -1;
        int n4 = string.indexOf(35);
        if (0 <= n4 && 0 > (n = string.indexOf(35, n4 + 1))) {
            n3 = n4;
        }
        n = string.indexOf(63);
        if (0 > n3) {
            if (0 <= n4) {
                if (0 > n2) {
                    n2 = n4;
                } else if (n4 < n2) {
                    n2 = n4;
                }
            }
        } else if (0 > n) {
            n = n3;
        } else if (n3 < n) {
            n = n3;
        }
        if (0 > n) {
            if (0 > n2) {
                return string;
            }
            return null;
        }
        if (0 <= n2 && n2 < n) {
            return null;
        }
        return string.substring(0, n);
    }

    private static int indexOfCgiSp(String string) {
        char[] cArray = string.toCharArray();
        int n = 65535;
        int n2 = cArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = cArray[i];
            if (63 == n3 && 60 != n) {
                try {
                    if ('>' != cArray[i + 1]) {
                        return i;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return i;
                }
            }
            n = n3;
        }
        return -1;
    }

    public static String cutParamForUrlUnit(String string) {
        int n;
        int n2;
        int n3 = -1;
        int n4 = string.indexOf(35);
        if (0 <= n4 && 0 > (n2 = string.indexOf(35, n4 + 1))) {
            n3 = n4;
        }
        if (0 > (n = FileNameStudio.ix(n3, n2 = FileNameStudio.indexOfCgiSp(string)))) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String filename(String string) {
        try {
            String[] stringArray = FileNameStudio.token(string, DELIM_FILE);
            return FileNameStudio.cutParam(stringArray[stringArray.length - 1]);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static String pureURL(String string) {
        return FileNameStudio.cutParam(string);
    }

    public static String zonename(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM_FILE);
        int n = stringTokenizer.countTokens() - 1;
        if (0 >= n) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(stringTokenizer.nextToken());
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString();
    }

    public static String zonename(String string, String string2) {
        String[] stringArray = null;
        Vector<Object> vector = null;
        try {
            stringArray = FileNameStudio.token(string, DELIM_FILE);
            vector = new Vector<String>(Arrays.asList(stringArray));
        }
        catch (NullPointerException nullPointerException) {
            vector = new Vector();
        }
        StringTokenizer stringTokenizer = null;
        try {
            stringTokenizer = new StringTokenizer(string2, DELIM_FILE);
        }
        catch (NullPointerException nullPointerException) {
            if (0 < vector.size()) {
                return string;
            }
            return null;
        }
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            String string3 = stringTokenizer.nextToken();
            if ("..".equals(string3)) {
                int n2 = vector.size();
                if (0 >= n2) {
                    return null;
                }
                vector.removeElementAt(n2 - 1);
                continue;
            }
            if (".".equals(string3)) continue;
            vector.add(string3);
        }
        return FileNameStudio.zonename(vector.toArray(new String[0]));
    }

    public static String zonename(String[] stringArray) {
        int n = stringArray.length;
        if (0 >= n) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String page(String string) {
        if (null == string) {
            return null;
        }
        if (string.endsWith(SEPARATOR)) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM_FILE);
        int n = stringTokenizer.countTokens() - 1;
        for (int i = 0; i < n; ++i) {
            stringTokenizer.nextToken();
        }
        return stringTokenizer.nextToken();
    }

    public static String fusion(String string, String string2) throws ArrayIndexOutOfBoundsException {
        int n;
        CharSequence charSequence;
        int n2;
        Vector<String> vector = null;
        String string3 = FileNameStudio.cutParam(string2);
        if (null == string3) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM_FILE);
        int n3 = stringTokenizer.countTokens() - 1;
        if (0 < n3) {
            vector = new Vector(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                vector.add(stringTokenizer.nextToken());
            }
        } else {
            vector = new Vector<String>();
        }
        stringTokenizer = new StringTokenizer(string3, DELIM_FILE);
        n3 = stringTokenizer.countTokens();
        for (n2 = 0; n2 < n3; ++n2) {
            charSequence = stringTokenizer.nextToken();
            if ("..".equals(charSequence)) {
                n = vector.size();
                vector.removeElementAt(n - 1);
                continue;
            }
            if (".".equals(charSequence)) continue;
            vector.add((String)charSequence);
        }
        String[] stringArray = vector.toArray(new String[0]);
        n3 = stringArray.length;
        if (n3 <= 0) {
            return null;
        }
        charSequence = new StringBuffer(stringArray[0]);
        for (n = 1; n < n3; ++n) {
            ((StringBuffer)charSequence).append(SEPARATOR);
            ((StringBuffer)charSequence).append(stringArray[n]);
        }
        if (string3.endsWith(SEPARATOR)) {
            ((StringBuffer)charSequence).append(SEPARATOR);
        }
        return ((StringBuffer)charSequence).toString();
    }

    public static String simplefusion(String string, String string2) {
        CharSequence charSequence;
        int n;
        Vector<String> vector = null;
        String string3 = FileNameStudio.cutParam(string2);
        if (null == string3) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM_FILE);
        int n2 = stringTokenizer.countTokens() - 1;
        if (0 < n2) {
            vector = new Vector(n2);
            for (n = 0; n < n2; ++n) {
                vector.add(stringTokenizer.nextToken());
            }
        } else {
            vector = new Vector<String>();
        }
        stringTokenizer = new StringTokenizer(string3, DELIM_FILE);
        n2 = stringTokenizer.countTokens();
        for (n = 0; n < n2; ++n) {
            charSequence = stringTokenizer.nextToken();
            vector.add((String)charSequence);
        }
        String[] stringArray = vector.toArray(new String[0]);
        n2 = stringArray.length;
        if (n2 <= 0) {
            return null;
        }
        charSequence = new StringBuffer(stringArray[0]);
        for (int i = 1; i < n2; ++i) {
            ((StringBuffer)charSequence).append(SEPARATOR);
            ((StringBuffer)charSequence).append(stringArray[i]);
        }
        return ((StringBuffer)charSequence).toString();
    }

    public static String[] token(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        if (0 >= n) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static elementBooster zone(elementBooster elementBooster2, String string, String string2) {
        elementBooster elementBooster3 = elementBooster2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM_FILE);
        int n = stringTokenizer.countTokens() - 1;
        if (0 >= n) {
            return elementBooster3;
        }
        String string3 = stringTokenizer.nextToken();
        StringBuffer stringBuffer = new StringBuffer(string3);
        if ((elementBooster3 = FileNameStudio.zoneunit(elementBooster3, stringBuffer.toString(), string3, string2)) == null) {
            return null;
        }
        for (int i = 1; i < n; ++i) {
            string3 = stringTokenizer.nextToken();
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(string3);
            elementBooster3 = FileNameStudio.zoneunit(elementBooster3, stringBuffer.toString(), string3, string2);
            if (elementBooster3 != null) continue;
            return null;
        }
        return elementBooster3;
    }

    public static elementBooster zoneunit(elementBooster elementBooster2, String string, String string2, String string3) {
        elementBooster[] elementBoosterArray = elementBooster2.children();
        int n = 0;
        if (null != elementBoosterArray) {
            n = elementBoosterArray.length;
        }
        for (int i = 0; i < n; ++i) {
            String string4 = elementBoosterArray[i].attribute(FILE);
            if (!string.equalsIgnoreCase(string4)) continue;
            if (elementBoosterArray[i].tagname().equals(ZONEUNIT)) {
                return elementBoosterArray[i];
            }
            return null;
        }
        elementBooster elementBooster3 = elementBooster2.add(ZONEUNIT);
        elementBooster3.attribute(NAME, string2);
        elementBooster3.attribute(CREATOR, string3);
        elementBooster3.attribute(EXIST, FALSE);
        return elementBooster3;
    }

    public static elementBooster unit(elementBooster elementBooster2, String string, String string2, String string3) {
        elementBooster[] elementBoosterArray = elementBooster2.offspring(string);
        if (null == elementBoosterArray) {
            return null;
        }
        int n = elementBoosterArray.length;
        for (int i = 0; i < n; ++i) {
            String string4 = elementBoosterArray[i].attribute(string2);
            if (!string3.equalsIgnoreCase(string4)) continue;
            return elementBoosterArray[i];
        }
        return null;
    }

    private static ExtensionFilter filter(String string) throws RidException {
        ZProperties zProperties = DocManager.loadProperty("element");
        String string2 = zProperties.getProperty(string);
        if (null == string2) {
            throw new RidException(new RidMessage().Error("E2010", string));
        }
        ExtensionFilter extensionFilter = null;
        extensionFilter = WILD.equals(string2) ? new ExtensionFilter() : new ExtensionFilter(ZString.tokenize(string2));
        String string3 = zProperties.getProperty(string + HIT);
        if (WITHOUT.equals(string3)) {
            extensionFilter.hit = false;
        }
        return extensionFilter;
    }
}

