/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid.action;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.action.ZAction;
import jp.co.iti.fagot.util.ZResource;
import jp.co.nri.Ridual;
import jp.co.nri.rid.doc.RidExecAction;
import jp.co.nri.rid.environment.MessageDialog;
import jp.co.nri.rid.error.RidMessage;

public class RidHelpAction
extends ZAction {
    public static final String VERSION = "version";
    public static final String LICENSE = "license";
    public static final String HELPDOC = "helpdoc";

    public RidHelpAction(IZApp iZApp, String string) {
        super(iZApp, string);
    }

    public void doAction(ActionEvent actionEvent) {
        if (this.getActionName().equals(VERSION)) {
            ((Ridual)this.getApp()).showVersion();
        } else if (this.getActionName().equals(HELPDOC)) {
            ZResource zResource = this.getApp().getResource();
            String string = zResource.getString("generate.browser_command");
            String string2 = zResource.getString("app.install.path") + File.separator + "help" + File.separator + "index.html";
            try {
                string2 = new File(string2).toURL().toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            if (string != null && !RidExecAction.exec(string, string2)) {
                RidMessage ridMessage = new RidMessage();
                MessageDialog.showError(ridMessage.Error("E1901", string + " " + string2));
            }
        } else if (this.getActionName().equals(LICENSE)) {
            new LicenseDialog().show();
        }
    }

    public void update() {
    }

    private class LicenseDialog
    extends JDialog {
        public JTextField name = new JTextField();
        public JTextField mail = new JTextField();
        private GridBagConstraints constraints = new GridBagConstraints();
        private GridBagLayout gridbag = new GridBagLayout();

        public LicenseDialog() {
            super(RidHelpAction.this.getApp().getFrame());
            ZResource zResource = RidHelpAction.this.getApp().getResource();
            this.setTitle(zResource.getString("msg.license.title"));
            JPanel jPanel = new JPanel(this.gridbag);
            jPanel.setBorder(new EmptyBorder(6, 4, 0, 4));
            this.addCaptionedComponent(jPanel, zResource.getString("msg.license.name"), this.name);
            this.addCaptionedComponent(jPanel, zResource.getString("msg.license.mail"), this.mail);
            JPanel jPanel2 = new JPanel();
            jPanel2.add(new JButton(new OkAction()));
            jPanel2.add(new JButton(new CancelAction()));
            this.addButtonsComponent(jPanel, jPanel2);
            this.getContentPane().add((Component)jPanel, "Center");
        }

        public void show() {
            ZResource zResource = RidHelpAction.this.getApp().getResource();
            this.name.setText(zResource.getString("license.name"));
            this.mail.setText(zResource.getString("license.mail"));
            super.show();
            this.pack();
            Dimension dimension = this.getToolkit().getScreenSize();
            this.setLocation(dimension.width / 2 - this.getWidth() / 2, dimension.height / 2 - this.getHeight() / 2);
        }

        private void addCaptionedComponent(JPanel jPanel, String string, Component component) {
            this.addConstraintsComponent(jPanel, new JLabel(string), 1);
            this.constraints.weightx = 1.0;
            this.constraints.fill = 2;
            this.addConstraintsComponent(jPanel, component, 0);
            this.constraints.weightx = 0.0;
            this.constraints.fill = 0;
        }

        private void addButtonsComponent(JPanel jPanel, Component component) {
            this.constraints.weightx = 1.0;
            this.constraints.fill = 2;
            this.constraints.insets = new Insets(0, 32, 0, 32);
            this.addConstraintsComponent(jPanel, component, 0);
            this.constraints.weightx = 0.0;
            this.constraints.fill = 0;
        }

        private void addConstraintsComponent(JPanel jPanel, Component component, int n) {
            this.constraints.gridwidth = n;
            this.gridbag.setConstraints(component, this.constraints);
            jPanel.add(component);
        }

        private class CancelAction
        extends AbstractAction {
            public CancelAction() {
                super("cancel");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                LicenseDialog.this.dispose();
            }
        }

        private class OkAction
        extends AbstractAction {
            public OkAction() {
                super("OK");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                LicenseDialog.this.dispose();
                ZResource zResource = RidHelpAction.this.getApp().getResource();
                zResource.putString("license.name", LicenseDialog.this.name.getText());
                zResource.putString("license.mail", LicenseDialog.this.mail.getText());
            }
        }
    }
}

