/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.rid;

import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.KeyStroke;
import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;
import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GobManager;
import jp.co.iti.fagot.util.ZKeyMap;
import jp.co.nri.rid.RUpdateManager;
import jp.co.nri.rid.doc.RidDocument;
import jp.co.nri.rid.doc.RidDocumentSite;
import jp.co.nri.rid.doc.RidElementZone;

public class RidPane
extends DocPane {
    public RidPane(String string) {
        super(string);
        this.setToolTipText(string);
    }

    public void createGobs() {
        RidDocumentSite ridDocumentSite;
        String string = this.getPanelId();
        if (string.startsWith("Map") && (ridDocumentSite = (RidDocumentSite)this.getDocument()) != null) {
            DocElement docElement = (DocElement)((Object)ridDocumentSite.getRootElement(string));
            if (docElement == null) {
                return;
            }
            DocElement docElement2 = (DocElement)docElement.getChildElement(".ViewInfo." + string, null);
            String string2 = docElement2.getAttribute("Calc");
            if (string2.length() == 0 || string2.equals("none")) {
                boolean bl = true;
                if (string.endsWith("Circle")) {
                    bl = false;
                }
                ZRectangle zRectangle = ridDocumentSite.recalcMap(string, bl);
                docElement2.setAttribute("Calc", "done");
                if (zRectangle != null) {
                    this.updateLayout();
                    this.repaint();
                    return;
                }
            }
        }
        super.createGobs();
        RUpdateManager.update(768);
    }

    public String getPanelId() {
        DocDocument docDocument;
        String string = super.getPanelId();
        if (string.equals("Map") && (docDocument = this.getDocument()) != null) {
            RidElementZone ridElementZone = ((RidDocument)docDocument).getTopZone();
            String string2 = ridElementZone.getChildElementAttribute(".ViewInfo.Map", null, "Active");
            string = string2.length() > 0 ? string + "." + string2 : string + ".Site";
        }
        return string;
    }

    public Vector createDefaultKeyMap(IZApp iZApp) {
        Vector<ZKeyMap> vector = new Vector<ZKeyMap>();
        vector.add(new ZKeyMap(KeyStroke.getKeyStroke(127, 0, false), iZApp.getAction("cut")));
        vector.add(new ZKeyMap(KeyStroke.getKeyStroke(88, 2), iZApp.getAction("cut")));
        vector.add(new ZKeyMap(KeyStroke.getKeyStroke(78, 2), iZApp.getAction("new")));
        vector.add(new ZKeyMap(KeyStroke.getKeyStroke(83, 2), iZApp.getAction("save")));
        vector.add(new ZKeyMap(KeyStroke.getKeyStroke(79, 2), iZApp.getAction("open")));
        vector.add(new ZKeyMap(KeyStroke.getKeyStroke(90, 2), iZApp.getAction("undo")));
        vector.add(new ZKeyMap(KeyStroke.getKeyStroke(90, 3), iZApp.getAction("redo")));
        return vector;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        ZPoint zPoint = new ZPoint(mouseEvent.getPoint());
        GElement gElement = GobManager.getCurrentHitElement(this, zPoint);
        if (gElement == null) {
            gElement = GobManager.getHitElement(this, zPoint);
        }
        if (gElement != null && gElement.getContainer() != null) {
            DocElement docElement = (DocElement)gElement.getContainer();
            String string = docElement.getAttribute("Key");
            if (string.length() == 0) {
                string = docElement.getTagName();
            }
            return string;
        }
        return null;
    }
}

