/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.ui;

import java.awt.Window;
import java.util.Vector;
import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.ui.UDialog;
import jp.co.iti.fagot.ui.UFrame;
import jp.co.iti.fagot.util.ZResource;

public class UWindowManager {
    protected IZApp mApp = null;
    protected Window[] mChildren = null;
    protected static final String RES_PREFIX = "app.childWindow.";
    protected boolean mEnableWindow = false;

    public UWindowManager(IZApp iZApp, int n) {
        this.mApp = iZApp;
        this.mChildren = new Window[n];
    }

    public Window createWindow(int n) {
        return null;
    }

    public void updateWindow(int n) {
    }

    public void openWindow() {
        if (!this.mEnableWindow) {
            for (int i = 0; i < this.getWindowCount(); ++i) {
                if (!this.getResource().getBoolean(RES_PREFIX + i)) continue;
                this.setVisible(i, true);
            }
            this.mEnableWindow = true;
        }
    }

    public void setVisible(int n, boolean bl) {
        if (bl) {
            if (this.getWindow(n) == null) {
                this.mChildren[n] = this.createWindow(n);
            }
            this.updateWindow(n);
        }
        this.getWindow(n).setVisible(bl);
    }

    public boolean isVisible(int n) {
        boolean bl = true;
        bl = this.getWindow(n) == null ? false : this.getWindow(n).isVisible();
        return bl;
    }

    public Window getWindow(int n) {
        return this.mChildren[n];
    }

    public Vector getWindows() {
        Vector<Window> vector = new Vector<Window>();
        for (int i = 0; i < this.getWindowCount(); ++i) {
            Window window = this.getWindow(i);
            if (window == null) continue;
            vector.add(window);
        }
        return vector;
    }

    public void closeWindow() {
        if (this.mEnableWindow) {
            for (int i = 0; i < this.getWindowCount(); ++i) {
                Window window = this.getWindow(i);
                if (window == null) continue;
                boolean bl = this.isVisible(i);
                this.getResource().putString(RES_PREFIX + i, bl ? "true" : "false");
                if (!bl) continue;
                String string = null;
                if (window instanceof UFrame) {
                    string = ((UFrame)window).getFrameName();
                } else if (window instanceof UDialog) {
                    string = ((UDialog)window).getDialogName();
                }
                if (string != null) {
                    this.getResource().saveGeometry(window, string);
                }
                this.setVisible(i, false);
            }
            this.mEnableWindow = false;
        }
    }

    public boolean isEnable(int n) {
        return this.mEnableWindow;
    }

    public IZApp getApp() {
        return this.mApp;
    }

    public ZResource getResource() {
        ZResource zResource = null;
        if (this.getApp() != null) {
            zResource = this.getApp().getResource();
        }
        return zResource;
    }

    public int getWindowCount() {
        int n = 0;
        if (this.mChildren != null) {
            n = this.mChildren.length;
        }
        return n;
    }
}

