/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.gob;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.util.Enumeration;
import java.util.Vector;
import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocGraphics;
import jp.co.iti.fagot.doc.DocGridControler;
import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;
import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.PTransform;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZReverseEnumeration;

public class GobManager {
    public static final String CURRENT = ".current";
    public static final String ALL = ".all";
    public static final String HIGHLIGHT = ".highlight";
    public static final String ELEMENTS = ".elements";

    public static void setCurrent(String string, GElement gElement) {
        Vector vector = GobManager.list(string, CURRENT);
        vector.removeAllElements();
        if (gElement != null) {
            vector.add(gElement);
        }
    }

    public static void addCurrent(String string, GElement gElement) {
        Vector vector = GobManager.list(string, CURRENT);
        if (gElement != null) {
            vector.add(gElement);
        }
    }

    public static void updateCurrent(String string) {
        ZInstance.setList(string + CURRENT + ELEMENTS, GobManager.getSelectedElement(string));
    }

    public static Vector getCurrent(String string) {
        return GobManager.list(string, CURRENT);
    }

    public static Vector getElement(String string) {
        return GobManager.list(string, ALL);
    }

    public static Vector getSelectedElement(String string) {
        Vector<GElement> vector = new Vector<GElement>();
        Enumeration enumeration = GobManager.list(string, ALL).elements();
        while (enumeration.hasMoreElements()) {
            GElement gElement = (GElement)enumeration.nextElement();
            if (!gElement.isSelect()) continue;
            vector.add(gElement);
        }
        return vector;
    }

    public static byte getSelectedHitMode(DocPane docPane, ZPoint zPoint) {
        String string = docPane.getPanelId();
        ZPoint zPoint2 = GobManager.transrateRootTransform(docPane, zPoint);
        byte by = 0;
        int n = 0;
        Enumeration enumeration = GobManager.elements(string, ALL);
        while (enumeration.hasMoreElements()) {
            GElement gElement = (GElement)enumeration.nextElement();
            if (!gElement.isSelect()) continue;
            ++n;
            byte by2 = gElement.getHitMode(zPoint2);
            if (by2 == 0) continue;
            by = by2;
        }
        if (by != 0 && n > 1) {
            by = 1;
        }
        return by;
    }

    public static byte getSelectedPreMoveMode(DocPane docPane, ZPoint zPoint) {
        String string = docPane.getPanelId();
        ZPoint zPoint2 = GobManager.transrateRootTransform(docPane, zPoint);
        byte by = 0;
        int n = 0;
        Enumeration enumeration = GobManager.elements(string, ALL);
        while (enumeration.hasMoreElements()) {
            GElement gElement = (GElement)enumeration.nextElement();
            if (!gElement.isSelect()) continue;
            ++n;
            byte by2 = gElement.getPreMoveMode(zPoint2);
            if (by2 == 0) continue;
            by = by2;
        }
        if (by != 0 && n > 1) {
            by = 1;
        }
        return by;
    }

    public static void setCurrentSelect(String string, boolean bl) {
        GobManager.setSelect(string, CURRENT, bl);
    }

    public static void setSelect(String string, boolean bl) {
        GobManager.setSelect(string, ALL, bl);
    }

    public static void setSelect(String string, String string2, boolean bl) {
        Enumeration enumeration = GobManager.elements(string, string2);
        while (enumeration.hasMoreElements()) {
            GElement gElement = (GElement)enumeration.nextElement();
            gElement.setSelect(bl);
        }
    }

    public static GElement getCurrentHitElement(DocPane docPane, ZPoint zPoint) {
        return GobManager.getHitElement(docPane, CURRENT, zPoint);
    }

    public static GElement getHitElement(DocPane docPane, ZPoint zPoint) {
        return GobManager.getHitElement(docPane, ALL, zPoint);
    }

    public static GElement getHitElement(DocPane docPane, String string, ZPoint zPoint) {
        String string2 = docPane.getPanelId();
        ZPoint zPoint2 = GobManager.transrateRootTransform(docPane, zPoint);
        Enumeration enumeration = GobManager.r_elements(string2, string);
        while (enumeration.hasMoreElements()) {
            GElement gElement = (GElement)enumeration.nextElement();
            byte by = gElement.getHitMode(zPoint2);
            if (by == 0) continue;
            return gElement;
        }
        return null;
    }

    public static void moveStart(DocPane docPane, DocGridControler docGridControler) {
        String string = docPane.getPanelId();
        GobManager.pushRootTransform(docPane, docGridControler);
        Enumeration enumeration = GobManager.elements(string, CURRENT);
        while (enumeration.hasMoreElements()) {
            GElement gElement = (GElement)enumeration.nextElement();
            gElement.moveStart(docGridControler);
        }
        docGridControler.popTransform();
    }

    public static void moveEnd(DocPane docPane, DocGridControler docGridControler) {
        String string = docPane.getPanelId();
        GobManager.pushRootTransform(docPane, docGridControler);
        Enumeration enumeration = GobManager.elements(string, CURRENT);
        while (enumeration.hasMoreElements()) {
            GElement gElement = (GElement)enumeration.nextElement();
            gElement.moveEnd(docGridControler);
        }
        docGridControler.popTransform();
    }

    public static void paint(DocPane docPane, DocGraphics docGraphics) {
        String string = docPane.getPanelId();
        GobManager.pushRootTransform(docPane, docGraphics.getGridControler());
        Enumeration enumeration = GobManager.elements(string, ALL);
        while (enumeration.hasMoreElements()) {
            GElement gElement = (GElement)enumeration.nextElement();
            gElement.paint(docGraphics);
        }
        docGraphics.getGridControler().popTransform();
    }

    public static void paintCurrent(DocPane docPane, DocGraphics docGraphics) {
        Object object;
        Object object2;
        boolean bl;
        String string = docPane.getPanelId();
        GobManager.pushRootTransform(docPane, docGraphics.getGridControler());
        boolean bl2 = bl = GobManager.size(string, CURRENT) != 0;
        if (bl) {
            docGraphics.getGraphics().setXORMode(Color.black);
            object2 = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{3.0f, 3.0f}, 0.0f);
            docGraphics.getGraphics().setStroke((Stroke)object2);
            object = GobManager.elements(string, CURRENT);
            while (object.hasMoreElements()) {
                GElement gElement = (GElement)object.nextElement();
                gElement.paintDrag(docGraphics);
            }
            docGraphics.getGraphics().setPaintMode();
        } else {
            object2 = GobManager.getSelectedElement(string).elements();
            while (object2.hasMoreElements()) {
                object = (GElement)object2.nextElement();
                ((GElement)object).paintSelector(docGraphics);
            }
        }
        object2 = GobManager.elements(string, HIGHLIGHT);
        while (object2.hasMoreElements()) {
            object = (GElement)object2.nextElement();
            ((GElement)object).paint(docGraphics);
        }
        docGraphics.getGridControler().popTransform();
    }

    public static void pushRootTransform(DocPane docPane, DocGridControler docGridControler) {
        String string = docPane.getPanelId();
        DocElement docElement = (DocElement)((Object)docPane.getDocument().getRootElement(string));
        if (docElement != null) {
            docGridControler.pushTransform(docElement.getDisplayScaledTransform(string));
        } else {
            docGridControler.pushTransform(new PTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0));
        }
    }

    public static ZPoint transrateRootTransform(DocPane docPane, ZPoint zPoint) {
        String string = docPane.getPanelId();
        DocElement docElement = (DocElement)((Object)docPane.getDocument().getRootElement(string));
        if (docElement != null) {
            return docElement.getDisplayScaledTransform(string).inverseTransform(zPoint);
        }
        return zPoint;
    }

    public static ZRectangle getTransformedBounds(Vector vector) {
        Enumeration enumeration = vector.elements();
        ZRectangle zRectangle = null;
        while (enumeration.hasMoreElements()) {
            GElement gElement = (GElement)enumeration.nextElement();
            ZRectangle zRectangle2 = gElement.getTransformedBounds();
            if (zRectangle2 == null) continue;
            if (zRectangle == null) {
                zRectangle = zRectangle2;
                continue;
            }
            zRectangle.union(zRectangle2);
        }
        return zRectangle;
    }

    public static Vector list(String string, String string2) {
        return ZInstance.list(string + string2 + ELEMENTS);
    }

    public static Enumeration elements(String string, String string2) {
        return GobManager.list(string, string2).elements();
    }

    public static Enumeration r_elements(String string, String string2) {
        return new ZReverseEnumeration(GobManager.list(string, string2));
    }

    public static int size(String string, String string2) {
        return GobManager.list(string, string2).size();
    }
}

