/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.gob;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import jp.co.iti.fagot.doc.DocGraphics;
import jp.co.iti.fagot.doc.DocGridControler;
import jp.co.iti.fagot.geom.ZPath;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;
import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GSelector;
import jp.co.iti.fagot.gob.PStyle;

public class GPath
extends GElement {
    protected ZPath mPath = new ZPath();
    protected Shape mPaintShape = null;
    protected boolean mIsPaintIfSmall = false;

    public ZRectangle getMyBounds() {
        return new ZRectangle(this.mPath.getBounds2D());
    }

    public byte getHitModeGob(ZPoint zPoint) {
        ZPath zPath = this.getPath();
        if (zPath.contains(zPoint)) {
            return 1;
        }
        return 0;
    }

    public ZPoint getConnectPointGob(byte by) {
        ZRectangle zRectangle = new ZRectangle(this.getPath().getBounds2D());
        return zRectangle.getCenter();
    }

    public ZPath getMovingPathGob(DocGridControler docGridControler) {
        ZPath zPath = this.getPath();
        switch (docGridControler.getMoveMode()) {
            case 1: {
                ZPoint zPoint = docGridControler.getOffsetGrid();
                AffineTransform affineTransform = new AffineTransform(1.0, 0.0, 0.0, 1.0, zPoint.getX(), zPoint.getY());
                zPath.transform(affineTransform);
            }
        }
        return zPath;
    }

    public void paintContents(DocGraphics docGraphics) {
        Composite composite;
        Color color;
        Graphics2D graphics2D = docGraphics.getGraphics();
        PStyle pStyle = this.getStyle();
        if (this.mPaintShape == null) {
            this.createPaintShape(docGraphics);
        }
        if (!pStyle.getFill().getColor().isNull()) {
            color = graphics2D.getColor();
            graphics2D.setColor(pStyle.getFill().getColor().get());
            composite = null;
            if (!pStyle.getFill().getOpacity().isNull()) {
                composite = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(3, pStyle.getFill().getOpacity().get()));
            }
            graphics2D.fill(this.mPaintShape);
            graphics2D.setColor(color);
            if (composite != null) {
                graphics2D.setComposite(composite);
            }
        }
        if (!pStyle.getStroke().getColor().isNull()) {
            color = graphics2D.getColor();
            graphics2D.setColor(pStyle.getStroke().getColor().get());
            composite = null;
            if (!pStyle.getStroke().getOpacity().isNull()) {
                composite = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(3, pStyle.getStroke().getOpacity().get()));
            }
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(pStyle.getStroke().createStroke());
            graphics2D.draw(this.mPaintShape);
            graphics2D.setColor(color);
            graphics2D.setStroke(stroke);
            if (composite != null) {
                graphics2D.setComposite(composite);
            }
        }
    }

    public void paintSelector(DocGraphics docGraphics) {
        docGraphics.getGridControler().pushTransform(this.getTransform());
        GSelector gSelector = new GSelector();
        PathIterator pathIterator = this.getPath().getPathIterator(null);
        ZPoint zPoint = null;
        ZPoint zPoint2 = null;
        while (!pathIterator.isDone()) {
            double[] dArray = new double[6];
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: 
                case 1: {
                    zPoint = new ZPoint(dArray[0], dArray[1]);
                    zPoint2 = docGraphics.getGridControler().transform(zPoint);
                    gSelector.paint(docGraphics.getGraphics(), zPoint2);
                    break;
                }
                case 2: {
                    zPoint = new ZPoint(dArray[2], dArray[3]);
                    zPoint2 = docGraphics.getGridControler().transform(zPoint);
                    gSelector.paint(docGraphics.getGraphics(), zPoint2);
                    break;
                }
                case 3: {
                    zPoint = new ZPoint(dArray[4], dArray[5]);
                    zPoint2 = docGraphics.getGridControler().transform(zPoint);
                    gSelector.paint(docGraphics.getGraphics(), zPoint2);
                    break;
                }
            }
            pathIterator.next();
        }
        docGraphics.getGridControler().popTransform();
    }

    public void paintDragContents(DocGraphics docGraphics) {
        Graphics2D graphics2D = docGraphics.getGraphics();
        ZPath zPath = this.getMovingPath(docGraphics.getGridControler());
        Shape shape = docGraphics.getGridControler().transform(zPath);
        graphics2D.draw(shape);
    }

    protected boolean paintCheck(DocGraphics docGraphics) {
        boolean bl = true;
        this.createPaintShape(docGraphics);
        Rectangle2D rectangle2D = this.mPaintShape.getBounds2D();
        Rectangle rectangle = docGraphics.getGraphics().getClipBounds();
        if (!this.mIsPaintIfSmall && (rectangle2D.getWidth() < 2.0 || rectangle2D.getHeight() < 2.0)) {
            bl = false;
        } else if (rectangle != null && ((double)rectangle.x > rectangle2D.getX() + rectangle2D.getWidth() || (double)(rectangle.x + rectangle.width) < rectangle2D.getX()) && ((double)rectangle.y > rectangle2D.getY() + rectangle2D.getHeight() || (double)(rectangle.y + rectangle.height) < rectangle2D.getY())) {
            bl = false;
        }
        return bl;
    }

    protected void createPaintShape(DocGraphics docGraphics) {
        ZPath zPath = this.getPath();
        this.mPaintShape = docGraphics.getGridControler().transform(zPath);
    }

    public ZPath getPath() {
        return new ZPath(this.mPath);
    }

    public void setPath(ZPath zPath) {
        this.mPath.setPath(zPath);
    }

    public void setPaintIfSmall(boolean bl) {
        this.mIsPaintIfSmall = bl;
    }

    public Object createClone() {
        return new GPath();
    }

    public void copyAttribute(Object object) {
        super.copyAttribute(object);
        ((GPath)object).setPath(this.getPath());
    }
}

