/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.gob;

import java.util.Enumeration;
import java.util.Vector;
import jp.co.iti.fagot.doc.DocGraphics;
import jp.co.iti.fagot.doc.DocGridControler;
import jp.co.iti.fagot.fob.FobManager;
import jp.co.iti.fagot.fob.IFobContainer;
import jp.co.iti.fagot.geom.ZPath;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZRectangle;
import jp.co.iti.fagot.gob.IGobContainer;
import jp.co.iti.fagot.gob.PStyle;
import jp.co.iti.fagot.gob.PTransform;

public class GElement
implements IFobContainer {
    protected IGobContainer mContainer = null;
    protected String mGobId = null;
    protected Vector mForeChildren = new Vector();
    protected Vector mBackChildren = new Vector();
    protected PStyle mStyle = new PStyle();
    protected PTransform mTransform = new PTransform();
    protected boolean mSelect = false;
    protected boolean mSelectable = true;

    public void setContainer(IGobContainer iGobContainer) {
        this.mContainer = iGobContainer;
    }

    public IGobContainer getContainer() {
        return this.mContainer;
    }

    public void removeContainer() {
        if (this.mContainer != null) {
            this.mContainer.removeGob(this);
        }
    }

    public void setGobId(String string) {
        this.mGobId = string;
    }

    public String getGobId() {
        return this.mGobId;
    }

    public void addForeChildren(Vector vector) {
        this.mForeChildren.addAll(vector);
    }

    public void addForeChild(GElement gElement) {
        this.mForeChildren.add(gElement);
    }

    public Vector getForeChildren() {
        return this.mForeChildren;
    }

    public void addBackChildren(Vector vector) {
        this.mBackChildren.addAll(vector);
    }

    public void addBackChild(GElement gElement) {
        this.mBackChildren.add(gElement);
    }

    public Vector getBackChildren() {
        return this.mBackChildren;
    }

    public boolean isSelect() {
        return this.mSelect;
    }

    public boolean setSelect(boolean bl) {
        if (this.mSelectable) {
            this.mSelect = this.mContainer != null ? this.mContainer.setSelect(this, bl) : bl;
        }
        return this.mSelect;
    }

    public void setSelectable(boolean bl) {
        this.mSelectable = bl;
    }

    public byte getHitMode(ZPoint zPoint) {
        if (this.mSelectable) {
            ZPoint zPoint2 = this.getTransform().inverseTransform(zPoint);
            if (this.mContainer != null) {
                return this.mContainer.getHitMode(this, zPoint2);
            }
            return this.getHitModeGob(zPoint2);
        }
        return 0;
    }

    public byte getHitModeGob(ZPoint zPoint) {
        return 0;
    }

    public byte getPreMoveMode(ZPoint zPoint) {
        if (this.mSelectable) {
            ZPoint zPoint2 = this.getTransform().inverseTransform(zPoint);
            if (this.mContainer != null) {
                return this.mContainer.getPreMoveMode(this, zPoint2);
            }
            return this.getPreMoveModeGob(zPoint2);
        }
        return 0;
    }

    public byte getPreMoveModeGob(ZPoint zPoint) {
        return this.getHitModeGob(zPoint);
    }

    public byte getConnectMode(ZPoint zPoint, Object object) {
        if (this.mSelectable) {
            ZPoint zPoint2 = this.getTransform().inverseTransform(zPoint);
            if (this.mContainer != null) {
                return this.mContainer.getConnectMode(this, zPoint2, object);
            }
            return this.getConnectModeGob(zPoint2, object);
        }
        return 0;
    }

    public byte getConnectModeGob(ZPoint zPoint, Object object) {
        return 0;
    }

    public ZPoint getConnectPointGob(byte by) {
        return new ZPoint(0.0, 0.0);
    }

    public void verbDblClick(ZPoint zPoint) {
        ZPoint zPoint2 = this.getTransform().inverseTransform(zPoint);
        if (this.mContainer != null) {
            this.mContainer.verbDblClick(this, zPoint2);
        } else {
            this.verbDblClickGob(zPoint2);
        }
    }

    public void verbDblClickGob(ZPoint zPoint) {
    }

    public void moveStart(DocGridControler docGridControler) {
        docGridControler.pushTransform(this.getTransform());
        if (this.mContainer != null) {
            this.mContainer.moveStart(this, docGridControler);
        } else {
            this.moveStartGob(docGridControler);
        }
        docGridControler.popTransform();
    }

    public void moveStartGob(DocGridControler docGridControler) {
    }

    public ZPath getMovingPath(DocGridControler docGridControler) {
        if (this.mContainer != null) {
            return this.mContainer.getMovingPath(this, docGridControler);
        }
        return this.getMovingPathGob(docGridControler);
    }

    public ZPath getMovingPathGob(DocGridControler docGridControler) {
        return null;
    }

    public void moveEnd(DocGridControler docGridControler) {
        docGridControler.pushTransform(this.getTransform());
        if (this.mContainer != null) {
            this.mContainer.moveEnd(this, docGridControler);
        } else {
            this.moveEndGob(docGridControler);
        }
        docGridControler.popTransform();
    }

    public void moveEndGob(DocGridControler docGridControler) {
    }

    public boolean needsMoveEnd() {
        return false;
    }

    public ZRectangle getBounds() {
        return this.getMyBounds();
    }

    public ZRectangle getMyBounds() {
        return null;
    }

    public ZRectangle getTransformedBounds() {
        return new ZRectangle(this.getTransform().transform(this.getBounds()).getBounds2D());
    }

    public void setStyle(PStyle pStyle) {
        this.mStyle.set(pStyle);
    }

    public PStyle getStyle() {
        return this.mStyle;
    }

    public void setTransform(PTransform pTransform) {
        this.mTransform.set(pTransform);
    }

    public void addTransform(PTransform pTransform) {
        this.mTransform.add(pTransform);
    }

    public PTransform getTransform() {
        return this.mTransform;
    }

    public void paint(DocGraphics docGraphics) {
        docGraphics.getGridControler().pushTransform(this.getTransform());
        if (this.paintCheck(docGraphics)) {
            this.paintBackChildren(docGraphics);
            this.paintContents(docGraphics);
            this.paintForeChildren(docGraphics);
        }
        docGraphics.getGridControler().popTransform();
    }

    public void paintContents(DocGraphics docGraphics) {
    }

    public void paintForeChildren(DocGraphics docGraphics) {
        Enumeration enumeration = this.mForeChildren.elements();
        while (enumeration.hasMoreElements()) {
            GElement gElement = (GElement)enumeration.nextElement();
            gElement.paintContents(docGraphics);
        }
    }

    public void paintBackChildren(DocGraphics docGraphics) {
        Enumeration enumeration = this.mBackChildren.elements();
        while (enumeration.hasMoreElements()) {
            GElement gElement = (GElement)enumeration.nextElement();
            gElement.paintContents(docGraphics);
        }
    }

    protected boolean paintCheck(DocGraphics docGraphics) {
        return true;
    }

    public void paintSelector(DocGraphics docGraphics) {
    }

    public void paintDrag(DocGraphics docGraphics) {
        docGraphics.getGridControler().pushTransform(this.getTransform());
        this.paintDragContents(docGraphics);
        docGraphics.getGridControler().popTransform();
    }

    public void paintDragContents(DocGraphics docGraphics) {
    }

    public void setFobManager(FobManager fobManager) {
        this.mStyle.setFobManager(fobManager, this);
    }

    public Object clone() {
        Object object = this.createClone();
        this.copyAttribute(object);
        return object;
    }

    public Object createClone() {
        return new GElement();
    }

    public void copyAttribute(Object object) {
        ((GElement)object).setStyle((PStyle)this.mStyle.clone());
        ((GElement)object).setTransform((PTransform)this.mTransform.clone());
    }
}

