/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.geom;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import jp.co.iti.fagot.geom.ZDimension;
import jp.co.iti.fagot.geom.ZPoint;

public class ZRectangle
extends Rectangle2D.Double {
    protected double x;
    protected double y;
    protected double width;
    protected double height;

    public ZRectangle() {
    }

    public ZRectangle(double d, double d2, double d3, double d4) {
        this();
        this.setRect(d, d2, d3, d4);
    }

    public ZRectangle(ZPoint zPoint, ZPoint zPoint2) {
        this();
        this.setRect(Math.min(zPoint.getX(), zPoint2.getX()), Math.min(zPoint.getY(), zPoint2.getY()), Math.abs(zPoint.getX() - zPoint2.getX()), Math.abs(zPoint.getY() - zPoint2.getY()));
    }

    public ZRectangle(Rectangle2D rectangle2D) {
        this();
        this.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public ZRectangle(Shape shape) {
        this();
        Rectangle2D rectangle2D = shape.getBounds2D();
        this.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public String toString() {
        return new String("jp.co.iti.fagot.geom.ZRectangle:x=" + this.getX() + "," + "y=" + this.getY() + "," + "width=" + this.getWidth() + "," + "height=" + this.getHeight());
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public boolean isEmpty() {
        return this.getWidth() <= 0.0 || this.getHeight() <= 0.0;
    }

    public void setRect(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
    }

    public void setRect(Rectangle2D rectangle2D) {
        this.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public int outcode(double d, double d2) {
        int n = 0;
        if (this.getWidth() <= 0.0) {
            n |= 5;
        } else if (d < this.getX()) {
            n |= 1;
        } else if (d > this.getX() + this.getWidth()) {
            n |= 4;
        }
        if (this.getHeight() <= 0.0) {
            n |= 0xA;
        } else if (d2 < this.getY()) {
            n |= 2;
        } else if (d2 > this.getY() + this.getHeight()) {
            n |= 8;
        }
        return n;
    }

    public Rectangle2D getBounds2D() {
        return new ZRectangle(this);
    }

    public Rectangle2D createIntersection(Rectangle2D rectangle2D) {
        ZRectangle zRectangle = new ZRectangle();
        Rectangle2D.intersect(this, rectangle2D, zRectangle);
        return zRectangle;
    }

    public Rectangle2D createUnion(Rectangle2D rectangle2D) {
        ZRectangle zRectangle = new ZRectangle();
        Rectangle2D.union(this, rectangle2D, zRectangle);
        return zRectangle;
    }

    public void translate(double d, double d2) {
        this.setLocation(this.getX() + d, this.getY() + d2);
    }

    public void translate(ZPoint zPoint) {
        this.translate(zPoint.getX(), zPoint.getY());
    }

    public void setLocation(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void setLocation(ZPoint zPoint) {
        this.setLocation(zPoint.getX(), zPoint.getY());
    }

    public void setCenter(double d, double d2) {
        this.setLocation(d - this.getWidth() / 2.0, d2 - this.getWidth() / 2.0);
    }

    public void setCenter(ZPoint zPoint) {
        this.setCenter(zPoint.getX(), zPoint.getY());
    }

    public ZDimension getSize() {
        return new ZDimension(this.getWidth(), this.getHeight());
    }

    public void union(ZRectangle zRectangle) {
        Rectangle2D rectangle2D = this.createUnion(zRectangle);
        this.setRect(rectangle2D);
    }

    public boolean contains(ZPoint zPoint) {
        return this.contains(zPoint.getX(), zPoint.getY());
    }

    public ZPoint getTopLeft() {
        return new ZPoint(this.getX(), this.getY());
    }

    public ZPoint getCenter() {
        return new ZPoint(this.getX() + this.getWidth() / 2.0, this.getY() + this.getHeight() / 2.0);
    }

    public Ellipse2D getEllipse2D() {
        return new Ellipse2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public void setX(double d) {
        this.x = d;
    }

    public void setY(double d) {
        this.y = d;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    public void setHeight(double d) {
        this.height = d;
    }
}

