/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.doc;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GOperation;
import jp.co.iti.fagot.gob.GOperationCreate;
import jp.co.iti.fagot.gob.GOperationMove;
import jp.co.iti.fagot.gob.GOperationSelect;
import jp.co.iti.fagot.gob.GOperationZoom;
import jp.co.iti.fagot.gob.GobManager;
import jp.co.iti.fagot.ui.UIFactory;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZReverseEnumeration;
import jp.co.iti.fagot.util.ZUIUtil;
import jp.co.nri.rid.RUpdateManager;

public class DocUIAdapter
implements MouseListener,
MouseMotionListener,
KeyListener {
    protected DocPane mEditor = null;
    protected ZPoint mStartPoint = null;
    protected byte mMoveMode = 0;
    protected static String KEY_VK_SPACE = "uiadapter.key.space";

    public DocUIAdapter(DocPane docPane) {
        this.mEditor = docPane;
    }

    protected void OnLButtonDown(MouseEvent mouseEvent) {
        this.mMoveMode = 0;
        if (this.mEditor.editEnd()) {
            return;
        }
        this.mStartPoint = new ZPoint(mouseEvent.getPoint());
        GElement gElement = this.createOperation(mouseEvent);
        if (gElement != null) {
            this.mMoveMode = gElement.getHitMode(this.mStartPoint);
            GobManager.setSelect(this.mEditor.getPanelId(), false);
            GobManager.setCurrent(this.mEditor.getPanelId(), gElement);
        }
        if (this.mMoveMode == 0) {
            this.mMoveMode = GobManager.getSelectedPreMoveMode(this.mEditor, this.mStartPoint);
            if (this.mMoveMode != 0) {
                GobManager.updateCurrent(this.mEditor.getPanelId());
            }
        }
        if (this.mMoveMode == 0) {
            GElement gElement2 = GobManager.getHitElement(this.mEditor, this.mStartPoint);
            if (!mouseEvent.isShiftDown()) {
                GobManager.setSelect(this.mEditor.getPanelId(), false);
            }
            if (gElement2 != null) {
                GobManager.updateCurrent(this.mEditor.getPanelId());
                GobManager.addCurrent(this.mEditor.getPanelId(), gElement2);
                this.mMoveMode = 1;
            } else {
                GobManager.setCurrent(this.mEditor.getPanelId(), new GOperationSelect());
                this.mMoveMode = (byte)10;
            }
        }
        this.mEditor.getDocument().beginTransaction();
        this.mEditor.getGridControler().setMoveStart(this.mStartPoint, this.mMoveMode);
        GobManager.moveStart(this.mEditor, this.mEditor.getGridControler());
        this.mEditor.getGridControler().setMoving(this.mStartPoint, 0);
        this.mEditor.setCursor(GOperation.getCursor(this.mMoveMode));
        this.mEditor.repaint(1000L);
    }

    protected void OnLButtonUp(MouseEvent mouseEvent) {
        ZPoint zPoint = new ZPoint(mouseEvent.getPoint());
        this.mEditor.getGridControler().setMoving(zPoint, 0);
        Vector vector = GobManager.getCurrent(this.mEditor.getPanelId());
        if (vector.size() == 0) {
            return;
        }
        if (this.mStartPoint.equals(zPoint)) {
            if (vector.size() == 1) {
                GElement gElement = (GElement)vector.elementAt(0);
                if (gElement.needsMoveEnd()) {
                    GobManager.moveEnd(this.mEditor, this.mEditor.getGridControler());
                }
                gElement.setSelect(true);
            } else {
                GElement gElement = GobManager.getCurrentHitElement(this.mEditor, zPoint);
                if (gElement != null) {
                    if (mouseEvent.isShiftDown()) {
                        gElement.setSelect(!gElement.isSelect());
                    } else {
                        gElement.setSelect(true);
                    }
                }
            }
            RUpdateManager.update(256);
        } else {
            GobManager.moveEnd(this.mEditor, this.mEditor.getGridControler());
            GobManager.setCurrentSelect(this.mEditor.getPanelId(), true);
        }
        GobManager.setCurrent(this.mEditor.getPanelId(), null);
        this.mEditor.updateGobs();
        this.mEditor.getDocument().commit();
        this.updateCursor(mouseEvent);
        this.mEditor.repaint();
    }

    protected void OnRButtonDown(MouseEvent mouseEvent) {
        if (this.mEditor.editEnd()) {
            return;
        }
        Vector vector = GobManager.getCurrent(this.mEditor.getPanelId());
        if (vector.size() != 0) {
            this.mEditor.getDocument().rollback();
            GobManager.setCurrent(this.mEditor.getPanelId(), null);
            this.mEditor.setCursor(new Cursor(0));
        } else {
            Object object;
            Object object2;
            Cloneable cloneable;
            Object object3;
            Object object4;
            ZPoint zPoint = new ZPoint(mouseEvent.getPoint());
            if (GobManager.getSelectedHitMode(this.mEditor, zPoint) == 0) {
                GobManager.setSelect(this.mEditor.getPanelId(), false);
                object4 = GobManager.getHitElement(this.mEditor, zPoint);
                if (object4 != null) {
                    ((GElement)object4).setSelect(true);
                }
            }
            object4 = GobManager.getSelectedElement(this.mEditor.getPanelId());
            Vector<Object> vector2 = new Vector<Object>();
            UIFactory uIFactory = DocManager.createUIFactory("element");
            String string = null;
            if (((Vector)object4).size() == 0) {
                string = this.mEditor.getPanelId();
                uIFactory = DocManager.createUIFactory("document");
            } else if (((Vector)object4).size() == 1) {
                object3 = (DocElement)((GElement)((Vector)object4).firstElement()).getContainer();
                vector2.add(object3);
                string = ((DocElement)object3).getContextKey(this.mEditor.getPanelId());
            }
            object3 = null;
            if (string != null) {
                object3 = uIFactory.createContextMenu((JComponent)this.mEditor, string);
            } else {
                cloneable = new Vector();
                object2 = ((Vector)object4).elements();
                while (object2.hasMoreElements()) {
                    object = (DocElement)((GElement)object2.nextElement()).getContainer();
                    ((Vector)cloneable).add(((DocElement)object).getContextKey(this.mEditor.getPanelId()));
                    vector2.add(object);
                }
                object3 = uIFactory.createContextMenu((JComponent)this.mEditor, (Vector)cloneable);
            }
            cloneable = ((Component)object3).getToolkit().getScreenSize();
            object2 = ((JComponent)object3).getPreferredSize();
            object = ZUIUtil.getParentWindow(this.mEditor);
            Point point = this.mEditor.getLocationOnScreen();
            Point point2 = ((Component)object).getLocationOnScreen();
            int n = (int)((double)mouseEvent.getX() + point.getX() - point2.getX());
            int n2 = (int)((double)mouseEvent.getY() + point.getY() - point2.getY());
            if ((double)n + point2.getX() + ((Dimension)object2).getWidth() > ((Dimension)cloneable).getWidth() - 40.0) {
                n = (int)((double)n - ((Dimension)object2).getWidth());
            }
            if ((double)n2 + point2.getY() + ((Dimension)object2).getHeight() > ((Dimension)cloneable).getHeight() - 40.0) {
                n2 = (int)((double)n2 - ((Dimension)object2).getHeight());
            }
            ZInstance.map().put("doc.rmenu.target", vector2);
            ((JPopupMenu)object3).show((Component)object, n, n2);
        }
        this.mEditor.repaint();
    }

    protected void OnRButtonUp(MouseEvent mouseEvent) {
    }

    protected void OnDblClick(MouseEvent mouseEvent) {
        ZPoint zPoint = new ZPoint(mouseEvent.getPoint());
        String string = this.mEditor.getPanelId();
        ZPoint zPoint2 = ((DocElement)((Object)this.mEditor.getDocument().getRootElement(string))).getDisplayScaledTransform(string).inverseTransform(zPoint);
        ZReverseEnumeration zReverseEnumeration = new ZReverseEnumeration(GobManager.getSelectedElement(string));
        while (zReverseEnumeration.hasMoreElements()) {
            GElement gElement = (GElement)zReverseEnumeration.nextElement();
            byte by = gElement.getHitMode(zPoint2);
            if (by == 0) continue;
            gElement.verbDblClick(zPoint2);
            break;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32) {
            ZInstance.prop().putBoolean(KEY_VK_SPACE, true);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32) {
            ZInstance.prop().putBoolean(KEY_VK_SPACE, false);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.OnDblClick(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) != 0) {
            this.OnRButtonDown(mouseEvent);
        } else if ((mouseEvent.getModifiers() & 0x10) != 0) {
            this.OnLButtonDown(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) != 0) {
            this.OnRButtonUp(mouseEvent);
        } else if ((mouseEvent.getModifiers() & 0x10) != 0) {
            this.OnLButtonUp(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        JViewport jViewport = (JViewport)this.mEditor.getParent();
        Point point = mouseEvent.getPoint();
        Point point2 = jViewport.getViewPosition();
        Dimension dimension = jViewport.getSize();
        Dimension dimension2 = this.mEditor.getSize();
        if (this.mMoveMode == 14) {
            ZPoint zPoint = this.mStartPoint;
            Point point3 = new Point((int)(zPoint.getX() - (point.getX() - (double)point2.x)), (int)(zPoint.getY() - (point.getY() - (double)point2.y)));
            if (point3.x < 0) {
                point3.x = 0;
            } else if (point3.x > dimension2.width - dimension.width) {
                point3.x = dimension2.width - dimension.width;
            }
            if (point3.y < 0) {
                point3.y = 0;
            } else if (point3.y > dimension2.height - dimension.height) {
                point3.y = dimension2.height - dimension.height;
            }
            if (point3.x != point2.x || point3.y != point2.y) {
                jViewport.setViewPosition(point3);
                this.mEditor.repaint();
            }
            return;
        }
        int n = 0;
        int n2 = 0;
        if (point.x < point2.x) {
            n = -20;
        } else if (point.x > point2.x + dimension.width) {
            n = 20;
        }
        if (point.y < point2.y) {
            n2 = -20;
        } else if (point.y > point2.y + dimension.height) {
            n2 = 20;
        }
        if (n != 0 || n2 != 0) {
            Point point4 = new Point();
            point4.x = point2.x + n;
            point4.y = point2.y + n2;
            if (point4.x < 0) {
                point4.x = 0;
            } else if (point4.x > dimension2.width - dimension.width) {
                point4.x = dimension2.width - dimension.width;
            }
            if (point4.y < 0) {
                point4.y = 0;
            } else if (point4.y > dimension2.height - dimension.height) {
                point4.y = dimension2.height - dimension.height;
            }
            jViewport.setViewPosition(point4);
        }
        GobManager.list(this.mEditor.getPanelId(), ".highlight").removeAllElements();
        if (GobManager.getCurrent(this.mEditor.getPanelId()).size() > 0) {
            this.mEditor.getGridControler().setMoving(new ZPoint(mouseEvent.getPoint()), 0);
            this.mEditor.repaint();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = GobManager.size(this.mEditor.getPanelId(), ".highlight");
        this.updateCursor(mouseEvent);
        int n2 = GobManager.size(this.mEditor.getPanelId(), ".highlight");
        if (n != 0 || n2 != 0) {
            this.mEditor.repaint();
        }
    }

    public void updateCursor(MouseEvent mouseEvent) {
        byte by = 0;
        GobManager.list(this.mEditor.getPanelId(), ".highlight").removeAllElements();
        GElement gElement = this.createOperation(mouseEvent);
        if (gElement != null) {
            ZPoint zPoint = ((DocElement)((Object)this.mEditor.getDocument().getRootElement(this.mEditor.getPanelId()))).getDisplayScaledTransform(this.mEditor.getPanelId()).inverseTransform(new ZPoint(mouseEvent.getPoint()));
            by = gElement.getPreMoveMode(zPoint);
        }
        if (by == 0) {
            by = GobManager.getSelectedPreMoveMode(this.mEditor, new ZPoint(mouseEvent.getPoint()));
        }
        this.mEditor.setCursor(GOperation.getCursor(by));
    }

    public GElement createOperation(MouseEvent mouseEvent) {
        GElement gElement = null;
        String string = ZInstance.prop().getProperty("docbar.action");
        if (mouseEvent.isControlDown()) {
            if (mouseEvent.isAltDown() && mouseEvent.isShiftDown()) {
                gElement = new GOperationZoom(false);
            } else if (mouseEvent.isAltDown()) {
                gElement = new GOperationZoom(true);
            }
        } else if (mouseEvent.isAltDown()) {
            gElement = new GOperationMove();
        } else if (!string.equals("select")) {
            gElement = string.equals("move") ? new GOperationMove() : (string.equals("zoom") ? (mouseEvent.isShiftDown() ? new GOperationZoom(false) : new GOperationZoom(true)) : new GOperationCreate(this.mEditor.getDocument(), string));
        }
        return gElement;
    }
}

