/*
 * Decompiled with CFR 0.152.
 */
package jp.co.iti.fagot.action;

import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.IZFileable;
import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.action.ZAction;
import jp.co.iti.fagot.util.ZFile;
import jp.co.iti.fagot.util.ZFileFilter;
import jp.co.iti.fagot.util.ZResource;
import jp.co.nri.Ridual;

public class ZFileAction
extends ZAction {
    protected JFileChooser mFileDialog = null;
    protected IZFileable mCmp = null;
    protected String mFile = null;
    protected String mRecent = null;
    protected ZFileFilter mFileFilter = null;
    public static final String NEW = "new";
    public static final String OPEN = "open";
    public static final String SAVE = "save";
    public static final String SAVEAS = "saveas";

    public ZFileAction(IZApp iZApp, IZFileable iZFileable, String string) {
        super(iZApp, string);
        this.mCmp = iZFileable;
    }

    public ZFileAction(IZApp iZApp, IZFileable iZFileable, String string, String string2) {
        this(iZApp, iZFileable, string);
        this.mFile = string2;
    }

    public ZFileAction(IZApp iZApp, IZFileable iZFileable, String string, ZFileFilter zFileFilter) {
        this(iZApp, iZFileable, string);
        this.mFileFilter = zFileFilter;
    }

    public ZFileAction(IZApp iZApp, IZFileable iZFileable, String string, String string2, ZFileFilter zFileFilter) {
        this(iZApp, iZFileable, string);
        this.mRecent = string2;
        this.mFileFilter = zFileFilter;
    }

    public void doAction(ActionEvent actionEvent) {
        if (this.getActionName().equals(NEW)) {
            if (this.getApp().preExit(false)) {
                this.mCmp.open(null);
            }
        } else if (this.getActionName().equals(OPEN)) {
            if (this.getApp().preExit(false)) {
                if (this.mFile != null) {
                    this.mCmp.open(this.mFile);
                } else {
                    this.open();
                }
            }
        } else if (this.getActionName().equals(SAVE)) {
            if (this.checkLicense()) {
                if (this.mCmp.canSave()) {
                    this.mCmp.save();
                } else {
                    this.saveAs();
                }
            }
        } else if (this.getActionName().equals(SAVEAS) && this.checkLicense()) {
            this.saveAs();
        }
    }

    protected void open() {
        Frame frame = this.getApp().getFrame();
        if (this.mFileDialog == null) {
            this.createDialog();
        }
        Point point = frame.getLocationOnScreen();
        this.mFileDialog.setLocation(point.x + 10, point.y + 10);
        int n = this.mFileDialog.showOpenDialog(frame);
        if (n == 0) {
            File file = this.mFileDialog.getSelectedFile();
            String string = null;
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string = file.getAbsolutePath();
            }
            this.mCmp.open(string);
        }
    }

    public boolean saveAs() {
        Frame frame = this.getApp().getFrame();
        if (this.mFileDialog == null) {
            this.createDialog();
        }
        Point point = frame.getLocationOnScreen();
        this.mFileDialog.setLocation(point.x + 10, point.y + 10);
        int n = this.mFileDialog.showSaveDialog(frame);
        if (n == 0) {
            File file = this.mFileDialog.getSelectedFile();
            String string = null;
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string = file.getAbsolutePath();
            }
            return this.mCmp.saveAs(string);
        }
        return false;
    }

    protected void createDialog() {
        String string;
        ZResource zResource = this.getApp().getResource();
        this.mFileDialog = new JFileChooser();
        if (this.mFileFilter != null) {
            this.mFileDialog.setFileFilter(this.mFileFilter);
        }
        if (this.mRecent != null && (string = zResource.getString(this.mRecent)) != null) {
            this.mFileDialog.setCurrentDirectory(new File(ZFile.getParent(string)));
        }
    }

    public boolean checkLicense() {
        Ridual ridual = (Ridual)ZApp.getTheApp();
        return ridual.checkLicense(true);
    }
}

