/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.RelationPropertyType;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.util.CaseInsensitiveSet;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.StringUtil;

public abstract class AbstractBeanMetaDataResultSetHandler
implements ResultSetHandler {
    private BeanMetaData beanMetaData;

    public AbstractBeanMetaDataResultSetHandler(BeanMetaData beanMetaData) {
        this.beanMetaData = beanMetaData;
    }

    public BeanMetaData getBeanMetaData() {
        return this.beanMetaData;
    }

    protected Object createRow(ResultSet rs, Set columnNames) throws SQLException {
        Object row = ClassUtil.newInstance((Class)this.beanMetaData.getBeanClass());
        block0: for (int i = 0; i < this.beanMetaData.getPropertyTypeSize(); ++i) {
            PropertyDesc pd;
            Object value;
            ValueType valueType;
            PropertyType pt = this.beanMetaData.getPropertyType(i);
            if (columnNames.contains(pt.getColumnName())) {
                valueType = pt.getValueType();
                value = valueType.getValue(rs, pt.getColumnName());
                pd = pt.getPropertyDesc();
                pd.setValue(row, value);
                continue;
            }
            if (columnNames.contains(pt.getPropertyName())) {
                valueType = pt.getValueType();
                value = valueType.getValue(rs, pt.getPropertyName());
                pd = pt.getPropertyDesc();
                pd.setValue(row, value);
                continue;
            }
            if (pt.isPersistent()) continue;
            Iterator iter = columnNames.iterator();
            while (iter.hasNext()) {
                String columnName = (String)iter.next();
                String columnName2 = StringUtil.replace((String)columnName, (String)"_", (String)"");
                if (!columnName2.equalsIgnoreCase(pt.getColumnName())) continue;
                ValueType valueType2 = pt.getValueType();
                Object value2 = valueType2.getValue(rs, columnName);
                PropertyDesc pd2 = pt.getPropertyDesc();
                pd2.setValue(row, value2);
                continue block0;
            }
        }
        return row;
    }

    protected Object createRelationRow(ResultSet rs, RelationPropertyType rpt, Set columnNames, Map relKeyValues) throws SQLException {
        Object row = null;
        BeanMetaData bmd = rpt.getBeanMetaData();
        for (int i = 0; i < rpt.getKeySize(); ++i) {
            String columnName = rpt.getMyKey(i);
            if (!columnNames.contains(columnName)) continue;
            if (row == null) {
                row = this.createRelationRow(rpt);
            }
            if (relKeyValues == null || !relKeyValues.containsKey(columnName)) continue;
            Object value = relKeyValues.get(columnName);
            PropertyType pt = bmd.getPropertyTypeByColumnName(rpt.getYourKey(i));
            PropertyDesc pd = pt.getPropertyDesc();
            if (value == null) continue;
            pd.setValue(row, value);
        }
        int existColumn = 0;
        for (int i = 0; i < bmd.getPropertyTypeSize(); ++i) {
            PropertyType pt = bmd.getPropertyType(i);
            String columnName = pt.getColumnName() + "_" + rpt.getRelationNo();
            if (!columnNames.contains(columnName)) continue;
            ++existColumn;
            if (row == null) {
                row = this.createRelationRow(rpt);
            }
            Object value = null;
            if (relKeyValues != null && relKeyValues.containsKey(columnName)) {
                value = relKeyValues.get(columnName);
            } else {
                ValueType valueType = pt.getValueType();
                value = valueType.getValue(rs, columnName);
            }
            PropertyDesc pd = pt.getPropertyDesc();
            if (value == null) continue;
            pd.setValue(row, value);
        }
        if (existColumn == 0) {
            return null;
        }
        return row;
    }

    protected Object createRelationRow(RelationPropertyType rpt) {
        return ClassUtil.newInstance((Class)rpt.getPropertyDesc().getPropertyType());
    }

    protected Set createColumnNames(ResultSetMetaData rsmd) throws SQLException {
        int count = rsmd.getColumnCount();
        CaseInsensitiveSet columnNames = new CaseInsensitiveSet();
        for (int i = 0; i < count; ++i) {
            String columnName = rsmd.getColumnLabel(i + 1);
            int pos = columnName.lastIndexOf(46);
            if (-1 < pos) {
                columnNames.add(columnName.substring(pos + 1));
                continue;
            }
            columnNames.add(columnName);
        }
        return columnNames;
    }
}

