/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.dbms;

import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.Dbms;
import org.seasar.dao.RelationPropertyType;

public class Standard
implements Dbms {
    private static final Pattern baseSqlPattern = Pattern.compile("^.*?(select)", 2);
    private Map autoSelectFromClauseCache = new HashMap();

    public String getSuffix() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAutoSelectSql(BeanMetaData beanMetaData) {
        StringBuffer buf = new StringBuffer(100);
        buf.append(beanMetaData.getAutoSelectList());
        buf.append(" ");
        String beanName = beanMetaData.getBeanClass().getName();
        Map map = this.autoSelectFromClauseCache;
        synchronized (map) {
            String fromClause = (String)this.autoSelectFromClauseCache.get(beanName);
            if (fromClause == null) {
                fromClause = this.createAutoSelectFromClause(beanMetaData);
                this.autoSelectFromClauseCache.put(beanName, fromClause);
            }
            buf.append(fromClause);
        }
        return buf.toString();
    }

    protected String createAutoSelectFromClause(BeanMetaData beanMetaData) {
        StringBuffer buf = new StringBuffer(100);
        buf.append("FROM ");
        String myTableName = beanMetaData.getTableName();
        buf.append(myTableName);
        for (int i = 0; i < beanMetaData.getRelationPropertyTypeSize(); ++i) {
            RelationPropertyType rpt = beanMetaData.getRelationPropertyType(i);
            BeanMetaData bmd = rpt.getBeanMetaData();
            buf.append(" LEFT OUTER JOIN ");
            buf.append(bmd.getTableName());
            buf.append(" ");
            String yourAliasName = rpt.getPropertyName();
            buf.append(yourAliasName);
            buf.append(" ON ");
            for (int j = 0; j < rpt.getKeySize(); ++j) {
                buf.append(myTableName);
                buf.append(".");
                buf.append(rpt.getMyKey(j));
                buf.append(" = ");
                buf.append(yourAliasName);
                buf.append(".");
                buf.append(rpt.getYourKey(j));
                buf.append(" AND ");
            }
            buf.setLength(buf.length() - 5);
        }
        return buf.toString();
    }

    public String getIdentitySelectString() {
        return null;
    }

    public String getSequenceNextValString(String sequenceName) {
        return null;
    }

    public boolean isSelfGenerate() {
        return true;
    }

    public String getBaseSql(Statement st) {
        String sql = st.toString();
        Matcher matcher = baseSqlPattern.matcher(sql);
        if (matcher.find()) {
            return matcher.replaceFirst(matcher.group(1));
        }
        return sql;
    }
}

