/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.seasar.framework.container.factory.ClassPathResourceResolver;
import org.seasar.framework.container.factory.ResourceResolver;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.URLUtil;

public class WebResourceResolver
implements ResourceResolver {
    protected ResourceResolver parent;

    public WebResourceResolver() {
        this(new ClassPathResourceResolver());
    }

    public WebResourceResolver(ResourceResolver parent) {
        this.parent = parent;
    }

    public InputStream getInputStream(String path) {
        try {
            InputStream is;
            if (this.parent != null && (is = this.parent.getInputStream(path)) != null) {
                return is;
            }
            URL url = SingletonS2ContainerFactory.getServletContext().getResource(path);
            if (url == null) {
                StringBuffer buf = new StringBuffer(path.length() + 10);
                buf.append("/WEB-INF");
                if (!path.startsWith("/")) {
                    buf.append("/");
                }
                buf.append(path);
                url = SingletonS2ContainerFactory.getServletContext().getResource(new String(buf));
            }
            if (url == null) {
                return null;
            }
            return URLUtil.openStream(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

