/*
 * Decompiled with CFR 0.152.
 */
package javassist.preproc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

class CommentSkipper {
    private BufferedReader input;
    private BufferedWriter output;

    public CommentSkipper(BufferedReader reader, BufferedWriter writer) {
        this.input = reader;
        this.output = writer;
    }

    public int read() throws IOException {
        int c;
        while ((c = this.input.read()) != -1) {
            if (c != 47) {
                return c;
            }
            c = this.input.read();
            if (c == 47) {
                this.skipCxxComments();
                continue;
            }
            if (c == 42) {
                this.skipCComments();
                continue;
            }
            this.output.write(47);
        }
        return c;
    }

    private void skipCxxComments() throws IOException {
        int c;
        this.output.write("//");
        while ((c = this.input.read()) != -1) {
            this.output.write(c);
            if (c != 10 && c != 13) continue;
            break;
        }
    }

    private void skipCComments() throws IOException {
        int c;
        boolean star = false;
        this.output.write("/*");
        while ((c = this.input.read()) != -1) {
            this.output.write(c);
            if (c == 42) {
                star = true;
                continue;
            }
            if (star && c == 47) break;
            star = false;
        }
    }
}

