/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.tools.SimpleResultSet;
import org.h2.util.ByteUtils;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLob;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

public abstract class Value {
    public static final int UNKNOWN = -1;
    public static final int NULL = 0;
    public static final int BOOLEAN = 1;
    public static final int BYTE = 2;
    public static final int SHORT = 3;
    public static final int INT = 4;
    public static final int LONG = 5;
    public static final int DECIMAL = 6;
    public static final int DOUBLE = 7;
    public static final int FLOAT = 8;
    public static final int TIME = 9;
    public static final int DATE = 10;
    public static final int TIMESTAMP = 11;
    public static final int BYTES = 12;
    public static final int STRING = 13;
    public static final int STRING_IGNORECASE = 14;
    public static final int BLOB = 15;
    public static final int CLOB = 16;
    public static final int ARRAY = 17;
    public static final int RESULT_SET = 18;
    public static final int JAVA_OBJECT = 19;
    public static final int UUID = 20;
    public static final int STRING_FIXED = 21;
    public static final int TYPE_COUNT = 22;
    private static WeakReference weakCache = new WeakReference<Object>(null);
    private static final BigDecimal MAX_LONG_DECIMAL = new BigDecimal("9223372036854775807");
    private static final BigDecimal MIN_LONG_DECIMAL = new BigDecimal("-9223372036854775808");

    public static int getOrder(int type) {
        switch (type) {
            case -1: {
                return 1;
            }
            case 0: {
                return 2;
            }
            case 13: {
                return 10;
            }
            case 16: {
                return 11;
            }
            case 21: {
                return 12;
            }
            case 14: {
                return 13;
            }
            case 1: {
                return 20;
            }
            case 2: {
                return 21;
            }
            case 3: {
                return 22;
            }
            case 4: {
                return 23;
            }
            case 5: {
                return 24;
            }
            case 6: {
                return 25;
            }
            case 8: {
                return 26;
            }
            case 7: {
                return 27;
            }
            case 9: {
                return 30;
            }
            case 10: {
                return 31;
            }
            case 11: {
                return 32;
            }
            case 12: {
                return 40;
            }
            case 15: {
                return 41;
            }
            case 20: {
                return 42;
            }
            case 19: {
                return 43;
            }
            case 17: {
                return 50;
            }
            case 18: {
                return 51;
            }
        }
        throw Message.getInternalError("type:" + type);
    }

    public static int getHigherOrder(int t1, int t2) throws SQLException {
        int o2;
        if (t1 == t2) {
            if (t1 == -1) {
                throw Message.getSQLException(50004, "?, ?");
            }
            return t1;
        }
        int o1 = Value.getOrder(t1);
        return o1 > (o2 = Value.getOrder(t2)) ? t1 : t2;
    }

    static Value cache(Value v) {
        if (SysProperties.OBJECT_CACHE) {
            int index;
            Value cached;
            Value[] cache = (Value[])weakCache.get();
            int hash = v.hashCode();
            if (cache == null) {
                cache = new Value[SysProperties.OBJECT_CACHE_SIZE];
                weakCache = new WeakReference<Value[]>(cache);
            }
            if ((cached = cache[index = hash & SysProperties.OBJECT_CACHE_SIZE - 1]) != null && cached.getType() == v.getType() && v.isEqual(cached)) {
                return cached;
            }
            cache[index] = v;
        }
        return v;
    }

    public abstract String getSQL();

    public abstract int getType();

    public abstract long getPrecision();

    public abstract int getDisplaySize();

    public abstract String getString() throws SQLException;

    protected abstract int compareSecure(Value var1, CompareMode var2) throws SQLException;

    protected abstract boolean isEqual(Value var1);

    public abstract Object getObject() throws SQLException;

    public abstract void set(PreparedStatement var1, int var2) throws SQLException;

    public Boolean getBoolean() throws SQLException {
        return ((ValueBoolean)this.convertTo(1)).getBoolean();
    }

    public Date getDate() throws SQLException {
        return ((ValueDate)this.convertTo(10)).getDate();
    }

    public Date getDateNoCopy() throws SQLException {
        return ((ValueDate)this.convertTo(10)).getDateNoCopy();
    }

    public Time getTime() throws SQLException {
        return ((ValueTime)this.convertTo(9)).getTime();
    }

    public Time getTimeNoCopy() throws SQLException {
        return ((ValueTime)this.convertTo(9)).getTimeNoCopy();
    }

    public Timestamp getTimestamp() throws SQLException {
        return ((ValueTimestamp)this.convertTo(11)).getTimestamp();
    }

    public Timestamp getTimestampNoCopy() throws SQLException {
        return ((ValueTimestamp)this.convertTo(11)).getTimestampNoCopy();
    }

    public byte[] getBytes() throws SQLException {
        return ((ValueBytes)this.convertTo(12)).getBytes();
    }

    public byte[] getBytesNoCopy() throws SQLException {
        return ((ValueBytes)this.convertTo(12)).getBytesNoCopy();
    }

    public byte getByte() throws SQLException {
        return ((ValueByte)this.convertTo(2)).getByte();
    }

    public short getShort() throws SQLException {
        return ((ValueShort)this.convertTo(3)).getShort();
    }

    public BigDecimal getBigDecimal() throws SQLException {
        return ((ValueDecimal)this.convertTo(6)).getBigDecimal();
    }

    public double getDouble() throws SQLException {
        return ((ValueDouble)this.convertTo(7)).getDouble();
    }

    public float getFloat() throws SQLException {
        return ((ValueFloat)this.convertTo(8)).getFloat();
    }

    public int getInt() throws SQLException {
        return ((ValueInt)this.convertTo(4)).getInt();
    }

    public long getLong() throws SQLException {
        return ((ValueLong)this.convertTo(5)).getLong();
    }

    public InputStream getInputStream() throws SQLException {
        return new ByteArrayInputStream(this.getBytesNoCopy());
    }

    public Reader getReader() throws SQLException {
        return IOUtils.getReader(this.getString());
    }

    public Value add(Value v) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public int getSignum() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public Value negate() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public Value subtract(Value v) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public Value divide(Value v) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public Value multiply(Value v) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public Value convertTo(int type) throws SQLException {
        if (this.getType() == type) {
            return this;
        }
        switch (type) {
            case 1: {
                switch (this.getType()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        return ValueBoolean.get(this.getSignum() != 0);
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 19: 
                    case 20: {
                        throw Message.getSQLException(90021, this.getString());
                    }
                }
                break;
            }
            case 2: {
                switch (this.getType()) {
                    case 1: {
                        return ValueByte.get(this.getBoolean() != false ? (byte)1 : 0);
                    }
                    case 3: {
                        return ValueByte.get(this.convertToByte(this.getShort()));
                    }
                    case 4: {
                        return ValueByte.get(this.convertToByte(this.getInt()));
                    }
                    case 5: {
                        return ValueByte.get(this.convertToByte(this.getLong()));
                    }
                    case 6: {
                        return ValueByte.get(this.convertToByte(this.convertToLong(this.getBigDecimal())));
                    }
                    case 7: {
                        return ValueByte.get(this.convertToByte(this.convertToLong(this.getDouble())));
                    }
                    case 8: {
                        return ValueByte.get(this.convertToByte(this.convertToLong(this.getFloat())));
                    }
                }
                break;
            }
            case 3: {
                switch (this.getType()) {
                    case 1: {
                        return ValueShort.get(this.getBoolean() != false ? (short)1 : 0);
                    }
                    case 2: {
                        return ValueShort.get(this.getByte());
                    }
                    case 4: {
                        return ValueShort.get(this.convertToShort(this.getInt()));
                    }
                    case 5: {
                        return ValueShort.get(this.convertToShort(this.getLong()));
                    }
                    case 6: {
                        return ValueShort.get(this.convertToShort(this.convertToLong(this.getBigDecimal())));
                    }
                    case 7: {
                        return ValueShort.get(this.convertToShort(this.convertToLong(this.getDouble())));
                    }
                    case 8: {
                        return ValueShort.get(this.convertToShort(this.convertToLong(this.getFloat())));
                    }
                }
                break;
            }
            case 4: {
                switch (this.getType()) {
                    case 1: {
                        return ValueInt.get(this.getBoolean() != false ? 1 : 0);
                    }
                    case 2: {
                        return ValueInt.get(this.getByte());
                    }
                    case 3: {
                        return ValueInt.get(this.getShort());
                    }
                    case 5: {
                        return ValueInt.get(this.convertToInt(this.getLong()));
                    }
                    case 6: {
                        return ValueInt.get(this.convertToInt(this.convertToLong(this.getBigDecimal())));
                    }
                    case 7: {
                        return ValueInt.get(this.convertToInt(this.convertToLong(this.getDouble())));
                    }
                    case 8: {
                        return ValueInt.get(this.convertToInt(this.convertToLong(this.getFloat())));
                    }
                }
                break;
            }
            case 5: {
                switch (this.getType()) {
                    case 1: {
                        return ValueLong.get(this.getBoolean() != false ? 1L : 0L);
                    }
                    case 2: {
                        return ValueLong.get(this.getByte());
                    }
                    case 3: {
                        return ValueLong.get(this.getShort());
                    }
                    case 4: {
                        return ValueLong.get(this.getInt());
                    }
                    case 6: {
                        return ValueLong.get(this.convertToLong(this.getBigDecimal()));
                    }
                    case 7: {
                        return ValueLong.get(this.convertToLong(this.getDouble()));
                    }
                    case 8: {
                        return ValueLong.get(this.convertToLong(this.getFloat()));
                    }
                }
                break;
            }
            case 6: {
                switch (this.getType()) {
                    case 1: {
                        return ValueDecimal.get(new BigDecimal(this.getBoolean() != false ? "1" : "0"));
                    }
                    case 2: {
                        return ValueDecimal.get(new BigDecimal("" + this.getByte()));
                    }
                    case 3: {
                        return ValueDecimal.get(new BigDecimal("" + this.getShort()));
                    }
                    case 4: {
                        return ValueDecimal.get(new BigDecimal("" + this.getInt()));
                    }
                    case 5: {
                        return ValueDecimal.get(new BigDecimal("" + this.getLong()));
                    }
                    case 7: {
                        double d = this.getDouble();
                        if (Double.isInfinite(d) || Double.isNaN(d)) {
                            throw Message.getSQLException(90021, "" + d);
                        }
                        return ValueDecimal.get(new BigDecimal(d));
                    }
                    case 8: {
                        float f = this.getFloat();
                        if (Float.isInfinite(f) || Float.isNaN(f)) {
                            throw Message.getSQLException(90021, "" + f);
                        }
                        return ValueDecimal.get(new BigDecimal(f));
                    }
                }
                break;
            }
            case 7: {
                switch (this.getType()) {
                    case 1: {
                        return ValueDouble.get(this.getBoolean() != false ? 1.0 : 0.0);
                    }
                    case 2: {
                        return ValueDouble.get(this.getByte());
                    }
                    case 3: {
                        return ValueDouble.get(this.getShort());
                    }
                    case 4: {
                        return ValueDouble.get(this.getInt());
                    }
                    case 5: {
                        return ValueDouble.get(this.getLong());
                    }
                    case 6: {
                        return ValueDouble.get(this.getBigDecimal().doubleValue());
                    }
                    case 8: {
                        return ValueDouble.get(this.getFloat());
                    }
                }
                break;
            }
            case 8: {
                switch (this.getType()) {
                    case 1: {
                        return ValueFloat.get(this.getBoolean() != false ? 1.0f : 0.0f);
                    }
                    case 2: {
                        return ValueFloat.get(this.getByte());
                    }
                    case 3: {
                        return ValueFloat.get(this.getShort());
                    }
                    case 4: {
                        return ValueFloat.get(this.getInt());
                    }
                    case 5: {
                        return ValueFloat.get(this.getLong());
                    }
                    case 6: {
                        return ValueFloat.get(this.getBigDecimal().floatValue());
                    }
                    case 7: {
                        return ValueFloat.get((float)this.getDouble());
                    }
                }
                break;
            }
            case 10: {
                switch (this.getType()) {
                    case 9: {
                        return ValueDate.get(new Date(this.getTimeNoCopy().getTime()));
                    }
                    case 11: {
                        return ValueDate.get(new Date(this.getTimestampNoCopy().getTime()));
                    }
                }
                break;
            }
            case 9: {
                switch (this.getType()) {
                    case 10: {
                        return ValueTime.get(new Time(this.getDateNoCopy().getTime()));
                    }
                    case 11: {
                        return ValueTime.get(new Time(this.getTimestampNoCopy().getTime()));
                    }
                }
                break;
            }
            case 11: {
                switch (this.getType()) {
                    case 9: {
                        return ValueTimestamp.getNoCopy(new Timestamp(this.getTimeNoCopy().getTime()));
                    }
                    case 10: {
                        return ValueTimestamp.getNoCopy(new Timestamp(this.getDateNoCopy().getTime()));
                    }
                }
                break;
            }
            case 12: {
                switch (this.getType()) {
                    case 15: 
                    case 19: 
                    case 20: {
                        return ValueBytes.getNoCopy(this.getBytesNoCopy());
                    }
                }
                break;
            }
            case 19: {
                switch (this.getType()) {
                    case 12: 
                    case 15: {
                        return ValueBytes.getNoCopy(this.getBytesNoCopy());
                    }
                }
                break;
            }
            case 15: {
                switch (this.getType()) {
                    case 12: {
                        return ValueLob.createSmallLob(15, this.getBytesNoCopy());
                    }
                }
                break;
            }
            case 20: {
                switch (this.getType()) {
                    case 12: {
                        return ValueUuid.get(this.getBytesNoCopy());
                    }
                }
            }
        }
        String s = this.getString();
        try {
            switch (type) {
                case 0: {
                    return ValueNull.INSTANCE;
                }
                case 1: {
                    if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("t") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("y")) {
                        return ValueBoolean.get(true);
                    }
                    if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("f") || s.equalsIgnoreCase("no") || s.equalsIgnoreCase("n")) {
                        return ValueBoolean.get(false);
                    }
                    return ValueBoolean.get(new BigDecimal(s).signum() != 0);
                }
                case 2: {
                    return ValueByte.get(MathUtils.decodeByte(s.trim()));
                }
                case 3: {
                    return ValueShort.get(MathUtils.decodeShort(s.trim()));
                }
                case 4: {
                    return ValueInt.get(MathUtils.decodeInt(s.trim()));
                }
                case 5: {
                    return ValueLong.get(MathUtils.decodeLong(s.trim()));
                }
                case 6: {
                    return ValueDecimal.get(new BigDecimal(s.trim()));
                }
                case 9: {
                    return ValueTime.get(ValueTime.parseTime(s.trim()));
                }
                case 10: {
                    return ValueDate.get(ValueDate.parseDate(s.trim()));
                }
                case 11: {
                    return ValueTimestamp.get(ValueTimestamp.parseTimestamp(s.trim()));
                }
                case 12: {
                    return ValueBytes.getNoCopy(ByteUtils.convertStringToBytes(s.trim()));
                }
                case 19: {
                    return ValueJavaObject.getNoCopy(ByteUtils.convertStringToBytes(s.trim()));
                }
                case 13: {
                    return ValueString.get(s);
                }
                case 14: {
                    return ValueStringIgnoreCase.get(s);
                }
                case 21: {
                    return ValueStringFixed.get(s);
                }
                case 7: {
                    return ValueDouble.get(Double.parseDouble(s.trim()));
                }
                case 8: {
                    return ValueFloat.get(Float.parseFloat(s.trim()));
                }
                case 16: {
                    return ValueLob.createSmallLob(16, StringUtils.utf8Encode(s));
                }
                case 15: {
                    return ValueLob.createSmallLob(15, ByteUtils.convertStringToBytes(s.trim()));
                }
                case 17: {
                    return ValueArray.get(new Value[]{ValueString.get(s)});
                }
                case 18: {
                    SimpleResultSet rs = new SimpleResultSet();
                    rs.addColumn("X", 12, s.length(), 0);
                    rs.addRow(new String[]{s});
                    return ValueResultSet.get(rs);
                }
                case 20: {
                    return ValueUuid.get(s);
                }
            }
            throw Message.getInternalError("type=" + type);
        }
        catch (NumberFormatException e) {
            throw Message.getSQLException(90021, new String[]{s}, e);
        }
    }

    public final int compareTypeSave(Value v, CompareMode mode) throws SQLException {
        if (this == ValueNull.INSTANCE) {
            return v == ValueNull.INSTANCE ? 0 : -1;
        }
        if (v == ValueNull.INSTANCE) {
            return 1;
        }
        return this.compareSecure(v, mode);
    }

    public final boolean compareEqual(Value v) throws SQLException {
        if (this == ValueNull.INSTANCE) {
            return v == ValueNull.INSTANCE;
        }
        if (v == ValueNull.INSTANCE) {
            return false;
        }
        if (this.getType() == v.getType()) {
            return this.isEqual(v);
        }
        int t2 = Value.getHigherOrder(this.getType(), v.getType());
        return this.convertTo(t2).isEqual(v.convertTo(t2));
    }

    public final int compareTo(Value v, CompareMode mode) throws SQLException {
        if (this == ValueNull.INSTANCE) {
            return v == ValueNull.INSTANCE ? 0 : -1;
        }
        if (v == ValueNull.INSTANCE) {
            return 1;
        }
        if (this.getType() == v.getType()) {
            return this.compareSecure(v, mode);
        }
        int t2 = Value.getHigherOrder(this.getType(), v.getType());
        return this.convertTo(t2).compareSecure(v.convertTo(t2), mode);
    }

    public int getScale() {
        return 0;
    }

    public Value convertScale(boolean onlyToSmallerScale, int targetScale) throws SQLException {
        return this;
    }

    public Value convertPrecision(long precision) throws SQLException {
        return this;
    }

    private byte convertToByte(long x) throws SQLException {
        if (x > 127L || x < -128L) {
            throw Message.getSQLException(22003);
        }
        return (byte)x;
    }

    private short convertToShort(long x) throws SQLException {
        if (x > 32767L || x < -32768L) {
            throw Message.getSQLException(22003);
        }
        return (short)x;
    }

    private int convertToInt(long x) throws SQLException {
        if (x > Integer.MAX_VALUE || x < Integer.MIN_VALUE) {
            throw Message.getSQLException(22003);
        }
        return (int)x;
    }

    private long convertToLong(double x) throws SQLException {
        if (x > 9.223372036854776E18 || x < -9.223372036854776E18) {
            throw Message.getSQLException(22003);
        }
        return Math.round(x);
    }

    private long convertToLong(BigDecimal x) throws SQLException {
        if (x.compareTo(MAX_LONG_DECIMAL) > 0 || x.compareTo(MIN_LONG_DECIMAL) < 0) {
            throw Message.getSQLException(22003);
        }
        return x.setScale(0, 4).longValue();
    }

    public Value link(DataHandler handler, int tableId) throws SQLException {
        return this;
    }

    public boolean isLinked() {
        return false;
    }

    public void unlink() throws SQLException {
    }

    public boolean isFileBased() {
        return false;
    }

    public void close() throws SQLException {
    }

    public boolean checkPrecision(long precision) {
        return this.getPrecision() <= precision;
    }
}

