/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.ftp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import org.h2.server.Service;
import org.h2.server.ftp.FtpControl;
import org.h2.store.fs.FileSystem;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;

public class FtpServer
implements Service {
    public static final String DEFAULT_ROOT = "ftp";
    public static final String DEFAULT_READ = "guest";
    public static final String DEFAULT_WRITE = "sa";
    public static final String DEFAULT_WRITE_PASSWORD = "sa";
    private ServerSocket serverSocket;
    private int port = 8021;
    private int openConnectionCount;
    private int maxConnectionCount = 100;
    private SimpleDateFormat dateFormatNew = new SimpleDateFormat("MMM dd HH:mm", Locale.ENGLISH);
    private SimpleDateFormat dateFormatOld = new SimpleDateFormat("MMM dd  yyyy", Locale.ENGLISH);
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private String root = "ftp";
    private String writeUserName = "sa";
    private String writePassword = "sa";
    private String readUserName = "guest";
    private HashMap tasks = new HashMap();
    private FileSystem fs;
    private boolean log;
    private boolean allowTask;
    static final String TASK_SUFFIX = ".task";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listen() {
        try {
            while (this.serverSocket != null) {
                boolean stop;
                Socket s = this.serverSocket.accept();
                FtpServer ftpServer = this;
                synchronized (ftpServer) {
                    ++this.openConnectionCount;
                    stop = this.openConnectionCount > this.maxConnectionCount;
                }
                FtpControl c = new FtpControl(s, this, stop);
                c.start();
            }
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeConnection() {
        FtpServer ftpServer = this;
        synchronized (ftpServer) {
            --this.openConnectionCount;
        }
    }

    public ServerSocket createDataSocket() throws IOException {
        ServerSocket dataSocket = new ServerSocket(0);
        return dataSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    void appendFile(StringBuffer buff, String fileName) throws SQLException {
        void var6_9;
        String date;
        buff.append(this.fs.isDirectory(fileName) ? (char)'d' : '-');
        buff.append('r');
        buff.append(this.fs.canWrite(fileName) ? (char)'w' : '-');
        buff.append("------- 1 owner group ");
        String size = String.valueOf(this.fs.length(fileName));
        for (int i = size.length(); i < 15; ++i) {
            buff.append(' ');
        }
        buff.append(size);
        buff.append(' ');
        Date now = new Date();
        Date mod = new Date(this.fs.getLastModified(fileName));
        if (mod.after(now) || Math.abs((now.getTime() - mod.getTime()) / 1000L / 60L / 60L / 24L) > 180L) {
            SimpleDateFormat simpleDateFormat = this.dateFormatOld;
            synchronized (simpleDateFormat) {
                date = this.dateFormatOld.format(mod);
            }
        }
        SimpleDateFormat simpleDateFormat = this.dateFormatNew;
        synchronized (simpleDateFormat) {
            date = this.dateFormatNew.format(mod);
        }
        buff.append((String)var6_9);
        buff.append(' ');
        buff.append(FileUtils.getFileName(fileName));
        buff.append("\r\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String formatLastModified(String fileName) {
        SimpleDateFormat simpleDateFormat = this.dateFormat;
        synchronized (simpleDateFormat) {
            return this.dateFormat.format(new Date(this.fs.getLastModified(fileName)));
        }
    }

    String getFileName(String path) {
        return this.root + this.getPath(path);
    }

    String getPath(String path) {
        if (path.indexOf("..") > 0) {
            path = "/";
        }
        while (path.startsWith("/") && this.root.endsWith("/")) {
            path = path.substring(1);
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        this.log("path: " + path);
        return path;
    }

    String getDirectoryListing(String directory, boolean listDirectories) throws SQLException {
        String[] list = this.fs.listFiles(directory);
        StringBuffer buff = new StringBuffer();
        for (int i = 0; list != null && i < list.length; ++i) {
            String fileName = list[i];
            if (this.fs.isDirectory(fileName) && (!this.fs.isDirectory(fileName) || !listDirectories)) continue;
            this.appendFile(buff, fileName);
        }
        return buff.toString();
    }

    public boolean checkUserPassword(String userName, String password) {
        return userName.equals(this.writeUserName) && password.equals(this.writePassword);
    }

    public boolean checkUserPasswordReadOnly(String userName, String param) {
        return userName.equals(this.readUserName);
    }

    public void init(String[] args) throws Exception {
        for (int i = 0; args != null && i < args.length; ++i) {
            if ("-ftpPort".equals(args[i])) {
                this.port = MathUtils.decodeInt(args[++i]);
                continue;
            }
            if ("-ftpDir".equals(args[i])) {
                this.root = FileUtils.normalize(args[++i]);
                continue;
            }
            if ("-ftpRead".equals(args[i])) {
                this.readUserName = args[++i];
                continue;
            }
            if ("-ftpWrite".equals(args[i])) {
                this.writeUserName = args[++i];
                continue;
            }
            if ("-ftpWritePassword".equals(args[i])) {
                this.writePassword = args[++i];
                continue;
            }
            if ("-log".equals(args[i])) {
                this.log = Boolean.valueOf(args[++i]);
                continue;
            }
            if (!"-ftpTask".equals(args[i])) continue;
            this.allowTask = Boolean.valueOf(args[++i]);
        }
        this.fs = FileSystem.getInstance(this.root);
        this.root = this.fs.normalize(this.root);
    }

    public String getURL() {
        return "ftp://localhost:" + this.port;
    }

    public void start() throws SQLException {
        this.fs.mkdirs(this.root);
        this.serverSocket = NetUtils.createServerSocket(this.port, false);
    }

    public void stop() {
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            this.logError(e);
        }
        this.serverSocket = null;
    }

    public boolean isRunning() {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket s = NetUtils.createLoopbackSocket(this.port, false);
            s.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean getAllowOthers() {
        return true;
    }

    public String getType() {
        return "FTP";
    }

    void log(String s) {
        if (this.log) {
            System.out.println(s);
        }
    }

    void logError(Throwable e) {
        if (this.log) {
            e.printStackTrace();
        }
    }

    public boolean getAllowTask() {
        return this.allowTask;
    }

    void startTask(String path) throws IOException {
        this.stopTask(path);
        if (path.endsWith(".zip.task")) {
            this.log("expand: " + path);
            Process p = Runtime.getRuntime().exec("jar -xf " + path, null, new File(this.root));
            new StreamRedirect(path, p.getInputStream(), null).start();
            return;
        }
        Properties prop = FileUtils.loadProperties(path);
        String command = prop.getProperty("command");
        String outFile = path.substring(0, path.length() - TASK_SUFFIX.length());
        String errorFile = this.root + "/" + prop.getProperty("error", outFile + ".err.txt");
        String outputFile = this.root + "/" + prop.getProperty("output", outFile + ".out.txt");
        this.log("start process: " + path + " / " + command);
        Process p = Runtime.getRuntime().exec(command, null, new File(this.root));
        new StreamRedirect(path, p.getErrorStream(), errorFile).start();
        new StreamRedirect(path, p.getInputStream(), outputFile).start();
        this.tasks.put(path, p);
    }

    void stopTask(String processName) {
        this.log("kill process: " + processName);
        Process p = (Process)this.tasks.remove(processName);
        if (p == null) {
            return;
        }
        p.destroy();
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    private static class StreamRedirect
    extends Thread {
        private InputStream in;
        private OutputStream out;
        private String outFile;
        private String processFile;

        StreamRedirect(String processFile, InputStream in, String outFile) {
            this.processFile = processFile;
            this.in = in;
            this.outFile = outFile;
        }

        private void openOutput() {
            if (this.outFile != null) {
                try {
                    this.out = FileUtils.openFileOutputStream(this.outFile, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.outFile = null;
            }
        }

        public void run() {
            while (true) {
                try {
                    int x;
                    while ((x = this.in.read()) >= 0) {
                        this.openOutput();
                        if (this.out == null) continue;
                        this.out.write(x);
                    }
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
            IOUtils.closeSilently(this.out);
            IOUtils.closeSilently(this.in);
            new File(this.processFile).delete();
        }
    }
}

