/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package com.kickmogu.component
{
  
	import com.kickmogu.common.GuiUtil;
	import flash.events.*;
	import mx.core.Application;
	import mx.events.MoveEvent;
	import flexmdi.containers.MDIWindow;

	[Event(name="dataUpdate", type="com.kickmogu.event.DataUpdateEvent")]
	  
	/*
	 Windowサイズの変更が起こった際に自動的にWindow位置とサイズを保存し、Window生成時に
	 元の位置、サイズで表示するクラス
	*/
	public class ResizableWindow extends flexmdi.containers.MDIWindow {
		private var windowKey:String;
		[bindable]
		public var autoPosSave:Boolean = true;
		//public static var clickedWindow:Object;

		public function ResizableWindow(key:String = null) {
		  	super();
			windowKey = key;
		  	setStyle("borderAlpha", 1);
		  	this.addEventListener("resizeEnd", savePos);
		  	this.addEventListener("dragEnd", savePos);
		  	if (autoPosSave) {
			  	com.kickmogu.common.GuiUtil.loadWindowSize(this, this.className);
		  	}
		}
		
		public function setWindowKey(key:String):void {
			windowKey = key;
		}
		
		public function getWindowKey():String {
			return windowKey;
		}
		
		private function savePos(event:Event):void{
		  	if (autoPosSave) {
			  	com.kickmogu.common.GuiUtil.saveWindowSize(this, this.className);
		  	}
		}
		
	}
}
