/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package com.kickmogu.common
{
	import mx.rpc.soap.mxml.WebService;
	import mx.events.*;
	import mx.rpc.events.*;
	import com.kickmogu.event.DataUpdateEvent;
	import flexmdi.containers.MDIWindow;
	
	public class GuiUtil
	{
		static private var instance:GuiUtil;
		private var guiWs:WebService = new WebService();
		private var loadWindow:MDIWindow;
		private var onlyOptXml:Boolean = false;
		
		static private function setGuiWs():void {
			if (instance == null) {
				instance = new GuiUtil();
				instance.guiWs.wsdl = Rhythm.getGuiUtilWsUrl();
				instance.guiWs.loadWSDL();
				instance.guiWs.showBusyCursor = true;
				instance.guiWs.addEventListener("result", instance.loadWindowSizeResultHandler);
			}			
		}
		
		static public function saveWindowSize(window:MDIWindow, winName:String, optionXml:String = ""):void {
			setGuiWs();
			instance.guiWs.saveWindowPos.send(Rhythm.getMember(), winName, int(window.x), int(window.y), int(window.height), int(window.width), optionXml);
		}

		static public function loadWindowSize(window:MDIWindow, winName:String):void {
			setGuiWs();
			instance.loadWindow = window;
			instance.guiWs.loadWindowPos.send(Rhythm.getMember(), winName);			
		}

		static public function getOptionXml(window:MDIWindow, winName:String):void {
			instance.onlyOptXml = true;
			instance.loadWindow = window;
			instance.guiWs.loadWindowPos.send(Rhythm.getMember(), winName);			
		}

		private function loadWindowSizeResultHandler(event:ResultEvent):void {
			if (event.result.result == null) {
				return;
			}
			instance.loadWindow.x = event.result.result.x;
			instance.loadWindow.y = event.result.result.y;
			instance.loadWindow.height = event.result.result.height;
			instance.loadWindow.width = event.result.result.width;
			if (event.result.result.optionXml != null
				&&  event.result.result.optionXml != "") {
				var updateEvent:DataUpdateEvent = new DataUpdateEvent(DataUpdateEvent.EVENT_TYPE, "");
				updateEvent.updateData = new XML(event.result.result.optionXml.toString());
				instance.loadWindow.dispatchEvent(updateEvent);
			}
		}
		
		private function loadOptionXmlResultHandler(event:ResultEvent):void {
			if (event.result.result == null) {
				return;
			}
			if (!instance.onlyOptXml) {
				instance.loadWindow.x = event.result.result.x;
				instance.loadWindow.y = event.result.result.y;
				instance.loadWindow.height = event.result.result.height;
				instance.loadWindow.width = event.result.result.width;
			}
			if (event.result.result.optionXml != null
				&&  event.result.result.optionXml != "") {
				var updateEvent:DataUpdateEvent = new DataUpdateEvent(DataUpdateEvent.EVENT_TYPE, "");
				updateEvent.updateData = new XML(event.result.result.optionXml.toString());
				instance.loadWindow.dispatchEvent(updateEvent);
			}
		}
	}
}