<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/SimpleTag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/RssChannel.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/RssImage09.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/RssItem.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/RssTextinput.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/DateUtil.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2006- The Rhacophorus Project. All rights reserved.
 * @version 0.1.5
 */
class RssChannel09 extends RssChannel{
	var $language = "";
	
	var $copyright = "";
	var $docs = "";
	var $lastBuildDate = "";
	var $managingEditor = "";
	var $pubDate = "";
	var $webMaster = "";
	
	var $skipDaysList = array();
	var $skipHoursList = array();
	
	var $imageList = array();
	var $itemList = array();
	var $textinputList = array();

	function RssChannel09($title="",$description="",$link="",$language=""){
		parent::RssChannel($title,$description,$link);
		$this->setLanguage($language);
	}
	function _set($tag){
		$src = $tag->get();
		
		foreach($tag->getIn("language") as $intag){
			$this->setLanguage($intag->getValue());
		}
		foreach($tag->getIn("copyright") as $intag){
			$this->setCopyright($intag->getValue());
		}
		foreach($tag->getIn("docs") as $intag){
			$this->setDocs($intag->getValue());
		}
		foreach($tag->getIn("lastBuildDate") as $intag){
			$this->setLastBuildDate($intag->getValue());
		}
		foreach($tag->getIn("managingEditor") as $intag){
			$this->setManagingEditor($intag->getValue());
		}
		foreach($tag->getIn("pubDate") as $intag){
			$this->setPubDate($intag->getValue());
		}
		foreach($tag->getIn("webMaster") as $intag){
			$this->setWebMaster($intag->getValue());
		}
		foreach($tag->getIn("skipDays") as $intag){
			foreach($tag->getIn("day") as $inintag){
				$this->skipDaysList[] = $inintag->get();
			}
		}
		foreach($tag->getIn("skipHours") as $intag){
			foreach($tag->getIn("hour") as $inintag){
				$this->skipHours[] = $inintag->get();
			}
		}
		foreach($tag->getIn("image") as $intag){
			$data = new RssImage09();
			$data->set($intag->get());
			$this->imageList[] = $data;
			
			$src = str_replace($intag->getPlain(),"",$src);			
		}
		foreach($tag->getIn("textinput") as $intag){
			$data = new RssTextinput();
			$data->set($intag->get());
			$this->textinputList[] = $data;

			$src = str_replace($intag->getPlain(),"",$src);						
		}
		foreach($tag->getIn("item") as $intag){
			$data = new RssItem();
			$data->set($intag->get());
			$this->itemList[] = $data;
			
			$src = str_replace($intag->getPlain(),"",$src);			
		}
		parent::_set(new SimpleTag("channel",$src));
	}
	function _get($outTag){
		$outTag = parent::_get($outTag);
		
		$tag = new SimpleTag("language");
		$tag->setValue($this->getLanguage());
		$outTag->addValue($tag->get());

		$tag = new SimpleTag("copyright");
		$tag->setValue($this->getCopyright());
		$outTag->addValue($tag->get());
		
		$tag = new SimpleTag("docs");
		$tag->setValue($this->getDocs());
		$outTag->addValue($tag->get());

		if(intval($this->lastBuildDate) > 0){
			$tag = new SimpleTag("lastBuildDate");
			$tag->setValue($this->getLastBuildDate());
			$outTag->addValue($tag->get());
		}
		if(intval($this->pubDate) > 0){		
			$tag = new SimpleTag("pubDate");
			$tag->setValue($this->getPubDate());
			$outTag->addValue($tag->get());
		}				
		$tag = new SimpleTag("managingEditor");
		$tag->setValue($this->getManagingEditor());
		$outTag->addValue($tag->get());

		$tag = new SimpleTag("webMaster");
		$tag->setValue($this->getWebMaster());
		$outTag->addValue($tag->get());

		$tag = new SimpleTag("skipDays");
		foreach($this->getSkipDays() as $data){
			$intag = new SimpleTag("day");
			$intag->setValue($data);
			$tag->addValue($intag->get());
		}
		$tag = new SimpleTag("skipHours");
		foreach($this->getSkipHours() as $data){
			$intag = new SimpleTag("hour");
			$intag->setValue($data);
			$tag->addValue($intag->get());
		}
		foreach($this->getImage() as $data){
			if(Variable::isClassType(RssImage09,$data)){
				$outTag->addValue($data->get());
			}
		}
		foreach($this->getTextinput() as $data){
			if(Variable::isClassType(RssTextinput,$data)){
				$outTag->addValue($data->get());
			}
		}
		foreach($this->getItem() as $data){
			if(Variable::isClassType(RssItem,$data)){
				$outTag->addValue($data->get());
			}
		}
		return $outTag;
	}
	function setLanguage($value){
		$this->language = $value;
	}
	function getLanguage(){
		return $this->language;
	}
	function setCopyright($value){
		$this->copyright = $value;
	}
	function getCopyright(){
		return $this->copyright;
	}
	function setDocs($value){
		$this->docs = $value;
	}
	function getDocs(){
		return $this->docs;
	}
	function setLastBuildDate($value){
		$this->lastBuildDate = DateUtil::parseString($value);;
	}
	function getLastBuildDate(){
		return DateUtil::formatW3C($this->lastBuildDate);
	}
	function setManagingEditor($value){
		$this->managingEditor = $value;
	}
	function getManagingEditor(){
		return $this->managingEditor;
	}
	function setPubDate($value){
		$this->pubDate = DateUtil::parseString($value);
	}
	function getPubDate(){
		return DateUtil::formatW3C($this->pubDate);
	}
	function setWebMaster($value){
		$this->webMaster = $value;
	}
	function getWebMaster(){
		return $this->webMaster;
	}	
	function setSkipDays($value){
		$this->skipDaysList[] = $value;
	}
	function getSkipDays(){
		return $this->skipDaysList;
	}
	function setSkipHours($value){
		$this->skipHoursList[] = $value;
	}
	function getSkipHours(){
		return $this->skipHoursList;
	}
	function getImage(){
		return $this->imageList;
	}
	function getItem(){
		return $this->itemList;
	}
	function getTextinput(){
		return $this->textinputList;
	}
	function setItem($titleOrObject,$description="",$link="",$about=""){
		if(Variable::isClassType(RssItem,$titleOrObject)){
			$this->itemList[] = $titleOrObject;
		}else{
			$this->itemList[] = new RssItem($titleOrObject,$description,$link,$about);
		}
	}
	function setImage($titleOrObject,$url="",$link="",$about=""){
		if(Variable::isClassType(RssImage09,$titleOrObject)){
			$this->imageList[] = $titleOrObject;
		}else{
			$this->imageList[] = new RssImage09($titleOrObject,$url,$link,$about);
		}
	}
	function setTextinput($titleOrObject,$name="",$description="",$link="",$about=""){
		if(Variable::isClassType(RssTextinput,$titleOrObject)){
			$this->textinputList[] = $titleOrObject;
		}else{
			$this->textinputList[] = new RssTextinput($titleOrObject,$name,$description,$link,$about);
		}
	}

}